/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.ImplicitReceiver;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.receivers.ThisClassReceiver;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplicitClassReceiver
implements ImplicitReceiver,
ThisClassReceiver {
    @NotNull
    private final ClassDescriptor classDescriptor;
    @NotNull
    private final ImplicitClassReceiver original;
    @NotNull
    private final ClassDescriptor declarationDescriptor;

    public ImplicitClassReceiver(@NotNull ClassDescriptor classDescriptor, @Nullable ImplicitClassReceiver original) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        this.classDescriptor = classDescriptor;
        ImplicitClassReceiver implicitClassReceiver = original;
        this.original = implicitClassReceiver == null ? this : implicitClassReceiver;
        this.declarationDescriptor = this.classDescriptor;
    }

    @Override
    @NotNull
    public final ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    @Override
    @NotNull
    public SimpleType getType() {
        SimpleType simpleType2 = this.classDescriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"classDescriptor.defaultType");
        return simpleType2;
    }

    public boolean equals(@Nullable Object other) {
        ImplicitClassReceiver implicitClassReceiver = other instanceof ImplicitClassReceiver ? (ImplicitClassReceiver)other : null;
        return Intrinsics.areEqual((Object)this.classDescriptor, (Object)(implicitClassReceiver == null ? null : implicitClassReceiver.classDescriptor));
    }

    public int hashCode() {
        return this.classDescriptor.hashCode();
    }

    @NotNull
    public String toString() {
        return "Class{" + this.getType() + '}';
    }
}

