/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.nativecerts.mac;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.platform.mac.CoreFoundation;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.nativecerts.NativeTrustedRootsInternalUtils;
import org.jetbrains.nativecerts.mac.CoreFoundationExt;
import org.jetbrains.nativecerts.mac.CoreFoundationExtUtil;
import org.jetbrains.nativecerts.mac.SecurityFramework;

public class SecurityFrameworkUtil {
    private static final Logger LOGGER = Logger.getLogger(SecurityFrameworkUtil.class.getName());
    static final String SECURITY_FRAMEWORK_LIBRARY_NAME = "Security";

    private SecurityFrameworkUtil() {
    }

    public static List<X509Certificate> getTrustedRoots() {
        return SecurityFrameworkUtil.getTrustedRoots(false);
    }

    public static List<X509Certificate> getSystemTrustedRoots() {
        return SecurityFrameworkUtil.getTrustedRoots(true);
    }

    private static List<X509Certificate> getTrustedRoots(boolean systemDomain) {
        List<X509Certificate> result = SecurityFrameworkUtil.getTrustedCertificates(systemDomain);
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder message = new StringBuilder();
            message.append("Received ").append(result.size()).append(" certificates");
            if (systemDomain) {
                message.append(" from the system keychain");
            }
            for (X509Certificate certificate : result) {
                message.append("\n  ").append(certificate.getSubjectX500Principal());
            }
            LOGGER.fine(message.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<X509Certificate> getTrustedCertificates(boolean systemDomain) {
        CoreFoundationExt.CFArrayRefByReference returnedCertArray = new CoreFoundationExt.CFArrayRefByReference();
        SecurityFramework.SecKeychainRefByReference keychain = new SecurityFramework.SecKeychainRefByReference();
        CoreFoundation.CFArrayRef searchDomainList = null;
        CoreFoundation.CFArrayRef certArray = null;
        CoreFoundation.CFDictionaryRef query = null;
        try {
            SecurityFramework.OSStatus rc;
            HashMap<CoreFoundation.CFTypeRef, CoreFoundation.CFTypeRef> map = new HashMap<CoreFoundation.CFTypeRef, CoreFoundation.CFTypeRef>();
            map.put((CoreFoundation.CFTypeRef)SecurityFramework.kSecClass, (CoreFoundation.CFTypeRef)SecurityFramework.kSecClassCertificate);
            map.put((CoreFoundation.CFTypeRef)SecurityFramework.kSecMatchLimit, (CoreFoundation.CFTypeRef)SecurityFramework.kSecMatchLimitAll);
            map.put((CoreFoundation.CFTypeRef)SecurityFramework.kSecReturnRef, (CoreFoundation.CFTypeRef)CoreFoundationExt.kCFBooleanTrue);
            if (systemDomain) {
                rc = SecurityFramework.INSTANCE.SecKeychainOpen("/System/Library/Keychains/SystemRootCertificates.keychain", keychain);
                if (!SecurityFramework.OSStatus.errSecSuccess.equals((Object)rc)) {
                    throw new IllegalStateException("Failed to read system keychain: " + String.valueOf((Object)rc));
                }
                searchDomainList = CoreFoundation.INSTANCE.CFArrayCreate(null, keychain.getPointer(), new CoreFoundation.CFIndex(1L), null);
                map.put((CoreFoundation.CFTypeRef)SecurityFramework.kSecMatchSearchList, (CoreFoundation.CFTypeRef)searchDomainList);
            }
            if (!SecurityFramework.OSStatus.errSecSuccess.equals((Object)(rc = SecurityFramework.INSTANCE.SecItemCopyMatching(query = CoreFoundationExtUtil.createDictionary(map), returnedCertArray)))) {
                throw new IllegalStateException("SecItemCopyMatching failed: " + String.valueOf((Object)rc));
            }
            certArray = returnedCertArray.getArray();
            if (certArray == null) {
                List<X509Certificate> list = Collections.emptyList();
                return list;
            }
            ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
            for (int i = 0; i < certArray.getCount(); ++i) {
                String certificateDescription;
                SecurityFramework.SecCertificateRef secCertificateRef;
                block19: {
                    secCertificateRef = new SecurityFramework.SecCertificateRef(certArray.getValueAtIndex(i));
                    if (!systemDomain) {
                        try {
                            boolean trustedRoot = SecurityFrameworkUtil.isTrustedRoot(secCertificateRef);
                            if (!trustedRoot) {
                                certificateDescription = CoreFoundationExtUtil.getDescription(secCertificateRef);
                                LOGGER.fine("Certificate '" + certificateDescription + "' has failed to validate against trusted roots");
                            }
                            break block19;
                        }
                        catch (Throwable validateException) {
                            certificateDescription = CoreFoundationExtUtil.getDescription(secCertificateRef);
                            LOGGER.warning(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to check certificate '" + certificateDescription + "'", validateException));
                        }
                        continue;
                    }
                }
                try {
                    result.add(SecurityFrameworkUtil.getX509Certificate(secCertificateRef));
                    continue;
                }
                catch (Throwable parsingError) {
                    certificateDescription = CoreFoundationExtUtil.getDescription(secCertificateRef);
                    LOGGER.warning(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to parse certificate '" + certificateDescription + "'", parsingError));
                }
            }
            ArrayList<X509Certificate> arrayList = result;
            return arrayList;
        }
        finally {
            SecurityFramework.SecKeychainRef secKeychainRef;
            if (query != null) {
                query.release();
            }
            if (certArray != null) {
                certArray.release();
            }
            if (searchDomainList != null) {
                searchDomainList.release();
            }
            if ((secKeychainRef = keychain.getSecKeychainRef()) != null) {
                secKeychainRef.release();
            }
        }
    }

    private static X509Certificate getX509Certificate(SecurityFramework.SecCertificateRef secCertificateRef) {
        CoreFoundation.CFDataRef data = SecurityFramework.INSTANCE.SecCertificateCopyData(secCertificateRef);
        try {
            byte[] bytes = data.getBytePtr().getByteArray(0L, data.getLength());
            X509Certificate x509Certificate = NativeTrustedRootsInternalUtils.parseCertificate(bytes);
            return x509Certificate;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            data.release();
        }
    }

    static boolean isSelfSignedCertificate(X509Certificate certificate) {
        if (!certificate.getSubjectX500Principal().equals(certificate.getIssuerX500Principal())) {
            return false;
        }
        try {
            certificate.verify(certificate.getPublicKey());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static CoreFoundationExt.Error validateCertificate(SecurityFramework.SecCertificateRef certificateRef) {
        SecurityFramework.SecPolicyRef policy = null;
        SecurityFramework.SecTrustRefByReference secTrustRefByReference = null;
        CoreFoundation.CFArrayRef subjCerts = null;
        try {
            subjCerts = CoreFoundationExtUtil.createArray(new CoreFoundation.CFTypeRef[]{certificateRef});
            secTrustRefByReference = new SecurityFramework.SecTrustRefByReference();
            policy = SecurityFramework.INSTANCE.SecPolicyCreateSSL(false, null);
            SecurityFramework.OSStatus rc = SecurityFramework.INSTANCE.SecTrustCreateWithCertificates(subjCerts, policy, secTrustRefByReference);
            if (!SecurityFramework.OSStatus.errSecSuccess.equals((Object)rc)) {
                String description = "Failed to create trust object: " + String.valueOf((Object)rc);
                LOGGER.warning(description);
                CoreFoundationExt.Error error = rc.toError();
                return error;
            }
            CoreFoundationExt.CFErrorRef.ByReference errorRef = new CoreFoundationExt.CFErrorRef.ByReference();
            boolean trusted = SecurityFramework.INSTANCE.SecTrustEvaluateWithError(secTrustRefByReference.getSecTrustRef(), errorRef);
            if (!trusted) {
                CoreFoundationExt.CFErrorRef error = errorRef.getErrorRefValue();
                CoreFoundationExt.Error error2 = error.toError();
                return error2;
            }
            CoreFoundationExt.Error error = null;
            return error;
        }
        finally {
            SecurityFramework.SecTrustRef secTrustRef;
            if (policy != null) {
                policy.release();
            }
            if (secTrustRefByReference != null && (secTrustRef = secTrustRefByReference.getSecTrustRef()) != null) {
                secTrustRef.release();
            }
            if (subjCerts != null) {
                subjCerts.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTrustedRoot(SecurityFramework.SecCertificateRef certificateRef) {
        boolean selfSignedCertificate = SecurityFrameworkUtil.isSelfSignedCertificate(SecurityFrameworkUtil.getX509Certificate(certificateRef));
        CoreFoundationExt.CFArrayRefByReference trustedSettingsRef = SecurityFrameworkUtil.copyTrustSettings(certificateRef);
        CoreFoundation.CFArrayRef trustedSettingsArray = trustedSettingsRef == null ? null : trustedSettingsRef.getArray();
        try {
            String certificateDescription = CoreFoundationExtUtil.getDescription(certificateRef);
            if (trustedSettingsArray == null) {
                CoreFoundationExt.Error error = SecurityFrameworkUtil.validateCertificate(certificateRef);
                if (error == null) {
                    boolean bl = true;
                    return bl;
                }
                LOGGER.fine("Certificate '" + certificateDescription + "' has no trust settings and failed to validate against trusted roots: " + String.valueOf(error));
                boolean bl = false;
                return bl;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                try {
                    String description = CoreFoundationExtUtil.getDescription((CoreFoundation.CFTypeRef)trustedSettingsArray);
                    LOGGER.fine("Certificate '" + certificateDescription + "' trust settings:\n" + description);
                }
                catch (Throwable t) {
                    LOGGER.warning(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to describe certificate trusted settings", t));
                }
            }
            if (trustedSettingsArray.getCount() == 0) {
                boolean t = true;
                return t;
            }
            for (int i = 0; i < trustedSettingsArray.getCount(); ++i) {
                SecurityFramework.SecTrustSettingsResult result;
                CoreFoundation.CFDictionaryRef constraints = new CoreFoundation.CFDictionaryRef(trustedSettingsArray.getValueAtIndex(i));
                CoreFoundation.CFIndex constraintsCount = CoreFoundationExt.INSTANCE.CFDictionaryGetCount(constraints);
                int processedConstrains = 0;
                Pointer value = constraints.getValue((PointerType)SecurityFramework.kSecTrustSettingsResult);
                if (value == null) {
                    result = SecurityFramework.SecTrustSettingsResult.kSecTrustSettingsResultTrustRoot;
                } else {
                    CoreFoundation.CFNumberRef resultNumber = new CoreFoundation.CFNumberRef(value);
                    result = new SecurityFramework.SecTrustSettingsResult(resultNumber.longValue());
                    ++processedConstrains;
                }
                if (!result.equals((Object)SecurityFramework.SecTrustSettingsResult.kSecTrustSettingsResultTrustRoot)) continue;
                if (!selfSignedCertificate) {
                    LOGGER.warning("Certificate '" + certificateDescription + "' is not self-signed, skipping");
                    continue;
                }
                if (constraints.getValue((PointerType)SecurityFramework.kSecTrustSettingsAllowedError) != null) {
                    ++processedConstrains;
                }
                if (constraints.getValue((PointerType)SecurityFramework.kSecTrustSettingsPolicyName) != null) {
                    ++processedConstrains;
                }
                if ((value = constraints.getValue((PointerType)SecurityFramework.kSecTrustSettingsPolicy)) != null) {
                    SecurityFramework.SecPolicyRef secPolicyRef = new SecurityFramework.SecPolicyRef(value);
                    CoreFoundation.CFDictionaryRef policyDictionaryRef = SecurityFramework.INSTANCE.SecPolicyCopyProperties(secPolicyRef);
                    try {
                        CoreFoundation.CFStringRef policyOidStringRef;
                        Pointer policyOid = policyDictionaryRef.getValue((PointerType)SecurityFramework.kSecPolicyOid);
                        if (policyOid == null || !CoreFoundationExt.INSTANCE.CFEqual((CoreFoundation.CFTypeRef)SecurityFramework.kSecPolicyAppleSSL, (CoreFoundation.CFTypeRef)(policyOidStringRef = new CoreFoundation.CFStringRef(policyOid)))) {
                            continue;
                        }
                    }
                    finally {
                        policyDictionaryRef.release();
                    }
                    ++processedConstrains;
                }
                if (constraintsCount.longValue() != (long)processedConstrains) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (trustedSettingsArray != null) {
                trustedSettingsArray.release();
            }
        }
    }

    @Nullable
    private static CoreFoundationExt.CFArrayRefByReference copyTrustSettings(SecurityFramework.SecCertificateRef certificateRef) {
        CoreFoundationExt.CFArrayRefByReference trustedSettingsRef = SecurityFrameworkUtil.copyTrustSettings(certificateRef, SecurityFramework.SecTrustSettingsDomain.user);
        if (trustedSettingsRef == null) {
            trustedSettingsRef = SecurityFrameworkUtil.copyTrustSettings(certificateRef, SecurityFramework.SecTrustSettingsDomain.admin);
        }
        return trustedSettingsRef;
    }

    @Nullable
    private static CoreFoundationExt.CFArrayRefByReference copyTrustSettings(SecurityFramework.SecCertificateRef certificateRef, SecurityFramework.SecTrustSettingsDomain domain) {
        CoreFoundationExt.CFArrayRefByReference trustedSettingsRef = new CoreFoundationExt.CFArrayRefByReference();
        SecurityFramework.OSStatus rc = SecurityFramework.INSTANCE.SecTrustSettingsCopyTrustSettings(certificateRef, domain, trustedSettingsRef);
        if (SecurityFramework.OSStatus.errSecItemNotFound.equals((Object)rc)) {
            return null;
        }
        if (!SecurityFramework.OSStatus.errSecSuccess.equals((Object)rc)) {
            String certificateDescription = CoreFoundationExtUtil.getDescription(certificateRef);
            throw new IllegalStateException("Failed to get trust settings for certificate '" + certificateDescription + "': " + String.valueOf(rc.toError()));
        }
        return trustedSettingsRef;
    }
}

