/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.model.hyperlinks.LinkInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HyperlinkStyle
extends TextStyle {
    @NotNull
    private final LinkInfo myLinkInfo;
    @NotNull
    private final TextStyle myHighlightStyle;
    @Nullable
    private final TextStyle myPrevTextStyle;
    @NotNull
    private final HighlightMode myHighlightMode;

    public HyperlinkStyle(@NotNull TextStyle prevTextStyle, @NotNull LinkInfo hyperlinkInfo) {
        this(prevTextStyle.getForeground(), prevTextStyle.getBackground(), hyperlinkInfo, HighlightMode.HOVER, prevTextStyle);
    }

    public HyperlinkStyle(@Nullable TerminalColor foreground, @Nullable TerminalColor background, @NotNull LinkInfo hyperlinkInfo, @NotNull HighlightMode mode, @Nullable TextStyle prevTextStyle) {
        this(false, foreground, background, hyperlinkInfo, mode, prevTextStyle);
    }

    private HyperlinkStyle(boolean keepColors, @Nullable TerminalColor foreground, @Nullable TerminalColor background, @NotNull LinkInfo hyperlinkInfo, @NotNull HighlightMode mode, @Nullable TextStyle prevTextStyle) {
        super(keepColors ? foreground : null, keepColors ? background : null);
        this.myHighlightStyle = new TextStyle.Builder().setBackground(background).setForeground(foreground).setOption(TextStyle.Option.UNDERLINED, true).build();
        this.myLinkInfo = hyperlinkInfo;
        this.myHighlightMode = mode;
        this.myPrevTextStyle = prevTextStyle;
    }

    @Nullable
    public TextStyle getPrevTextStyle() {
        return this.myPrevTextStyle;
    }

    @NotNull
    public TextStyle getHighlightStyle() {
        return this.myHighlightStyle;
    }

    @NotNull
    public LinkInfo getLinkInfo() {
        return this.myLinkInfo;
    }

    @NotNull
    public HighlightMode getHighlightMode() {
        return this.myHighlightMode;
    }

    @Override
    @NotNull
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends TextStyle.Builder {
        @NotNull
        private LinkInfo myLinkInfo;
        @NotNull
        private TextStyle myHighlightStyle;
        @Nullable
        private TextStyle myPrevTextStyle;
        @NotNull
        private HighlightMode myHighlightMode;

        private Builder(@NotNull HyperlinkStyle style) {
            this.myLinkInfo = style.myLinkInfo;
            this.myHighlightStyle = style.myHighlightStyle;
            this.myPrevTextStyle = style.myPrevTextStyle;
            this.myHighlightMode = style.myHighlightMode;
        }

        @Override
        @NotNull
        public HyperlinkStyle build() {
            return this.build(false);
        }

        @NotNull
        public HyperlinkStyle build(boolean keepColors) {
            TerminalColor foreground = this.myHighlightStyle.getForeground();
            TerminalColor background = this.myHighlightStyle.getBackground();
            if (keepColors) {
                TextStyle style = super.build();
                foreground = style.getForeground() != null ? style.getForeground() : this.myHighlightStyle.getForeground();
                background = style.getBackground() != null ? style.getBackground() : this.myHighlightStyle.getBackground();
            }
            return new HyperlinkStyle(keepColors, foreground, background, this.myLinkInfo, this.myHighlightMode, this.myPrevTextStyle);
        }
    }

    public static enum HighlightMode {
        ALWAYS,
        NEVER,
        HOVER;

    }
}

