﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ssm-contacts/SSMContacts_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SSMContacts {
namespace Model {
class CreateRotationResult {
 public:
  AWS_SSMCONTACTS_API CreateRotationResult() = default;
  AWS_SSMCONTACTS_API CreateRotationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SSMCONTACTS_API CreateRotationResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the created rotation.</p>
   */
  inline const Aws::String& GetRotationArn() const { return m_rotationArn; }
  template <typename RotationArnT = Aws::String>
  void SetRotationArn(RotationArnT&& value) {
    m_rotationArnHasBeenSet = true;
    m_rotationArn = std::forward<RotationArnT>(value);
  }
  template <typename RotationArnT = Aws::String>
  CreateRotationResult& WithRotationArn(RotationArnT&& value) {
    SetRotationArn(std::forward<RotationArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateRotationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_rotationArn;

  Aws::String m_requestId;
  bool m_rotationArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SSMContacts
}  // namespace Aws
