﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/EC2_EXPORTS.h>

namespace Aws {
namespace EC2 {
namespace Model {
enum class GatewayAssociationState { NOT_SET, associated, not_associated, associating, disassociating };

namespace GatewayAssociationStateMapper {
AWS_EC2_API GatewayAssociationState GetGatewayAssociationStateForName(const Aws::String& name);

AWS_EC2_API Aws::String GetNameForGatewayAssociationState(GatewayAssociationState value);
}  // namespace GatewayAssociationStateMapper
}  // namespace Model
}  // namespace EC2
}  // namespace Aws
