/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.annotation.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.util.ArrayUtil;

public class MultiAnnotationVisitor
implements AnnotationVisitor {
    private AnnotationVisitor[] annotationVisitors;
    private int annotationVisitorCount;

    public MultiAnnotationVisitor() {
        this.annotationVisitors = new AnnotationVisitor[16];
    }

    public MultiAnnotationVisitor(AnnotationVisitor ... annotationVisitors) {
        this.annotationVisitors = annotationVisitors;
        this.annotationVisitorCount = annotationVisitors.length;
    }

    public void addAnnotationVisitor(AnnotationVisitor annotationVisitor) {
        this.annotationVisitors = ArrayUtil.add(this.annotationVisitors, this.annotationVisitorCount++, annotationVisitor);
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        for (int index = 0; index < this.annotationVisitorCount; ++index) {
            this.annotationVisitors[index].visitAnnotation(clazz, annotation);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Field field, Annotation annotation) {
        for (int index = 0; index < this.annotationVisitorCount; ++index) {
            this.annotationVisitors[index].visitAnnotation(clazz, field, annotation);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Method method, Annotation annotation) {
        for (int index = 0; index < this.annotationVisitorCount; ++index) {
            this.annotationVisitors[index].visitAnnotation(clazz, method, annotation);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Method method, int parameterIndex, Annotation annotation) {
        for (int index = 0; index < this.annotationVisitorCount; ++index) {
            this.annotationVisitors[index].visitAnnotation(clazz, method, parameterIndex, annotation);
        }
    }

    @Override
    public void visitAnnotation(Clazz clazz, Method method, CodeAttribute codeAttribute, Annotation annotation) {
        for (int index = 0; index < this.annotationVisitorCount; ++index) {
            this.annotationVisitors[index].visitAnnotation(clazz, method, codeAttribute, annotation);
        }
    }
}

