"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs = __importStar(require("node:fs/promises"));
const os = __importStar(require("node:os"));
const path = __importStar(require("node:path"));
const commands_1 = require("./commands");
const download_1 = require("./download");
jest.setTimeout(20000);
describe("e2e test", () => {
    test("be able to generate keys, sign and verify signature", async () => {
        const extensionDestination = await (0, download_1.download)("https://open-vsx.org/api/jeanp413/open-remote-ssh/0.0.33/file/jeanp413.open-remote-ssh-0.0.33.vsix", {});
        const tmpDir = await fs.mkdtemp(path.join(os.tmpdir(), "ovsx-"));
        const archiveOutputPath = path.join(tmpDir, "extension.sigzip");
        const { privateKeyPath, publicKeyPath } = await (0, commands_1.keyPair)({ outputDir: tmpDir, overwrite: false });
        await (0, commands_1.sign)(extensionDestination, privateKeyPath, { output: archiveOutputPath });
        expect(await (0, commands_1.verify)(extensionDestination, archiveOutputPath, true, {
            publicKey: publicKeyPath,
            verifySignatureManifest: true,
        })).toBe(true);
        // Clean up
        await fs.unlink(extensionDestination);
        await fs.unlink(archiveOutputPath);
        await fs.unlink(privateKeyPath);
        await fs.unlink(publicKeyPath);
        console.log(`Deleted ${extensionDestination}`);
    });
});//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/bf9252a2fb45be6893dd8870c0bf37e2e1766d61/node_modules/node-ovsx-sign/lib/utils/commands.test.js.map