/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.CopiedImageSources;
import com.lightdev.app.shtm.SHTMLDocumentParser;
import com.lightdev.app.shtm.SHTMLWriter;
import com.lightdev.app.shtm.UnknownDocumentBaseException;
import com.lightdev.app.shtm.Util;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.stream.Stream;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.DocumentParser;
import javax.swing.text.html.parser.ParserDelegator;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class SHTMLDocument
extends HTMLDocument {
    static final HTMLEditorKit.Parser defaultParser = new ParserDelegator(){

        @Override
        public void parse(Reader r, HTMLEditorKit.ParserCallback cb, boolean ignoreCharSet) throws IOException {
            1.setDefaultDTD();
            SHTMLDocumentParser documentParser = new SHTMLDocumentParser(DTD.getDTD("html32"));
            ((DocumentParser)documentParser).parse(r, cb, ignoreCharSet);
        }
    };
    public static final String SUFFIX = "&nbsp;";
    private CompoundEdit compoundEdit = null;
    private int compoundEditDepth;
    private boolean inSetParagraphAttributes = false;
    private CopiedImageSources copiedExternalImagesSources = CopiedImageSources.NONE;
    private int suffixLength = 0;
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyMMdd-HHmmssSSS");

    public SHTMLDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new StyleSheet());
    }

    public SHTMLDocument(StyleSheet styles) {
        this((AbstractDocument.Content)new GapContent(4096), styles);
    }

    public SHTMLDocument(AbstractDocument.Content c, StyleSheet styles) {
        super(c, styles);
        this.setParser(defaultParser);
    }

    @Override
    protected AbstractDocument.AbstractElement createDefaultRoot() {
        this.writeLock();
        SimpleAttributeSet a = new SimpleAttributeSet();
        a.addAttribute(StyleConstants.NameAttribute, HTML.Tag.HTML);
        HTMLDocument.BlockElement html = new HTMLDocument.BlockElement(this, null, a.copyAttributes());
        a.removeAttributes(a);
        a.addAttribute(StyleConstants.NameAttribute, HTML.Tag.BODY);
        HTMLDocument.BlockElement body = new HTMLDocument.BlockElement(this, (Element)html, a.copyAttributes());
        a.removeAttributes(a);
        a.addAttribute(StyleConstants.NameAttribute, HTML.Tag.P);
        HTMLDocument.BlockElement paragraph = new HTMLDocument.BlockElement(this, (Element)body, a.copyAttributes());
        a.removeAttributes(a);
        a.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
        HTMLDocument.RunElement brk = new HTMLDocument.RunElement(this, (Element)paragraph, (AttributeSet)a, 0, 1);
        Element[] buff = new Element[]{brk};
        paragraph.replace(0, 0, buff);
        buff[0] = paragraph;
        body.replace(0, 0, buff);
        buff[0] = body;
        html.replace(0, 0, buff);
        this.writeUnlock();
        return html;
    }

    void setSuffix(String suffix) {
        try {
            Element root = this.getDefaultRootElement();
            Element body = root.getElement(root.getElementCount() - 1);
            super.insertBeforeEnd(body, suffix);
            Element suffixParagraph = body.getElement(body.getElementCount() - 1);
            this.suffixLength = this.getLength() - suffixParagraph.getStartOffset();
        }
        catch (IOException | BadLocationException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttributes(Element e, AttributeSet a) {
        if (e != null && a != null) {
            try {
                this.writeLock();
                int start = e.getStartOffset();
                AbstractDocument.DefaultDocumentEvent changes = new AbstractDocument.DefaultDocumentEvent(this, start, e.getEndOffset() - start, DocumentEvent.EventType.CHANGE);
                AttributeSet sCopy = a.copyAttributes();
                MutableAttributeSet attr = (MutableAttributeSet)e.getAttributes();
                changes.addEdit(new DefaultStyledDocument.AttributeUndoableEdit(e, sCopy, false));
                attr.addAttributes(a);
                changes.end();
                this.fireChangedUpdate(changes);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, changes));
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElements(Element element, int index, int count) throws BadLocationException {
        this.writeLock();
        int start = element.getElement(index).getStartOffset();
        int end = element.getElement(index + count - 1).getEndOffset();
        try {
            Element[] removed = new Element[count];
            Element[] added = new Element[]{};
            for (int counter = 0; counter < count; ++counter) {
                removed[counter] = element.getElement(counter + index);
            }
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, start, end - start, DocumentEvent.EventType.REMOVE);
            ((AbstractDocument.BranchElement)element).replace(index, removed.length, added);
            defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(element, index, removed, added));
            UndoableEdit undoableEdit = this.getContent().remove(start, end - start);
            if (undoableEdit != null) {
                defaultDocumentEvent.addEdit(undoableEdit);
            }
            this.postRemoveUpdate(defaultDocumentEvent);
            defaultDocumentEvent.end();
            this.fireRemoveUpdate(defaultDocumentEvent);
            if (undoableEdit != null) {
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOuterHTML(Element paragraphElement, String htmlText) throws BadLocationException, IOException {
        try {
            this.startCompoundEdit();
            if (paragraphElement.getName().equalsIgnoreCase("p-implied")) {
                int i;
                Element parentElement = paragraphElement.getParentElement();
                SHTMLWriter writer = new SHTMLWriter(this);
                int indexOfElement = parentElement.getElementIndex(paragraphElement.getStartOffset());
                writer.writeStartTag(parentElement);
                for (i = 0; i < indexOfElement; ++i) {
                    writer.write(parentElement.getElement(i));
                }
                writer.write(htmlText);
                for (i = indexOfElement + 1; i < parentElement.getElementCount(); ++i) {
                    writer.write(parentElement.getElement(i));
                }
                writer.writeEndTag(parentElement);
                super.setOuterHTML(parentElement, writer.toString());
            } else {
                super.setOuterHTML(paragraphElement, htmlText);
            }
        }
        finally {
            this.endCompoundEdit();
        }
    }

    @Override
    public void insertAfterEnd(Element elem, String htmlText) throws BadLocationException, IOException {
        try {
            this.startCompoundEdit();
            super.insertAfterEnd(elem, htmlText);
        }
        finally {
            this.endCompoundEdit();
        }
    }

    @Override
    public void insertAfterStart(Element elem, String htmlText) throws BadLocationException, IOException {
        try {
            this.startCompoundEdit();
            super.insertAfterStart(elem, htmlText);
        }
        finally {
            this.endCompoundEdit();
        }
    }

    @Override
    public void insertBeforeEnd(Element elem, String htmlText) throws BadLocationException, IOException {
        try {
            this.startCompoundEdit();
            super.insertBeforeEnd(elem, htmlText);
        }
        finally {
            this.endCompoundEdit();
        }
    }

    @Override
    public void insertBeforeStart(Element elem, String htmlText) throws BadLocationException, IOException {
        try {
            this.startCompoundEdit();
            super.insertBeforeStart(elem, htmlText);
        }
        finally {
            this.endCompoundEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Exception> void copyingExternalImages(CopiedImageSources copiedExternalImagesSources, ThrowingRunnable<T> runnable) throws T {
        CopiedImageSources copiedExternalImagesSourcesBackup = this.copiedExternalImagesSources;
        this.copiedExternalImagesSources = copiedExternalImagesSources;
        try {
            runnable.run();
        }
        finally {
            this.copiedExternalImagesSources = copiedExternalImagesSourcesBackup;
        }
    }

    @Override
    protected void insert(int offset, DefaultStyledDocument.ElementSpec[] data) throws BadLocationException {
        this.copyExternalImages(data);
        super.insert(offset, data);
    }

    private void copyExternalImages(DefaultStyledDocument.ElementSpec[] data) {
        if (this.copiedExternalImagesSources == CopiedImageSources.NONE) {
            return;
        }
        URL base = this.getBase();
        if (base == null || !base.getProtocol().equalsIgnoreCase("file")) {
            return;
        }
        try {
            Stream.of(data).forEach(this::copyExternalImagesForElementSpec);
        }
        catch (UnknownDocumentBaseException e) {
            Util.errMsg(null, e.getMessage(), null);
        }
    }

    private void copyExternalImagesForElementSpec(DefaultStyledDocument.ElementSpec data) {
        AttributeSet attributes = data.getAttributes();
        if (!(attributes instanceof MutableAttributeSet) || !HTML.Tag.IMG.equals(attributes.getAttribute(StyleConstants.NameAttribute))) {
            return;
        }
        String source = (String)attributes.getAttribute(HTML.Attribute.SRC);
        if (!this.copiedExternalImagesSources.includes(source)) {
            return;
        }
        try {
            URLConnection connection;
            String contentType;
            String imageExtension;
            URL sourceUrl = new URL(this.getBase(), source);
            File imageDirectory = this.getImageDirectory().getCanonicalFile();
            if (sourceUrl.getProtocol().equalsIgnoreCase("file")) {
                File sourceFile = new File(sourceUrl.getPath()).getCanonicalFile();
                String basePath = imageDirectory.getPath() + File.separatorChar;
                if (sourceFile.getPath().startsWith(basePath)) {
                    String updatedSource = sourceFile.getPath().substring(basePath.length()).replace(File.separatorChar, '/');
                    if (!updatedSource.equals(source)) {
                        ((MutableAttributeSet)attributes).addAttribute(HTML.Attribute.SRC, updatedSource);
                    }
                    return;
                }
            }
            if ((imageExtension = SHTMLDocument.getExtensionFromContentType(contentType = (connection = sourceUrl.openConnection()).getContentType())) == null) {
                return;
            }
            imageDirectory.mkdirs();
            File imageCopy = File.createTempFile(SHTMLDocument.createImageFileNamePrefix(), "." + imageExtension, imageDirectory);
            try (ReadableByteChannel rbc = Channels.newChannel(connection.getInputStream());
                 FileOutputStream fos = new FileOutputStream(imageCopy);){
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                ((MutableAttributeSet)attributes).addAttribute(HTML.Attribute.SRC, imageDirectory.getName() + '/' + imageCopy.getName());
            }
        }
        catch (UnknownDocumentBaseException e) {
            ((MutableAttributeSet)attributes).addAttribute(HTML.Attribute.SRC, "");
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String createImageFileNamePrefix() {
        LocalDateTime currentTime = LocalDateTime.now();
        String formattedTime = currentTime.format(TIME_FORMATTER);
        return "image-" + formattedTime + "-";
    }

    private static String getExtensionFromContentType(String contentType) {
        if (contentType != null && contentType.toLowerCase().startsWith("image/")) {
            return contentType.substring("image/".length()).toLowerCase();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceHTML(Element firstElement, int number, String htmlText) throws BadLocationException, IOException {
        if (number > 1) {
            if (firstElement != null && firstElement.getParentElement() != null && htmlText != null) {
                int start = firstElement.getStartOffset();
                Element parent = firstElement.getParentElement();
                int removeIndex = parent.getElementIndex(start);
                try {
                    this.startCompoundEdit();
                    this.removeElements(parent, removeIndex, number - 1);
                    this.setOuterHTML(parent.getElement(removeIndex), htmlText);
                }
                finally {
                    this.endCompoundEdit();
                }
            }
        } else if (number == 1) {
            this.setOuterHTML(firstElement, htmlText);
        }
    }

    public void startCompoundEdit() {
        ++this.compoundEditDepth;
    }

    public void endCompoundEdit() {
        if (this.compoundEditDepth != 0) {
            --this.compoundEditDepth;
            if (this.compoundEditDepth == 0 && this.compoundEdit != null) {
                this.compoundEdit.end();
                super.fireUndoableEditUpdate(new UndoableEditEvent(this, this.compoundEdit));
                this.compoundEdit = null;
            }
        }
    }

    @Override
    protected void fireUndoableEditUpdate(UndoableEditEvent e) {
        if (this.compoundEditDepth == 0) {
            super.fireUndoableEditUpdate(e);
        } else {
            if (this.compoundEdit == null) {
                this.compoundEdit = new CompoundEdit();
            }
            this.compoundEdit.addEdit(e.getEdit());
        }
    }

    public void setDocumentTitle(String title) {
        try {
            String titleHTML = "<title></title>";
            Element defaultRoot = this.getDefaultRootElement();
            Element head = Util.findElementDown(HTML.Tag.HEAD.toString(), defaultRoot);
            if (head != null) {
                Element tElem;
                Element pImpl = Util.findElementDown(HTML.Tag.IMPLIED.toString(), head);
                if (pImpl != null && (tElem = Util.findElementDown(HTML.Tag.TITLE.toString(), pImpl)) == null) {
                    this.insertBeforeEnd(pImpl, "<title></title>");
                }
            } else {
                Element body = Util.findElementDown(HTML.Tag.BODY.toString(), defaultRoot);
                this.insertBeforeStart(body, "<head><title></title></head>");
            }
            this.putProperty("title", title);
        }
        catch (Exception e) {
            Util.errMsg(null, "An exception occurred while trying to insert the title", e);
        }
    }

    public String getDocumentTitle() {
        Object title = this.getProperty("title");
        if (title != null) {
            return title.toString();
        }
        return null;
    }

    public void insertStyleRef() {
        try {
            String styleRef = "  <link rel=stylesheet type=\"text/css\" href=\"style.css\">";
            Element defaultRoot = this.getDefaultRootElement();
            Element head = Util.findElementDown(HTML.Tag.HEAD.toString(), defaultRoot);
            if (head != null) {
                Element pImpl = Util.findElementDown(HTML.Tag.IMPLIED.toString(), head);
                if (pImpl != null) {
                    Element link = Util.findElementDown(HTML.Tag.LINK.toString(), pImpl);
                    if (link != null) {
                        this.setOuterHTML(link, "  <link rel=stylesheet type=\"text/css\" href=\"style.css\">");
                    } else {
                        this.insertBeforeEnd(pImpl, "  <link rel=stylesheet type=\"text/css\" href=\"style.css\">");
                    }
                }
            } else {
                Element body = Util.findElementDown(HTML.Tag.BODY.toString(), defaultRoot);
                this.insertBeforeStart(body, "<head>  <link rel=stylesheet type=\"text/css\" href=\"style.css\"></head>");
            }
        }
        catch (Exception e) {
            Util.errMsg(null, "An exception occurred while trying to insert the style sheet reference link", e);
        }
    }

    public boolean hasStyleRef() {
        return this.getStyleRef() != null;
    }

    public String getStyleRef() {
        Object href;
        String linkName = null;
        Element link = Util.findElementDown(HTML.Tag.LINK.toString(), this.getDefaultRootElement());
        if (link != null && (href = link.getAttributes().getAttribute(HTML.Attribute.HREF)) != null) {
            linkName = href.toString();
        }
        return linkName;
    }

    @Override
    public Element getParagraphElement(int pos) {
        return this.getParagraphElement(pos, this.inSetParagraphAttributes);
    }

    public Element getParagraphElement(int pos, boolean noPImplied) {
        Element element;
        if (noPImplied) {
            for (element = super.getParagraphElement(pos); element != null && element.getName().equalsIgnoreCase("p-implied"); element = element.getParentElement()) {
            }
        }
        return element;
    }

    public int getLastDocumentPosition() {
        int length = this.getLength();
        return length - this.suffixLength;
    }

    @Override
    public void setParagraphAttributes(int offset, int length, AttributeSet s, boolean replace) {
        this.startCompoundEdit();
        super.setParagraphAttributes(offset, length, s, replace);
        this.inSetParagraphAttributes = true;
        super.setParagraphAttributes(offset, length, s, replace);
        this.inSetParagraphAttributes = false;
        this.endCompoundEdit();
    }

    public void removeParagraphAttributes(int offset, int length) {
        this.startCompoundEdit();
        int i = offset;
        while (i < offset + length) {
            Element paragraphElement = super.getParagraphElement(i);
            this.removeParagraphAtributes(paragraphElement);
            i = paragraphElement.getEndOffset();
        }
        this.endCompoundEdit();
    }

    private void removeParagraphAtributes(Element paragraphElement) {
        if (paragraphElement != null && paragraphElement.getName().equalsIgnoreCase("p-implied")) {
            this.removeParagraphAtributes(paragraphElement.getParentElement());
            return;
        }
        StringWriter writer = new StringWriter();
        SHTMLWriter htmlStartWriter = new SHTMLWriter((Writer)writer, this);
        try {
            htmlStartWriter.writeStartTag(paragraphElement.getName(), null);
            htmlStartWriter.writeChildElements(paragraphElement);
            htmlStartWriter.writeEndTag(paragraphElement.getName());
            this.setOuterHTML(paragraphElement, writer.toString());
        }
        catch (IOException | BadLocationException e) {
            e.printStackTrace();
        }
    }

    private SimpleAttributeSet getEndingAttributeSet() {
        SimpleAttributeSet set = new SimpleAttributeSet();
        if (Util.preferenceIsTrue("gray_row_below_end")) {
            StyleConstants.setBackground(set, Color.GRAY);
        }
        return set;
    }

    public File getImageDirectory() {
        return SHTMLDocument.getImageDirectory(this.getBase());
    }

    public static File getImageDirectory(URL base) {
        try {
            return new File(new URL(base, SHTMLDocument.getImageDirectoryName(base)).getPath());
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String getImageDirectoryName() {
        return SHTMLDocument.getImageDirectoryName(this.getBase());
    }

    public static String getImageDirectoryName(URL documentUrl) {
        if (documentUrl == null) {
            throw new UnknownDocumentBaseException(Util.getResourceString("unknownBaseUrlImageInsertionError"));
        }
        String path = documentUrl.getPath();
        int filenameStart = path.lastIndexOf(47) + 1;
        int filenameEnd = path.lastIndexOf(46);
        if (filenameEnd < filenameStart) {
            filenameEnd = path.length();
        }
        if (filenameStart < filenameEnd) {
            return path.substring(filenameStart, filenameEnd) + "_files";
        }
        throw new UnknownDocumentBaseException(Util.getResourceString("unknownBaseUrlImageInsertionError"));
    }

    @FunctionalInterface
    public static interface ThrowingRunnable<T extends Exception> {
        public void run() throws T;
    }
}

