/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Set;

class FlexShorthandBuilder
extends ShorthandBuilder {
    private final String FLEX_GROW = "flex-grow";
    private final String FLEX_SHRINK = "flex-shrink";
    private final String FLEX_BASIS = "flex-basis";

    FlexShorthandBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("flex", parentStyle);
    }

    @Override
    int appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        TypedValue primiBasis;
        if (this.hasPropertiesToExclude(declaredSet)) {
            return 1;
        }
        buf.append(this.getShorthandName()).append(':');
        byte check = this.checkValuesForInherit(declaredSet);
        if (check == 1) {
            buf.append("inherit");
            this.appendPriority(buf, important);
            return 0;
        }
        if (check == 2) {
            return 1;
        }
        check = this.checkValuesForType(CSSValue.Type.REVERT, declaredSet);
        if (check == 1) {
            buf.append("revert");
            this.appendPriority(buf, important);
            return 0;
        }
        if (check == 2) {
            return 1;
        }
        StyleValue cssFlexGrow = null;
        if ((declaredSet.contains("flex-grow") || declaredSet.contains("flex-shrink")) && ((cssFlexGrow = this.getCSSValue("flex-grow")).getCssValueType() == CSSValue.CssType.TYPED ? this.invalidFlexGrowShrink((CSSTypedValue)((Object)cssFlexGrow)) : cssFlexGrow.getCssValueType() != CSSValue.CssType.KEYWORD)) {
            return 1;
        }
        StyleValue cssFlexShrink = null;
        if (declaredSet.contains("flex-shrink") && ((cssFlexShrink = this.getCSSValue("flex-shrink")).getCssValueType() == CSSValue.CssType.TYPED ? this.invalidFlexGrowShrink((CSSTypedValue)((Object)cssFlexShrink)) : cssFlexGrow.getCssValueType() != CSSValue.CssType.KEYWORD)) {
            return 1;
        }
        StyleValue cssFlexBasis = null;
        if (declaredSet.contains("flex-basis") && ((cssFlexBasis = this.getCSSValue("flex-basis")).getCssValueType() == CSSValue.CssType.TYPED ? this.invalidFlexBasis((CSSTypedValue)((Object)cssFlexBasis)) : cssFlexGrow.getCssValueType() != CSSValue.CssType.KEYWORD)) {
            return 1;
        }
        if (cssFlexBasis != null && cssFlexBasis.getPrimitiveType() == CSSValue.Type.IDENT && "auto".equalsIgnoreCase((primiBasis = (TypedValue)cssFlexBasis).getStringValue())) {
            float grow;
            float shrink;
            CSSTypedValue primiGrow = (CSSTypedValue)((Object)cssFlexGrow);
            CSSTypedValue primiShrink = (CSSTypedValue)((Object)cssFlexShrink);
            if (primiShrink != null) {
                shrink = primiShrink.getFloatValue((short)0);
                grow = primiGrow != null ? primiGrow.getFloatValue((short)0) : shrink;
            } else {
                grow = primiGrow != null ? primiGrow.getFloatValue((short)0) : 1.0f;
                shrink = grow;
            }
            if (grow == 1.0f && shrink == 1.0f) {
                buf.append("auto");
                this.appendPriority(buf, important);
                return 0;
            }
            if (grow == 0.0f && shrink == 0.0f) {
                buf.append("none");
                this.appendPriority(buf, important);
                return 0;
            }
            if (grow == 0.0f && shrink == 1.0f) {
                buf.append("0");
                this.appendPriority(buf, important);
                return 0;
            }
        }
        BufferSimpleWriter wri = new BufferSimpleWriter(buf);
        DeclarationFormattingContext context = this.getParentStyle().getFormattingContext();
        boolean appended = false;
        boolean shrinkNotInitial = this.isNotInitialValue(cssFlexShrink, "flex-shrink");
        if (shrinkNotInitial || this.isNotInitialValue(cssFlexGrow, "flex-grow")) {
            this.appendValueText(wri, context, cssFlexGrow, false);
            appended = true;
        }
        if (shrinkNotInitial) {
            this.appendValueText(wri, context, cssFlexShrink, appended);
            appended = true;
        }
        if (this.isNotInitialValue(cssFlexBasis, "flex-basis")) {
            primiBasis = (TypedValue)cssFlexBasis;
            if (primiBasis.getUnitType() == 0 || primiBasis.isNumberZero()) {
                if (appended) {
                    buf.append(' ');
                }
                buf.append("0px");
            } else {
                this.appendValueText(wri, context, cssFlexBasis, appended);
            }
            appended = true;
        }
        if (!appended) {
            buf.append("0");
        }
        this.appendPriority(buf, important);
        return 0;
    }

    private boolean invalidFlexGrowShrink(CSSTypedValue primi) {
        if (primi.getUnitType() == 0) {
            return primi.getFloatValue() < 0.0f;
        }
        return true;
    }

    private boolean invalidFlexBasis(CSSTypedValue primi) {
        if (primi.getPrimitiveType() == CSSValue.Type.IDENT) {
            String ident = primi.getStringValue();
            return !FlexShorthandBuilder.getShorthandDatabase().isIdentifierValue("flex-basis", ident);
        }
        if (primi.getUnitType() == 0) {
            return primi.getFloatValue() != 0.0f;
        }
        return false;
    }

    @Override
    protected boolean isNotInitialValue(StyleValue cssVal, String propertyName) {
        return cssVal != null && !this.isEffectiveInitialKeyword(cssVal) && !this.valueEquals(this.getInitialPropertyValue(propertyName), cssVal);
    }

    private void appendValueText(BufferSimpleWriter wri, DeclarationFormattingContext context, StyleValue cssVal, boolean prepend) {
        if (prepend) {
            wri.getBuffer().append(' ');
        }
        try {
            context.writeMinifiedValue((SimpleWriter)wri, "flex", cssVal);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

