/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Implements pixel-wise intensity-&gt;rgb mapping operation on one
image.


This class is parameterized over the type of the input image and the
type of the output image.

The input image's scalar pixel values are mapped into a color map. The
color map is specified by passing the SetColormap function one of the
predefined maps. The following selects the
"RGBColormapFilterEnum::Hot" colormap:

You can also specify a custom color map. This is done by creating a
CustomColormapFunction, and then creating lists of values for the red,
green, and blue channel. An example of setting the red channel of a
colormap with only 2 colors is given below. The blue and green
channels should be specified in the same manner.


The range of values present in the input image is the range that is
mapped to the entire range of colors.

This code was contributed in the Insight Journal paper: "Meeting Andy
Warhol Somewhere Over the Rainbow: RGB Colormapping and ITK" by
Tustison N., Zhang H., Lehmann G., Yushkevich P., Gee J. https://doi.org/10.54294/tmojbk


See:
 BinaryFunctionImageFilter TernaryFunctionImageFilter

 itk::simple::ScalarToRGBColormap for the procedural interface

 itk::ScalarToRGBColormapImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkScalarToRGBColormapImageFilter.h
*/
public class ScalarToRGBColormapImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ScalarToRGBColormapImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ScalarToRGBColormapImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ScalarToRGBColormapImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ScalarToRGBColormapImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ScalarToRGBColormapImageFilter::~ScalarToRGBColormapImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ScalarToRGBColormapImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ScalarToRGBColormapImageFilter::ScalarToRGBColormapImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ScalarToRGBColormapImageFilter() {
    this(SimpleITKJNI.new_ScalarToRGBColormapImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ScalarToRGBColormapImageFilter::SetColormap(ColormapType Colormap)
*/
public  void setColormap(ScalarToRGBColormapImageFilter.ColormapType Colormap) {
    SimpleITKJNI.ScalarToRGBColormapImageFilter_setColormap(swigCPtr, this, Colormap.swigValue());
  }

  /**
ColormapType itk::simple::ScalarToRGBColormapImageFilter::GetColormap() const

Set/Get the colormap object.

*/
public  ScalarToRGBColormapImageFilter.ColormapType getColormap() {
    return ScalarToRGBColormapImageFilter.ColormapType.swigToEnum(SimpleITKJNI.ScalarToRGBColormapImageFilter_getColormap(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::ScalarToRGBColormapImageFilter::SetUseInputImageExtremaForScaling(bool UseInputImageExtremaForScaling)

Set/Get UseInputImageExtremaForScaling. If true, the colormap uses the
min and max values from the image to scale appropriately. Otherwise,
these values can be set in the colormap manually.

*/
public  void setUseInputImageExtremaForScaling(boolean UseInputImageExtremaForScaling) {
    SimpleITKJNI.ScalarToRGBColormapImageFilter_setUseInputImageExtremaForScaling(swigCPtr, this, UseInputImageExtremaForScaling);
  }

  /**
Self&amp; itk::simple::ScalarToRGBColormapImageFilter::UseInputImageExtremaForScalingOn()

Set the value of UseInputImageExtremaForScaling to true or false
respectfully.

*/
public  void useInputImageExtremaForScalingOn() {
    SimpleITKJNI.ScalarToRGBColormapImageFilter_useInputImageExtremaForScalingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ScalarToRGBColormapImageFilter::UseInputImageExtremaForScalingOff()
*/
public  void useInputImageExtremaForScalingOff() {
    SimpleITKJNI.ScalarToRGBColormapImageFilter_useInputImageExtremaForScalingOff(swigCPtr, this);
  }

  /**
bool itk::simple::ScalarToRGBColormapImageFilter::GetUseInputImageExtremaForScaling() const

Set/Get UseInputImageExtremaForScaling. If true, the colormap uses the
min and max values from the image to scale appropriately. Otherwise,
these values can be set in the colormap manually.

*/
public  boolean getUseInputImageExtremaForScaling() {
    return SimpleITKJNI.ScalarToRGBColormapImageFilter_getUseInputImageExtremaForScaling(swigCPtr, this);
  }

  /**
std::string itk::simple::ScalarToRGBColormapImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ScalarToRGBColormapImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ScalarToRGBColormapImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ScalarToRGBColormapImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ScalarToRGBColormapImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ScalarToRGBColormapImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  public final static class ColormapType {
    public final static ScalarToRGBColormapImageFilter.ColormapType Red = new ScalarToRGBColormapImageFilter.ColormapType("Red");
    public final static ScalarToRGBColormapImageFilter.ColormapType Green = new ScalarToRGBColormapImageFilter.ColormapType("Green");
    public final static ScalarToRGBColormapImageFilter.ColormapType Blue = new ScalarToRGBColormapImageFilter.ColormapType("Blue");
    public final static ScalarToRGBColormapImageFilter.ColormapType Grey = new ScalarToRGBColormapImageFilter.ColormapType("Grey");
    public final static ScalarToRGBColormapImageFilter.ColormapType Hot = new ScalarToRGBColormapImageFilter.ColormapType("Hot");
    public final static ScalarToRGBColormapImageFilter.ColormapType Cool = new ScalarToRGBColormapImageFilter.ColormapType("Cool");
    public final static ScalarToRGBColormapImageFilter.ColormapType Spring = new ScalarToRGBColormapImageFilter.ColormapType("Spring");
    public final static ScalarToRGBColormapImageFilter.ColormapType Summer = new ScalarToRGBColormapImageFilter.ColormapType("Summer");
    public final static ScalarToRGBColormapImageFilter.ColormapType Autumn = new ScalarToRGBColormapImageFilter.ColormapType("Autumn");
    public final static ScalarToRGBColormapImageFilter.ColormapType Winter = new ScalarToRGBColormapImageFilter.ColormapType("Winter");
    public final static ScalarToRGBColormapImageFilter.ColormapType Copper = new ScalarToRGBColormapImageFilter.ColormapType("Copper");
    public final static ScalarToRGBColormapImageFilter.ColormapType Jet = new ScalarToRGBColormapImageFilter.ColormapType("Jet");
    public final static ScalarToRGBColormapImageFilter.ColormapType HSV = new ScalarToRGBColormapImageFilter.ColormapType("HSV");
    public final static ScalarToRGBColormapImageFilter.ColormapType OverUnder = new ScalarToRGBColormapImageFilter.ColormapType("OverUnder");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static ColormapType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + ColormapType.class + " with value " + swigValue);
    }

    private ColormapType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private ColormapType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private ColormapType(String swigName, ColormapType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static ColormapType[] swigValues = { Red, Green, Blue, Grey, Hot, Cool, Spring, Summer, Autumn, Winter, Copper, Jet, HSV, OverUnder };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
