/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.awt.Color;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jme.JME;

class QueryBox
extends JFrame {
    JTextField text;
    Color bgc = JME.bgColor;
    boolean isBondQuery = false;
    JME jme;

    QueryBox(JME jme) {
        super("Atom/Bond Query");
        this.jme = jme;
        this.setLayout(new GridLayout(0, 1));
        this.setFont(jme.fontSmall);
        this.setBackground(this.bgc);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0, 3, 1));
        p1.add(new JLabel("Atom type :"));
        boolean first = true;
        if (first) {
            jme.any = new JButton("Any");
            jme.anyec = new JButton("Any except C");
            jme.halogen = new JButton("Halogen");
        }
        p1.add(jme.any);
        p1.add(jme.anyec);
        p1.add(jme.halogen);
        this.add(p1);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0, 3, 1));
        p2.add(new JLabel("Or select one or more from the list :", 2));
        this.add(p2);
        JPanel p3 = new JPanel();
        p3.setLayout(new FlowLayout(0, 3, 1));
        if (first) {
            jme.c = new JButton("C");
            jme.n = new JButton("N");
            jme.o = new JButton("O");
            jme.s = new JButton("S");
            jme.p = new JButton("P");
            jme.f = new JButton("F");
            jme.cl = new JButton("Cl");
            jme.br = new JButton("Br");
            jme.i = new JButton("I");
        }
        p3.add(jme.c);
        p3.add(jme.n);
        p3.add(jme.o);
        p3.add(jme.s);
        p3.add(jme.p);
        p3.add(jme.f);
        p3.add(jme.cl);
        p3.add(jme.br);
        p3.add(jme.i);
        this.add(p3);
        JPanel p4 = new JPanel();
        p4.setLayout(new FlowLayout(0, 3, 1));
        if (first) {
            jme.choiceh = new JComboBox();
            jme.choiceh.addItem("Any");
            jme.choiceh.addItem("0");
            jme.choiceh.addItem("1");
            jme.choiceh.addItem("2");
            jme.choiceh.addItem("3");
        }
        p4.add(new JLabel("Number of hydrogens :  "));
        p4.add(jme.choiceh);
        this.add(p4);
        JPanel p5 = new JPanel();
        p5.setLayout(new FlowLayout(0, 3, 1));
        if (first) {
            jme.choiced = new JComboBox();
            jme.choiced.addItem("Any");
            jme.choiced.addItem("0");
            jme.choiced.addItem("1");
            jme.choiced.addItem("2");
            jme.choiced.addItem("3");
            jme.choiced.addItem("4");
            jme.choiced.addItem("5");
            jme.choiced.addItem("6");
        }
        p5.add(new JLabel("Number of connections :", 2));
        p5.add(jme.choiced);
        p5.add(new JLabel(" (H's don't count.)", 2));
        this.add(p5);
        JPanel p6 = new JPanel();
        p6.setLayout(new FlowLayout(0, 3, 1));
        p6.add(new JLabel("Atom is :"));
        if (first) {
            jme.aromatic = new JButton("Aromatic");
        }
        p6.add(jme.aromatic);
        if (first) {
            jme.nonaromatic = new JButton("Nonaromatic");
        }
        p6.add(jme.nonaromatic);
        if (first) {
            jme.ring = new JButton("Ring");
        }
        p6.add(jme.ring);
        if (first) {
            jme.nonring = new JButton("Nonring");
        }
        p6.add(jme.nonring);
        this.add(p6);
        JPanel p9 = new JPanel();
        p9.setBackground(this.getBackground().darker());
        p9.setLayout(new FlowLayout(0, 3, 1));
        p9.add(new JLabel("Bond is :"));
        if (first) {
            jme.anyBond = new JButton("Any");
        }
        p9.add(jme.anyBond);
        if (first) {
            jme.aromaticBond = new JButton("Aromatic");
        }
        p9.add(jme.aromaticBond);
        if (first) {
            jme.ringBond = new JButton("Ring");
        }
        p9.add(jme.ringBond);
        if (first) {
            jme.nonringBond = new JButton("Nonring");
        }
        p9.add(jme.nonringBond);
        this.add(p9);
        JPanel p8 = new JPanel();
        p8.setLayout(new FlowLayout(1, 3, 1));
        if (first) {
            this.text = new JTextField("*", 20);
        }
        p8.add(this.text);
        p8.add(new JButton("Reset"));
        p8.add(new JButton("Close"));
        this.add(p8);
        this.setResizable(false);
        if (first) {
            this.resetAtomList();
            this.resetAtomType();
            this.resetBondType();
            jme.aromatic.setBackground(this.bgc);
            jme.nonaromatic.setBackground(this.bgc);
            jme.ring.setBackground(this.bgc);
            jme.nonring.setBackground(this.bgc);
            jme.choiceh.setBackground(this.bgc);
            jme.choiced.setBackground(this.bgc);
            this.changeColor(jme.any);
        }
        this.pack();
        this.setLocation(jme.point);
        this.setVisible(true);
    }

    @Override
    public boolean action(Event e, Object arg) {
        if (arg.equals("Close")) {
            this.jme.point = this.getLocationOnScreen();
            this.setVisible(false);
        } else if (arg.equals("Reset")) {
            this.resetAll();
            this.changeColor(this.jme.any);
            this.doSmarts();
        } else if (e.target instanceof JButton) {
            this.resetBondType();
            if (e.target == this.jme.any) {
                this.resetAtomList();
                this.resetAtomType();
            } else if (e.target == this.jme.anyec) {
                this.resetAtomList();
                this.resetAtomType();
            } else if (e.target == this.jme.halogen) {
                this.resetAtomList();
                this.resetAtomType();
            } else if (e.target == this.jme.ring) {
                this.jme.nonring.setBackground(this.bgc);
            } else if (e.target == this.jme.nonring) {
                this.jme.ring.setBackground(this.bgc);
                this.jme.aromatic.setBackground(this.bgc);
            } else if (e.target == this.jme.aromatic) {
                this.jme.nonaromatic.setBackground(this.bgc);
                this.jme.nonring.setBackground(this.bgc);
            } else if (e.target == this.jme.nonaromatic) {
                this.jme.aromatic.setBackground(this.bgc);
            } else if (e.target == this.jme.anyBond || e.target == this.jme.aromaticBond || e.target == this.jme.ringBond || e.target == this.jme.nonringBond) {
                this.resetAll();
                this.isBondQuery = true;
            } else {
                this.resetAtomType();
            }
            this.changeColor((JButton)e.target);
            this.doSmarts();
        } else if (e.target instanceof JComboBox) {
            this.resetBondType();
            JComboBox choice = (JComboBox)e.target;
            if (choice.getSelectedIndex() == 0) {
                choice.setBackground(this.bgc);
            } else {
                choice.setBackground(Color.orange);
            }
            this.doSmarts();
        }
        if (this.jme.action != 107) {
            this.jme.action = 107;
            this.jme.repaint();
        }
        return true;
    }

    protected void resetAll() {
        this.resetAtomList();
        this.resetAtomType();
        this.jme.choiceh.setSelectedIndex(0);
        this.jme.choiced.setSelectedIndex(0);
        this.jme.aromatic.setBackground(this.bgc);
        this.jme.nonaromatic.setBackground(this.bgc);
        this.jme.ring.setBackground(this.bgc);
        this.jme.nonring.setBackground(this.bgc);
        this.jme.choiceh.setBackground(this.bgc);
        this.jme.choiced.setBackground(this.bgc);
        this.resetBondType();
    }

    protected void resetAtomList() {
        this.jme.c.setBackground(this.bgc);
        this.jme.n.setBackground(this.bgc);
        this.jme.o.setBackground(this.bgc);
        this.jme.s.setBackground(this.bgc);
        this.jme.p.setBackground(this.bgc);
        this.jme.f.setBackground(this.bgc);
        this.jme.cl.setBackground(this.bgc);
        this.jme.br.setBackground(this.bgc);
        this.jme.i.setBackground(this.bgc);
    }

    protected void resetAtomType() {
        this.jme.any.setBackground(this.bgc);
        this.jme.anyec.setBackground(this.bgc);
        this.jme.halogen.setBackground(this.bgc);
    }

    protected void resetBondType() {
        this.jme.anyBond.setBackground(this.bgc);
        this.jme.aromaticBond.setBackground(this.bgc);
        this.jme.ringBond.setBackground(this.bgc);
        this.jme.nonringBond.setBackground(this.bgc);
        this.isBondQuery = false;
    }

    protected void changeColor(JButton b) {
        if (b.getBackground() == this.bgc) {
            b.setBackground(Color.orange);
        } else {
            b.setBackground(this.bgc);
        }
    }

    protected void doSmarts() {
        int nd;
        String smarts = "";
        boolean showaA = false;
        if (this.jme.any.getBackground() != this.bgc) {
            smarts = "*";
            showaA = true;
        } else if (this.jme.anyec.getBackground() != this.bgc) {
            smarts = "!#6";
            showaA = true;
        } else if (this.jme.halogen.getBackground() != this.bgc) {
            this.jme.f.setBackground(Color.orange);
            this.jme.cl.setBackground(Color.orange);
            this.jme.br.setBackground(Color.orange);
            this.jme.i.setBackground(Color.orange);
            smarts = "F,Cl,Br,I";
        } else {
            boolean nar;
            boolean ar = this.jme.aromatic.getBackground() != this.bgc;
            boolean bl = nar = this.jme.nonaromatic.getBackground() != this.bgc;
            if (this.jme.c.getBackground() != this.bgc) {
                smarts = ar ? smarts + "c," : (nar ? smarts + "C," : smarts + "#6,");
            }
            if (this.jme.n.getBackground() != this.bgc) {
                smarts = ar ? smarts + "n," : (nar ? smarts + "N," : smarts + "#7,");
            }
            if (this.jme.o.getBackground() != this.bgc) {
                smarts = ar ? smarts + "o," : (nar ? smarts + "O," : smarts + "#8,");
            }
            if (this.jme.s.getBackground() != this.bgc) {
                smarts = ar ? smarts + "s," : (nar ? smarts + "S," : smarts + "#16,");
            }
            if (this.jme.p.getBackground() != this.bgc) {
                smarts = ar ? smarts + "p," : (nar ? smarts + "P," : smarts + "#15,");
            }
            if (this.jme.f.getBackground() != this.bgc) {
                smarts = smarts + "F,";
            }
            if (this.jme.cl.getBackground() != this.bgc) {
                smarts = smarts + "Cl,";
            }
            if (this.jme.br.getBackground() != this.bgc) {
                smarts = smarts + "Br,";
            }
            if (this.jme.i.getBackground() != this.bgc) {
                smarts = smarts + "I,";
            }
            if (smarts.endsWith(",")) {
                smarts = smarts.substring(0, smarts.length() - 1);
            }
            if (smarts.length() < 1 && !this.isBondQuery) {
                if (ar) {
                    smarts = "a";
                } else if (nar) {
                    smarts = "A";
                } else {
                    this.jme.any.setBackground(Color.orange);
                    smarts = "*";
                }
            }
        }
        String ap = "";
        if (showaA && this.jme.aromatic.getBackground() != this.bgc) {
            ap = ap + ";a";
        }
        if (showaA && this.jme.nonaromatic.getBackground() != this.bgc) {
            ap = ap + ";A";
        }
        if (this.jme.ring.getBackground() != this.bgc) {
            ap = ap + ";R";
        }
        if (this.jme.nonring.getBackground() != this.bgc) {
            ap = ap + ";!R";
        }
        smarts = this.jme.any.getBackground() != this.bgc && ap.length() > 0 ? ap.substring(1, ap.length()) : smarts + ap;
        int nh = this.jme.choiceh.getSelectedIndex();
        if (nh > 0) {
            smarts = smarts + ";H" + --nh;
        }
        if ((nd = this.jme.choiced.getSelectedIndex()) > 0) {
            smarts = smarts + ";D" + --nd;
        }
        if (this.jme.anyBond.getBackground() != this.bgc) {
            smarts = "~";
        }
        if (this.jme.aromaticBond.getBackground() != this.bgc) {
            smarts = ":";
        }
        if (this.jme.ringBond.getBackground() != this.bgc) {
            smarts = "@";
        }
        if (this.jme.nonringBond.getBackground() != this.bgc) {
            smarts = "!@";
        }
        this.text.setText(smarts);
    }

    boolean isBondQuery() {
        return this.isBondQuery;
    }

    String getSmarts() {
        return this.text.getText();
    }
}

