/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.bspt;

import javajs.util.T3;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.Element;
import org.jmol.bspt.Leaf;
import org.jmol.bspt.Node;

public class CubeIterator {
    private Bspt bspt;
    private Element[] stack;
    private int sp;
    private int leafIndex;
    private Leaf leaf;
    private float radius;
    private float cx;
    private float cy;
    private float cz;
    private float dx;
    private float dy;
    private float dz;
    private boolean tHemisphere;

    CubeIterator(Bspt bspt) {
        this.set(bspt);
    }

    void set(Bspt bspt) {
        this.bspt = bspt;
        this.stack = new Element[bspt.treeDepth];
    }

    public void initialize(T3 center, float radius, boolean hemisphereOnly) {
        this.radius = radius;
        this.tHemisphere = false;
        this.cx = center.x;
        this.cy = center.y;
        this.cz = center.z;
        this.leaf = null;
        if (this.stack.length < this.bspt.treeDepth) {
            this.set(this.bspt);
        }
        this.stack[0] = this.bspt.eleRoot;
        this.sp = 1;
        this.findLeftLeaf();
        this.tHemisphere = hemisphereOnly;
    }

    public void release() {
        this.set(this.bspt);
    }

    public boolean hasMoreElements() {
        while (this.leaf != null) {
            while (this.leafIndex < this.leaf.count) {
                if (this.isWithinRadius(this.leaf.tuples[this.leafIndex])) {
                    return true;
                }
                ++this.leafIndex;
            }
            this.findLeftLeaf();
        }
        return false;
    }

    public T3 nextElement() {
        return this.leaf.tuples[this.leafIndex++];
    }

    public float foundDistance2() {
        return this.dx * this.dx + this.dy * this.dy + this.dz * this.dz;
    }

    private void findLeftLeaf() {
        this.leaf = null;
        if (this.sp == 0) {
            return;
        }
        Element ele = this.stack[--this.sp];
        while (ele instanceof Node) {
            float minValue;
            Node node = (Node)ele;
            switch (node.dim) {
                case 0: {
                    minValue = this.cx;
                    break;
                }
                case 1: {
                    minValue = this.cy;
                    break;
                }
                default: {
                    minValue = this.cz;
                }
            }
            float maxValue = minValue + this.radius;
            if (!this.tHemisphere || node.dim != 0) {
                minValue -= this.radius;
            }
            if (minValue <= node.maxLeft && maxValue >= node.minLeft) {
                if (maxValue >= node.minRight && minValue <= node.maxRight) {
                    this.stack[this.sp++] = node.eleRight;
                }
                ele = node.eleLeft;
                continue;
            }
            if (maxValue >= node.minRight && minValue <= node.maxRight) {
                ele = node.eleRight;
                continue;
            }
            if (this.sp == 0) {
                return;
            }
            ele = this.stack[--this.sp];
        }
        this.leaf = (Leaf)ele;
        this.leafIndex = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isWithinRadius(T3 t) {
        float f;
        float f2;
        float f3;
        this.dx = t.x - this.cx;
        if (this.tHemisphere) {
            if (!(this.dx >= 0.0f)) return false;
        }
        this.dx = Math.abs(this.dx);
        if (!(f3 <= this.radius)) return false;
        this.dy = Math.abs(t.y - this.cy);
        if (!(f2 <= this.radius)) return false;
        this.dz = Math.abs(t.z - this.cz);
        if (!(f <= this.radius)) return false;
        return true;
    }
}

