/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.persister;

import java.util.List;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.share.persister.PartitionAllData;
import org.apache.kafka.server.share.persister.PartitionData;
import org.apache.kafka.server.share.persister.PartitionErrorData;
import org.apache.kafka.server.share.persister.PartitionIdData;
import org.apache.kafka.server.share.persister.PartitionIdLeaderEpochData;
import org.apache.kafka.server.share.persister.PartitionStateBatchData;
import org.apache.kafka.server.share.persister.PartitionStateData;
import org.apache.kafka.server.share.persister.PartitionStateSummaryData;
import org.apache.kafka.server.share.persister.PersisterStateBatch;

public class PartitionFactory {
    public static final int DEFAULT_STATE_EPOCH = 0;
    public static final int UNINITIALIZED_START_OFFSET = -1;
    public static final short DEFAULT_ERROR_CODE = Errors.NONE.code();
    public static final int DEFAULT_LEADER_EPOCH = 0;
    public static final String DEFAULT_ERR_MESSAGE = Errors.NONE.message();

    public static PartitionIdData newPartitionIdData(int partition) {
        return new PartitionData(partition, 0, -1L, DEFAULT_ERROR_CODE, DEFAULT_ERR_MESSAGE, 0, null);
    }

    public static PartitionIdLeaderEpochData newPartitionIdLeaderEpochData(int partition, int leaderEpoch) {
        return new PartitionData(partition, 0, -1L, DEFAULT_ERROR_CODE, DEFAULT_ERR_MESSAGE, leaderEpoch, null);
    }

    public static PartitionStateData newPartitionStateData(int partition, int stateEpoch, long startOffset) {
        return new PartitionData(partition, stateEpoch, startOffset, DEFAULT_ERROR_CODE, DEFAULT_ERR_MESSAGE, 0, null);
    }

    public static PartitionErrorData newPartitionErrorData(int partition, short errorCode, String errorMessage) {
        return new PartitionData(partition, 0, -1L, errorCode, errorMessage, 0, null);
    }

    public static PartitionStateSummaryData newPartitionStateSummaryData(int partition, int stateEpoch, long startOffset, int leaderEpoch, short errorCode, String errorMessage) {
        return new PartitionData(partition, stateEpoch, startOffset, errorCode, errorMessage, leaderEpoch, null);
    }

    public static PartitionStateBatchData newPartitionStateBatchData(int partition, int stateEpoch, long startOffset, int leaderEpoch, List<PersisterStateBatch> stateBatches) {
        return new PartitionData(partition, stateEpoch, startOffset, DEFAULT_ERROR_CODE, DEFAULT_ERR_MESSAGE, leaderEpoch, stateBatches);
    }

    public static PartitionAllData newPartitionAllData(int partition, int stateEpoch, long startOffset, short errorCode, String errorMessage, List<PersisterStateBatch> stateBatches) {
        return new PartitionData(partition, stateEpoch, startOffset, errorCode, errorMessage, 0, stateBatches);
    }
}

