/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.impl.ArrayLoadViaHandle;
import io.quarkus.gizmo2.impl.ArrayStore;
import io.quarkus.gizmo2.impl.ArrayStoreViaHandle;
import io.quarkus.gizmo2.impl.AssignableImpl;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Conversions;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import io.quarkus.gizmo2.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.function.BiFunction;

public final class ArrayDeref
extends AssignableImpl {
    private final Item item;
    private final GenericType componentType;
    private final Item index;
    private boolean bound;

    ArrayDeref(Item item, GenericType componentType, Expr index) {
        this.item = item;
        this.componentType = componentType;
        this.index = Conversions.convert(index, ConstantDescs.CD_int);
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return this.item.process(this.index.process(node.prev(), op), op);
    }

    public Item array() {
        return this.item;
    }

    public Item index() {
        return this.index;
    }

    @Override
    Item emitGet(BlockCreatorImpl block, MemoryOrder mode) {
        if (!mode.validForReads()) {
            throw new IllegalArgumentException("Invalid mode " + String.valueOf((Object)mode));
        }
        return switch (mode) {
            case MemoryOrder.AsDeclared, MemoryOrder.Plain -> this.asBound();
            default -> new ArrayLoadViaHandle(this, mode);
        };
    }

    @Override
    Item emitSet(BlockCreatorImpl block, Item value, MemoryOrder mode) {
        return switch (mode) {
            case MemoryOrder.AsDeclared, MemoryOrder.Plain -> new ArrayStore(this.item, this.index, value, this.type());
            default -> new ArrayStoreViaHandle(this, value, mode);
        };
    }

    @Override
    public ClassDesc type() {
        return this.componentType.desc();
    }

    @Override
    public GenericType genericType() {
        return this.componentType;
    }

    @Override
    protected void bind() {
        if (this.item.bound() || this.index.bound()) {
            this.bound = true;
        }
    }

    @Override
    public boolean bound() {
        return this.bound;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        cb.arrayLoad(Util.actualKindOf(this.typeKind()));
    }
}

