/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.session;

import org.keycloak.models.jpa.session.PersistentClientSessionEntity;
import org.keycloak.models.session.PersistentAuthenticatedClientSessionAdapter;
import org.keycloak.storage.StorageId;

public final class JpaSessionUtil {
    private JpaSessionUtil() {
    }

    public static String offlineToString(boolean offline) {
        return offline ? "1" : "0";
    }

    public static boolean offlineFromString(String offlineStr) {
        return "1".equals(offlineStr);
    }

    public static boolean isExternalClient(PersistentClientSessionEntity entity) {
        return !entity.getExternalClientId().equals("local");
    }

    public static String getExternalClientId(PersistentClientSessionEntity entity) {
        return new StorageId(entity.getClientStorageProvider(), entity.getExternalClientId()).getId();
    }

    public static String getClientId(PersistentClientSessionEntity entity) {
        return JpaSessionUtil.isExternalClient(entity) ? JpaSessionUtil.getExternalClientId(entity) : entity.getClientId();
    }

    public static boolean hasClient(PersistentAuthenticatedClientSessionAdapter clientSession) {
        return clientSession.getClient() != null;
    }
}

