<?php

declare(strict_types=1);

namespace OCA\Talk\Vendor\CuyZ\Valinor\Mapper\Object\Exception;

use OCA\Talk\Vendor\CuyZ\Valinor\Type\Type;
use LogicException;

/** @internal */
final class PermissiveTypeNotAllowed extends LogicException
{
    public function __construct(string $argumentSignature, Type $permissiveType)
    {
        parent::__construct(
            "The type of `$argumentSignature` contains `{$permissiveType->toString()}`, which is not " .
            "allowed in strict mode. If really needed, the `allowPermissiveTypes` setting can be used.",
            1655389255,
        );
    }
}
