/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.client.tasks.TaskInfo;

public class TaskGroup {
    private final TaskInfo task;
    private final List<TaskGroup> childTasks = new ArrayList<TaskGroup>();

    public String toString() {
        return "TaskGroup{task=" + String.valueOf(this.task) + ", childTasks=" + String.valueOf(this.childTasks) + "}";
    }

    public TaskGroup(TaskInfo task, List<TaskGroup> childTasks) {
        this.task = task;
        this.childTasks.addAll(childTasks);
    }

    public static Builder builder(TaskInfo taskInfo) {
        return new Builder(taskInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaskGroup)) {
            return false;
        }
        TaskGroup taskGroup = (TaskGroup)o;
        return Objects.equals(this.task, taskGroup.task) && Objects.equals(this.getChildTasks(), taskGroup.getChildTasks());
    }

    public int hashCode() {
        return Objects.hash(this.task, this.getChildTasks());
    }

    public TaskInfo getTaskInfo() {
        return this.task;
    }

    public List<TaskGroup> getChildTasks() {
        return this.childTasks;
    }

    public static class Builder {
        private TaskInfo taskInfo;
        private List<Builder> childTasks;

        private Builder(TaskInfo taskInfo) {
            this.taskInfo = taskInfo;
            this.childTasks = new ArrayList<Builder>();
        }

        public void addGroup(Builder builder) {
            this.childTasks.add(builder);
        }

        public TaskInfo getTaskInfo() {
            return this.taskInfo;
        }

        public TaskGroup build() {
            return new TaskGroup(this.taskInfo, this.childTasks.stream().map(Builder::build).collect(Collectors.toList()));
        }
    }
}

