/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.InferredAxiomGenerator;
import org.semanticweb.owlapi.util.InferredClassAssertionAxiomGenerator;
import org.semanticweb.owlapi.util.InferredDataPropertyCharacteristicAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentClassAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentDataPropertiesAxiomGenerator;
import org.semanticweb.owlapi.util.InferredEquivalentObjectPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.InferredInverseObjectPropertiesAxiomGenerator;
import org.semanticweb.owlapi.util.InferredObjectPropertyCharacteristicAxiomGenerator;
import org.semanticweb.owlapi.util.InferredPropertyAssertionGenerator;
import org.semanticweb.owlapi.util.InferredSubClassAxiomGenerator;
import org.semanticweb.owlapi.util.InferredSubDataPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.InferredSubObjectPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InferredOntologyGenerator {
    private static Logger logger = LoggerFactory.getLogger((String)InferredOntologyGenerator.class.getName());
    @Nonnull
    private final OWLReasoner reasoner;
    @Nonnull
    private final List<InferredAxiomGenerator<? extends OWLAxiom>> axiomGenerators;

    public InferredOntologyGenerator(@Nonnull OWLReasoner reasoner, @Nonnull List<InferredAxiomGenerator<? extends OWLAxiom>> axiomGenerators) {
        this.reasoner = OWLAPIPreconditions.checkNotNull(reasoner, "reasoner cannot be null");
        OWLAPIPreconditions.checkNotNull(axiomGenerators, "axiomGenerators cannot be null");
        this.axiomGenerators = new ArrayList<InferredAxiomGenerator<? extends OWLAxiom>>(axiomGenerators);
    }

    public InferredOntologyGenerator(@Nonnull OWLReasoner reasoner) {
        this(reasoner, InferredOntologyGenerator.generators());
    }

    @Nonnull
    private static List<InferredAxiomGenerator<? extends OWLAxiom>> generators() {
        return CollectionFactory.list(new InferredAxiomGenerator[]{new InferredClassAssertionAxiomGenerator(), new InferredDataPropertyCharacteristicAxiomGenerator(), new InferredEquivalentClassAxiomGenerator(), new InferredEquivalentDataPropertiesAxiomGenerator(), new InferredEquivalentObjectPropertyAxiomGenerator(), new InferredInverseObjectPropertiesAxiomGenerator(), new InferredObjectPropertyCharacteristicAxiomGenerator(), new InferredPropertyAssertionGenerator(), new InferredSubClassAxiomGenerator(), new InferredSubDataPropertyAxiomGenerator(), new InferredSubObjectPropertyAxiomGenerator()});
    }

    @Nonnull
    public List<InferredAxiomGenerator<?>> getAxiomGenerators() {
        return new ArrayList(this.axiomGenerators);
    }

    public void addGenerator(@Nonnull InferredAxiomGenerator<?> generator) {
        OWLAPIPreconditions.checkNotNull(generator, "generator cannot be null");
        if (!this.axiomGenerators.contains(generator)) {
            this.axiomGenerators.add(generator);
        }
    }

    public void removeGenerator(@Nonnull InferredAxiomGenerator<?> generator) {
        OWLAPIPreconditions.checkNotNull(generator, "generator cannot be null");
        this.axiomGenerators.remove(generator);
    }

    public void fillOntology(@Nonnull OWLDataFactory df, @Nonnull OWLOntology ontology) {
        OWLAPIPreconditions.checkNotNull(df, "df cannot be null");
        OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (InferredAxiomGenerator<? extends OWLAxiom> axiomGenerator : this.axiomGenerators) {
            try {
                for (OWLAxiom oWLAxiom : axiomGenerator.createAxioms(df, this.reasoner)) {
                    assert (oWLAxiom != null);
                    if (ontology.containsAxiom(oWLAxiom, Imports.INCLUDED, AxiomAnnotations.IGNORE_AXIOM_ANNOTATIONS)) continue;
                    changes.add(new AddAxiom(ontology, oWLAxiom));
                }
            }
            catch (Exception e) {
                logger.warn("Error generating {} axioms using {}, version {}", new Object[]{axiomGenerator.getLabel(), this.reasoner.getReasonerName(), this.reasoner.getReasonerVersion(), e});
            }
        }
        ontology.getOWLOntologyManager().applyChanges(changes);
    }
}

