/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatEditor;
import com.intellij.database.csv.CsvFormatResolver;
import com.intellij.database.csv.CsvFormatter;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.editor.TableFileEditor;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.database.vfs.fragment.CsvTableDataFragmentFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class CsvTableFileEditor
extends TableFileEditor
implements CsvFormatEditor {
    private final DataGrid myDataGrid;

    public CsvTableFileEditor(@NotNull Project project, @NotNull CsvTableDataFragmentFile file) {
        if (project == null) {
            CsvTableFileEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CsvTableFileEditor.$$$reportNull$$$0(1);
        }
        super(project, file.getOriginalFile());
        CsvDocumentDataHookUp hookUp = GridDataHookUpManager.getInstance(project).getHookUp(file, (Disposable)this);
        this.myDataGrid = this.createDataGrid((GridDataHookUp<GridRow, GridColumn>)hookUp);
        GridUtil.addGridHeaderComponent(this.myDataGrid);
    }

    public CsvTableFileEditor(@NotNull Project project, @NotNull VirtualFile file, @NotNull CsvFormat format) {
        if (project == null) {
            CsvTableFileEditor.$$$reportNull$$$0(2);
        }
        if (file == null) {
            CsvTableFileEditor.$$$reportNull$$$0(3);
        }
        if (format == null) {
            CsvTableFileEditor.$$$reportNull$$$0(4);
        }
        super(project, file);
        CsvDocumentDataHookUp hookUp = GridDataHookUpManager.getInstance(project).getHookUp(file, format, (Disposable)this);
        this.myDataGrid = this.createDataGrid((GridDataHookUp<GridRow, GridColumn>)hookUp);
        GridUtil.addGridHeaderComponent(this.myDataGrid);
    }

    @Override
    protected void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            CsvTableFileEditor.$$$reportNull$$$0(5);
        }
        super.uiDataSnapshot(sink);
        sink.set(CSV_FORMAT_EDITOR_KEY, (Object)this);
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            CsvTableFileEditor.$$$reportNull$$$0(6);
        }
        CsvDocumentDataHookUp hookup = this.getHookup();
        return CsvTableFileEditor.getState(level, hookup);
    }

    @Override
    protected void configure(@NotNull DataGrid grid, @NotNull DataGridAppearance appearance) {
        if (grid == null) {
            CsvTableFileEditor.$$$reportNull$$$0(7);
        }
        if (appearance == null) {
            CsvTableFileEditor.$$$reportNull$$$0(8);
        }
        GridUtil.configureCsvTable(grid, appearance);
    }

    @NotNull
    public static FileEditorState getState(@NotNull FileEditorStateLevel level, @NotNull CsvDocumentDataHookUp hookup) {
        if (level == null) {
            CsvTableFileEditor.$$$reportNull$$$0(9);
        }
        if (hookup == null) {
            CsvTableFileEditor.$$$reportNull$$$0(10);
        }
        FileEditorState fileEditorState = level == FileEditorStateLevel.FULL && hookup.getRange() == null ? new CsvFormatResolver.State(hookup.getFormat()) : FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            CsvTableFileEditor.$$$reportNull$$$0(11);
        }
        return fileEditorState;
    }

    @Override
    public void setState(@NotNull FileEditorState state) {
        CsvFormat format;
        if (state == null) {
            CsvTableFileEditor.$$$reportNull$$$0(12);
        }
        if ((format = CsvFormatResolver.readCsvFormat(state)) != null && !format.equals((Object)this.getHookup().getFormat())) {
            this.setFormat(format);
        }
    }

    @Override
    @NotNull
    public DataGrid getDataGrid() {
        DataGrid dataGrid = this.myDataGrid;
        if (dataGrid == null) {
            CsvTableFileEditor.$$$reportNull$$$0(13);
        }
        return dataGrid;
    }

    @NotNull
    public CsvFormat getFormat() {
        CsvFormat csvFormat = this.getHookup().getFormat();
        if (csvFormat == null) {
            CsvTableFileEditor.$$$reportNull$$$0(14);
        }
        return csvFormat;
    }

    public void setFormat(@NotNull CsvFormat format) {
        if (format == null) {
            CsvTableFileEditor.$$$reportNull$$$0(15);
        }
        this.getHookup().setFormat(format, new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this.myDataGrid)));
    }

    @NotNull
    private CsvDocumentDataHookUp getHookup() {
        CsvDocumentDataHookUp csvDocumentDataHookUp = (CsvDocumentDataHookUp)this.myDataGrid.getDataHookup();
        if (csvDocumentDataHookUp == null) {
            CsvTableFileEditor.$$$reportNull$$$0(16);
        }
        return csvDocumentDataHookUp;
    }

    public boolean firstRowIsHeader() {
        return this.getHookup().getFormat().headerRecord != null;
    }

    public void setFirstRowIsHeader(boolean value) {
        this.setFormat(CsvFormatter.setFirstRowIsHeader((CsvFormat)this.getHookup().getFormat(), (boolean)value));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 13, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appearance";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookup";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/CsvTableFileEditor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/CsvTableFileEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataGrid";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getHookup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setFormat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 13, 14, 16 -> new IllegalStateException(string);
        };
    }
}

