/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.shell_integration;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.util.PathUtil;
import com.intellij.util.system.OS;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.ShellStartupOptionsKt;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.util.ShellNameUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u001c\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/shell_integration/TerminalPSReadLineUpdateUtil;", "", "<init>", "()V", "ASK_UPDATE_ENV", "", "TEXT_LINE_1_ENV", "TEXT_LINE_2_ENV", "TEXT_LINE_3_ENV", "IDE_NAME_ENV", "configureOptions", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions;", "options", "configureAskingForUpdate", "addLocalizationEnvVars", "", "map", "", "isPowerShell", "", "intellij.terminal"})
public final class TerminalPSReadLineUpdateUtil {
    @NotNull
    public static final TerminalPSReadLineUpdateUtil INSTANCE = new TerminalPSReadLineUpdateUtil();
    @NotNull
    private static final String ASK_UPDATE_ENV = "__JETBRAINS_INTELLIJ_ASK_PSREADLINE_UPDATE";
    @NotNull
    private static final String TEXT_LINE_1_ENV = "__JETBRAINS_INTELLIJ_PSREADLINE__UPDATE_TEXT_LINE_1";
    @NotNull
    private static final String TEXT_LINE_2_ENV = "__JETBRAINS_INTELLIJ_PSREADLINE__UPDATE_TEXT_LINE_2";
    @NotNull
    private static final String TEXT_LINE_3_ENV = "__JETBRAINS_INTELLIJ_PSREADLINE__UPDATE_TEXT_LINE_3";
    @NotNull
    private static final String IDE_NAME_ENV = "__JETBRAINS_INTELLIJ_PSREADLINE__UPDATE_IDE_NAME";

    private TerminalPSReadLineUpdateUtil() {
    }

    @JvmStatic
    @NotNull
    public static final ShellStartupOptions configureOptions(@NotNull ShellStartupOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!INSTANCE.isPowerShell(options)) {
            return options;
        }
        OS os = OS.CURRENT;
        boolean isWin10 = os == OS.Windows && os.isAtLeast(10, 0) && !os.isAtLeast(11, 0);
        boolean alreadyDisabled = StringsKt.equals((String)options.getEnvVariables().get(ASK_UPDATE_ENV), (String)"false", (boolean)true);
        return isWin10 && !alreadyDisabled ? INSTANCE.configureAskingForUpdate(options) : options;
    }

    private final ShellStartupOptions configureAskingForUpdate(ShellStartupOptions options) {
        Map<String, String> newEnvs = ShellStartupOptionsKt.createEnvVariablesMap(options.getEnvVariables());
        newEnvs.put(ASK_UPDATE_ENV, "true");
        this.addLocalizationEnvVars(newEnvs);
        return options.builder().envVariables(newEnvs).build();
    }

    private final void addLocalizationEnvVars(Map<String, String> map2) {
        Map<String, String> map3 = map2;
        String string = TEXT_LINE_1_ENV;
        Object object = new Object[]{"{0}", "{1}"};
        object = TerminalBundle.message("psreadline.update.line.1", object);
        map3.put(string, (String)object);
        map3 = map2;
        string = TEXT_LINE_2_ENV;
        object = new Object[]{"{0}"};
        object = TerminalBundle.message("psreadline.update.line.2", object);
        map3.put(string, (String)object);
        map2.put(TEXT_LINE_3_ENV, TerminalBundle.message("psreadline.update.line.3", new Object[0]));
        map2.put(IDE_NAME_ENV, ApplicationNamesInfo.getInstance().getFullProductName());
    }

    private final boolean isPowerShell(ShellStartupOptions options) {
        List<String> list = options.getShellCommand();
        if (list == null) {
            return false;
        }
        List<String> shellCommand = list;
        String string = (String)CollectionsKt.firstOrNull(shellCommand);
        if (string == null) {
            return false;
        }
        String commandName = string;
        String string2 = PathUtil.getFileName((String)commandName);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFileName(...)");
        String shellName = string2;
        return ShellNameUtil.isPowerShell(shellName);
    }
}

