/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.texplate.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.parser.ParseException;
import org.islandoftex.texplate.exceptions.TemplateMergingException;
import org.islandoftex.texplate.model.Template;
import org.islandoftex.texplate.model.handlers.Handler;
import org.islandoftex.texplate.util.HandlerUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.helpers.NOPLoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tH\u0007JH\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/islandoftex/texplate/util/MergingUtils;", "", "<init>", "()V", "mergeTemplate", "", "template", "Lorg/islandoftex/texplate/model/Template;", "map", "", "", "output", "Ljava/nio/file/Path;", "cmap", "handle", "configmap", "texplate"})
@SourceDebugExtension(value={"SMAP\nMergingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergingUtils.kt\norg/islandoftex/texplate/util/MergingUtils\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,127:1\n462#2:128\n412#2:129\n1246#3,4:130\n216#4,2:134\n*S KotlinDebug\n*F\n+ 1 MergingUtils.kt\norg/islandoftex/texplate/util/MergingUtils\n*L\n104#1:128\n104#1:129\n104#1:130,4\n109#1:134,2\n*E\n"})
public final class MergingUtils {
    @NotNull
    public static final MergingUtils INSTANCE = new MergingUtils();

    private MergingUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final long mergeTemplate(@NotNull Template template, @NotNull Map<String, String> map, @NotNull Path output, @NotNull Map<String, ? extends Object> cmap) throws TemplateMergingException {
        Intrinsics.checkNotNullParameter(template, "template");
        Intrinsics.checkNotNullParameter(map, "map");
        Intrinsics.checkNotNullParameter(output, "output");
        Intrinsics.checkNotNullParameter(cmap, "cmap");
        Map<String, Object> context = INSTANCE.handle(template, map, cmap);
        try {
            File file = output.toFile();
            Intrinsics.checkNotNullExpressionValue(file, "toFile(...)");
            Object object = file;
            Object object2 = Charsets.UTF_8;
            object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)object2);
            object2 = null;
            try {
                OutputStreamWriter writer = (OutputStreamWriter)object;
                boolean bl = false;
                String string = template.getDocument();
                Intrinsics.checkNotNull(string);
                StringReader reader = new StringReader(string);
                RuntimeServices services = RuntimeSingleton.getRuntimeServices();
                services.addProperty("runtime.log.instance", new NOPLoggerFactory().getLogger(""));
                org.apache.velocity.Template reference = new org.apache.velocity.Template();
                reference.setRuntimeServices(services);
                reference.setData(services.parse(reader, reference));
                reference.initDocument();
                VelocityContext entries = new VelocityContext(context);
                reference.merge(entries, writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception2 instanceof IOException || exception2 instanceof MethodInvocationException || exception2 instanceof ParseErrorException || exception2 instanceof ParseException || exception2 instanceof ResourceNotFoundException || exception2 instanceof TemplateInitException) {
                throw new TemplateMergingException("An error occurred while trying to merge the template reference with the provided data. Make sure the template is correct and try again. The raised exception might give us some hints on what exactly happened. Typically, make sure the template strictly follows the Velocity 2.0 language syntax.", exception);
            }
            throw new TemplateMergingException("Fatal error occured. This error should never happen. Please make a detailed report to the developers.");
        }
        return output.toFile().length();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> handle(Template template, Map<String, String> map, Map<String, ? extends Object> configmap) {
        Map<String, Object> map2;
        if (template.getHandlers().isEmpty()) {
            void $this$mapValuesTo$iv$iv;
            Map<String, ? extends Object> $this$mapValues$iv = configmap;
            boolean $i$f$mapValues = false;
            Map<String, ? extends Object> map3 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map5 = map4;
                boolean bl2 = false;
                String string = it.getValue().toString();
                map5.put(k, string);
            }
            map2 = MapsKt.plus(destination$iv$iv, map);
        } else {
            Map result = new LinkedHashMap();
            Map<String, String> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator2.next();
                boolean bl = false;
                String key = entry.getKey();
                String value = entry.getValue();
                if (template.getHandlers().containsKey(key) && HandlerUtils.getHandlers().containsKey(template.getHandlers().get(key))) {
                    Handler handler = HandlerUtils.getHandlers().get(template.getHandlers().get(key));
                    Intrinsics.checkNotNull(handler);
                    result.put(key, handler.apply(value));
                    continue;
                }
                result.put(key, value);
            }
            map2 = MapsKt.plus(configmap, result);
        }
        return map2;
    }
}

