/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.runtime;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class SystemJob
extends AbstractJob {
    private final DBRRunnableWithProgress runnable;

    public SystemJob(String name, DBRRunnableWithProgress runnable) {
        super(name);
        this.setSystem(true);
        this.setUser(false);
        this.runnable = runnable;
    }

    @Override
    @NotNull
    protected IStatus run(@NotNull DBRProgressMonitor monitor) {
        try {
            this.runnable.run(monitor);
        }
        catch (InvocationTargetException e) {
            return GeneralUtils.makeExceptionStatus(e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }
}

