﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securitylake/SecurityLake_EXPORTS.h>
#include <aws/securitylake/model/AwsLogSourceName.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityLake {
namespace Model {

/**
 * <p>Amazon Security Lake can collect logs and events from natively-supported
 * Amazon Web Services services.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securitylake-2018-05-10/AwsLogSourceResource">AWS
 * API Reference</a></p>
 */
class AwsLogSourceResource {
 public:
  AWS_SECURITYLAKE_API AwsLogSourceResource() = default;
  AWS_SECURITYLAKE_API AwsLogSourceResource(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYLAKE_API AwsLogSourceResource& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYLAKE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name for a Amazon Web Services source. This must be a Regionally unique
   * value.</p>
   */
  inline AwsLogSourceName GetSourceName() const { return m_sourceName; }
  inline bool SourceNameHasBeenSet() const { return m_sourceNameHasBeenSet; }
  inline void SetSourceName(AwsLogSourceName value) {
    m_sourceNameHasBeenSet = true;
    m_sourceName = value;
  }
  inline AwsLogSourceResource& WithSourceName(AwsLogSourceName value) {
    SetSourceName(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version for a Amazon Web Services source. This must be a Regionally
   * unique value.</p>
   */
  inline const Aws::String& GetSourceVersion() const { return m_sourceVersion; }
  inline bool SourceVersionHasBeenSet() const { return m_sourceVersionHasBeenSet; }
  template <typename SourceVersionT = Aws::String>
  void SetSourceVersion(SourceVersionT&& value) {
    m_sourceVersionHasBeenSet = true;
    m_sourceVersion = std::forward<SourceVersionT>(value);
  }
  template <typename SourceVersionT = Aws::String>
  AwsLogSourceResource& WithSourceVersion(SourceVersionT&& value) {
    SetSourceVersion(std::forward<SourceVersionT>(value));
    return *this;
  }
  ///@}
 private:
  AwsLogSourceName m_sourceName{AwsLogSourceName::NOT_SET};
  bool m_sourceNameHasBeenSet = false;

  Aws::String m_sourceVersion;
  bool m_sourceVersionHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityLake
}  // namespace Aws
