/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.util.Objects;
import java.util.Properties;
import java.util.function.Predicate;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.CriStats;
import oracle.ucp.common.Topology;
import oracle.ucp.jdbc.BorrowContext;
import oracle.ucp.jdbc.BorrowContextUpdater;
import oracle.ucp.jdbc.BorrowContextUpdaterGetter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.util.OpaqueString;
import oracle.ucp.util.UCPErrorHandler;

public class JDBCConnectionRetrievalInfo
extends BorrowContext.Impl
implements ConnectionRetrievalInfo,
BorrowContext,
BorrowContextUpdaterGetter {
    static final String CLASS_NAME = JDBCConnectionRetrievalInfo.class.getName();
    private CriStats criMetadata = null;

    @Override
    public BorrowContextUpdater getBorrowContextUpdater() {
        return this.getUpdater();
    }

    public JDBCConnectionRetrievalInfo(BorrowContext borrowContext, BorrowContextUpdater updater, CriStats criMetadata) {
        super(Objects.requireNonNull(borrowContext), updater);
        this.getUpdater().registerEqualityChangeTrigger(this::clearCache);
        this.criMetadata = criMetadata;
    }

    public JDBCConnectionRetrievalInfo(BorrowContext borrowContext, BorrowContextUpdater updater) {
        this(borrowContext, updater, null);
    }

    JDBCConnectionRetrievalInfo(PoolDataSourceImpl pds, BorrowContextUpdater updater) {
        this(BorrowContext.build(Objects.requireNonNull(pds)), updater);
    }

    public JDBCConnectionRetrievalInfo(PoolDataSourceImpl pds) {
        this(pds, new BorrowContextUpdater());
    }

    @Deprecated
    public JDBCConnectionRetrievalInfo(String user, String password) {
        this(user, OpaqueString.newOpaqueString(password), null);
    }

    @Deprecated
    public JDBCConnectionRetrievalInfo(String user, String password, Properties labels) {
        this(user, OpaqueString.newOpaqueString(password), labels);
    }

    public JDBCConnectionRetrievalInfo(String user, OpaqueString password) {
        this(user, password, null);
    }

    public JDBCConnectionRetrievalInfo(String user, OpaqueString password, Properties labels) {
        this(new BorrowContext(){}, new BorrowContextUpdater().user(user).password(password).labels(labels));
    }

    public JDBCConnectionRetrievalInfo(JDBCConnectionRetrievalInfo copyCri) {
        this(copyCri.getContext(), new BorrowContextUpdater(copyCri.getUpdater()));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JDBCConnectionRetrievalInfo)) {
            return false;
        }
        JDBCConnectionRetrievalInfo other = (JDBCConnectionRetrievalInfo)obj;
        return Objects.equals(this.getUser(), other.getUser()) && Objects.equals(this.getServiceName(), other.getServiceName());
    }

    @Override
    public boolean equalsIncludingPassword(ConnectionRetrievalInfo cri) {
        Objects.requireNonNull(cri);
        Objects.requireNonNull(this.getPassword());
        return this.equals(cri) && Objects.equals(this.getPassword(), ((JDBCConnectionRetrievalInfo)cri).getPassword());
    }

    public int hashCode() {
        return Objects.hash(this.getUser(), this.getServiceName());
    }

    @Override
    public void addLabel(String key, String value) throws UniversalConnectionPoolException {
        if (key == null || key.equals("")) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(201);
        }
        String val = value == null ? "" : value;
        Properties labels = this.getUpdater().getLabels();
        if (null == labels) {
            Properties newLabels = new Properties();
            newLabels.put(key, value);
            this.getUpdater().labels(newLabels);
        } else {
            labels.put(key, val);
        }
    }

    @Override
    public void removeLabel(String key) throws UniversalConnectionPoolException {
        if (key == null || key.equals("")) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(201);
        }
        Properties labels = this.getUpdater().getLabels();
        if (null != labels) {
            labels.remove(key);
            if (labels.isEmpty()) {
                this.getUpdater().labels(null);
            }
        }
    }

    @Override
    public JDBCConnectionRetrievalInfo getCopyWithNoLabels() {
        JDBCConnectionRetrievalInfo newjcri = new JDBCConnectionRetrievalInfo(this.getContext(), new BorrowContextUpdater(this.getUpdater()).labels(null));
        return newjcri;
    }

    public JDBCConnectionRetrievalInfo getCopyWithNewProxyProperties(int type, Properties newProxyProps) {
        return new JDBCConnectionRetrievalInfo(this.getContext(), new BorrowContextUpdater(this.getUpdater()).proxyProperties(type, newProxyProps));
    }

    public JDBCConnectionRetrievalInfo getCopyWithService(String newService) {
        return new JDBCConnectionRetrievalInfo(this.getContext(), new BorrowContextUpdater(this.getUpdater()).serviceName(newService));
    }

    @Override
    public JDBCConnectionRetrievalInfo getCopyWithUpdatedPassword() {
        PoolDataSourceImpl pds = this.getPoolDataSource();
        if (null == pds) {
            return this;
        }
        JDBCConnectionPool pool = pds.connectionPool;
        if (null == pool) {
            return this;
        }
        ConnectionRetrievalInfo defaultCri = pool.getConnectionRetrievalInfo();
        if (null == defaultCri || !(defaultCri instanceof JDBCConnectionRetrievalInfo)) {
            return this;
        }
        if (!this.equals(defaultCri)) {
            return this;
        }
        OpaqueString newPassword = ((JDBCConnectionRetrievalInfo)defaultCri).getPassword();
        return new JDBCConnectionRetrievalInfo(this.getContext(), new BorrowContextUpdater(this.getBorrowContextUpdater()).password(newPassword));
    }

    private Topology getTopology() {
        JDBCConnectionPool pool;
        PoolDataSourceImpl pds = this.getPoolDataSource();
        if (null != pds && null != (pool = pds.connectionPool)) {
            return (Topology)pool.connectionSource();
        }
        return null;
    }

    @Override
    public CriStats getCriMetadata() {
        Topology topology;
        CriStats criMetadata = this.criMetadata;
        if (null == criMetadata && null != (topology = this.getTopology())) {
            criMetadata = this.criMetadata = topology.getNonCachedCriMetadata(this);
        }
        return criMetadata;
    }

    @Override
    public ConnectionAffinityCallback getConnectionAffinityCallback() {
        JDBCConnectionPool pool;
        PoolDataSourceImpl pds = this.getPoolDataSource();
        if (null != pds && null != (pool = pds.connectionPool)) {
            return pool.getConnectionAffinityCallback();
        }
        return null;
    }

    @Override
    public Predicate<CoreConnection> criMatchSelector() {
        Topology topology = this.getTopology();
        if (null != topology && topology.criMetadataRegistrySize() <= 1) {
            return conn -> true;
        }
        return conn -> this.equalsIncludingPassword(conn.cri());
    }

    public void clearCache() {
        this.criMetadata = null;
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public String stringValue() {
        return this.toString();
    }

    public static final class Builder
    extends BorrowContextUpdater {
        @Override
        public BorrowContextUpdater serviceName(String serviceName) {
            return super.serviceName(serviceName.toLowerCase());
        }

        @Override
        public BorrowContextUpdater userRequestedServiceName(String serviceName) {
            return super.userRequestedServiceName(serviceName.toLowerCase());
        }
    }
}

