/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.factory;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.factory.BaseFactory;
import com.opensymphony.module.sitemesh.factory.FactoryException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DefaultFactory
extends BaseFactory {
    private static final String DEFAULT_CONFIG_FILENAME = "/WEB-INF/sitemesh.xml";
    String configFileName;
    File configFile;
    long configLastModified;
    private long configLastCheck = 0L;
    public static long configCheckMillis = 3000L;
    Map configProps = new HashMap();
    String excludesFileName;
    File excludesFile;

    public DefaultFactory(Config config) {
        super(config);
        String initParamConfigFile;
        this.configFileName = config.getServletContext().getInitParameter("sitemesh.configfile");
        if (this.configFileName == null) {
            this.configFileName = DEFAULT_CONFIG_FILENAME;
        }
        if ((initParamConfigFile = config.getConfigFile()) != null) {
            this.configFileName = initParamConfigFile;
        }
        this.configFile = this.loadFile(this.configFileName);
        this.loadConfig();
    }

    private File loadFile(String fileName) {
        if (fileName.startsWith("classpath:")) {
            return null;
        }
        String filePath = this.config.getServletContext().getRealPath(fileName);
        return filePath != null ? new File(filePath) : null;
    }

    private InputStream loadStream(File file, String fileName) throws IOException {
        if (file != null && file.exists() && file.canRead()) {
            return file.toURI().toURL().openStream();
        }
        if (fileName.startsWith("classpath:")) {
            return this.loadClasspathStream(fileName.substring("classpath:".length()));
        }
        return this.config.getServletContext().getResourceAsStream(fileName);
    }

    private InputStream loadClasspathStream(String classPathResource) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(classPathResource);
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classPathResource);
        }
        return is;
    }

    private Element loadRootElement(InputStream is) throws ParserConfigurationException, IOException, SAXException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
        return document.getDocumentElement();
    }

    private synchronized void loadConfig() {
        try {
            Element root = this.loadSitemeshXML();
            NodeList sections = root.getChildNodes();
            for (int i = 0; i < sections.getLength(); ++i) {
                String fileName;
                if (!(sections.item(i) instanceof Element)) continue;
                Element curr = (Element)sections.item(i);
                NodeList children = curr.getChildNodes();
                if ("config-refresh".equalsIgnoreCase(curr.getTagName())) {
                    String seconds = curr.getAttribute("seconds");
                    configCheckMillis = Long.parseLong(seconds) * 1000L;
                    continue;
                }
                if ("property".equalsIgnoreCase(curr.getTagName())) {
                    String name = curr.getAttribute("name");
                    String value = curr.getAttribute("value");
                    if ("".equals(name) || "".equals(value)) continue;
                    this.configProps.put("${" + name + "}", value);
                    continue;
                }
                if ("page-parsers".equalsIgnoreCase(curr.getTagName())) {
                    this.loadPageParsers(children);
                    continue;
                }
                if ("decorator-mappers".equalsIgnoreCase(curr.getTagName())) {
                    this.loadDecoratorMappers(children);
                    continue;
                }
                if (!"excludes".equalsIgnoreCase(curr.getTagName()) || "".equals(fileName = this.replaceProperties(curr.getAttribute("file")))) continue;
                this.excludesFileName = fileName;
                this.loadExcludes();
            }
        }
        catch (ParserConfigurationException e) {
            throw new FactoryException("Could not get XML parser", e);
        }
        catch (IOException e) {
            throw new FactoryException("Could not read config file : " + this.configFileName, e);
        }
        catch (SAXException e) {
            throw new FactoryException("Could not parse config file : " + this.configFileName, e);
        }
    }

    private Element loadSitemeshXML() throws ParserConfigurationException, IOException, SAXException {
        Element root;
        InputStream is = this.loadStream(this.configFile, this.configFileName);
        if (is == null && (is = this.loadClasspathStream("com/opensymphony/module/sitemesh/factory/sitemesh-default.xml")) == null) {
            throw new IllegalStateException("Cannot load default configuration from jar");
        }
        if (this.configFile != null) {
            this.configLastModified = this.configFile.lastModified();
        }
        if (!"sitemesh".equalsIgnoreCase((root = this.loadRootElement(is)).getTagName())) {
            throw new FactoryException("Root element of sitemesh configuration file not <sitemesh>", null);
        }
        return root;
    }

    private void loadExcludes() throws ParserConfigurationException, IOException, SAXException {
        this.excludesFile = this.loadFile(this.excludesFileName);
        InputStream is = this.loadStream(this.excludesFile, this.excludesFileName);
        if (is == null) {
            throw new IllegalStateException("Cannot load excludes configuration file \"" + this.excludesFileName + "\" as specified in \"sitemesh.xml\" or \"sitemesh-default.xml\"");
        }
        Element root = this.loadRootElement(is);
        NodeList sections = root.getChildNodes();
        for (int i = 0; i < sections.getLength(); ++i) {
            Element curr;
            if (!(sections.item(i) instanceof Element) || !"excludes".equalsIgnoreCase((curr = (Element)sections.item(i)).getTagName())) continue;
            this.loadExcludeUrls(curr.getChildNodes());
        }
    }

    private void loadPageParsers(NodeList nodes) {
        this.clearParserMappings();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element curr;
            if (!(nodes.item(i) instanceof Element) || !"parser".equalsIgnoreCase((curr = (Element)nodes.item(i)).getTagName())) continue;
            String className = curr.getAttribute("class");
            String contentType = curr.getAttribute("content-type");
            this.mapParser(contentType, className);
        }
    }

    private void loadDecoratorMappers(NodeList nodes) {
        this.clearDecoratorMappers();
        Properties emptyProps = new Properties();
        this.pushDecoratorMapper("com.opensymphony.module.sitemesh.mapper.NullDecoratorMapper", emptyProps);
        for (int i = nodes.getLength() - 1; i > 0; --i) {
            Element curr;
            if (!(nodes.item(i) instanceof Element) || !"mapper".equalsIgnoreCase((curr = (Element)nodes.item(i)).getTagName())) continue;
            String className = curr.getAttribute("class");
            Properties props = new Properties();
            NodeList children = curr.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Element currC;
                if (!(children.item(j) instanceof Element) || !"param".equalsIgnoreCase((currC = (Element)children.item(j)).getTagName())) continue;
                String value = currC.getAttribute("value");
                props.put(currC.getAttribute("name"), this.replaceProperties(value));
            }
            this.pushDecoratorMapper(className, props);
        }
        this.pushDecoratorMapper("com.opensymphony.module.sitemesh.mapper.InlineDecoratorMapper", emptyProps);
    }

    private void loadExcludeUrls(NodeList nodes) {
        this.clearExcludeUrls();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String pattern;
            Text patternText;
            Element p;
            if (!(nodes.item(i) instanceof Element) || !"pattern".equalsIgnoreCase((p = (Element)nodes.item(i)).getTagName()) && !"url-pattern".equalsIgnoreCase(p.getTagName()) || (patternText = (Text)p.getFirstChild()) == null || (pattern = patternText.getData().trim()) == null) continue;
            this.addExcludeUrl(pattern);
        }
    }

    @Override
    public void refresh() {
        long time = System.currentTimeMillis();
        if (time - this.configLastCheck < configCheckMillis) {
            return;
        }
        this.configLastCheck = time;
        if (this.configFile != null && this.configLastModified != this.configFile.lastModified()) {
            this.loadConfig();
        }
    }

    private String replaceProperties(String str) {
        Set props = this.configProps.entrySet();
        for (Map.Entry entry : props) {
            int idx;
            String key = (String)entry.getKey();
            while ((idx = str.indexOf(key)) >= 0) {
                StringBuilder buf = new StringBuilder(100);
                buf.append(str.substring(0, idx));
                buf.append(entry.getValue());
                buf.append(str.substring(idx + key.length()));
                str = buf.toString();
            }
        }
        return str;
    }
}

