# This file has been autogenerated by the pywayland scanner

# Copyright © 2013-2014 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlOutput


class WpPresentationFeedback(Interface):
    """Presentation time feedback event

    A presentation_feedback object returns an indication that a
    :class:`~pywayland.protocol.wayland.WlSurface` content update has become
    visible to the user. One object corresponds to one content update
    submission (:func:`WlSurface.commit()
    <pywayland.protocol.wayland.WlSurface.commit>`). There are two possible
    outcomes: the content update is presented to the user, and a presentation
    timestamp delivered; or, the user did not see the content update because it
    was superseded or its surface destroyed, and the content update is
    discarded.

    Once a presentation_feedback object has delivered a 'presented' or
    'discarded' event it is automatically destroyed.
    """

    name = "wp_presentation_feedback"
    version = 2

    class kind(enum.IntFlag):
        vsync = 0x1
        hw_clock = 0x2
        hw_completion = 0x4
        zero_copy = 0x8


class WpPresentationFeedbackProxy(Proxy[WpPresentationFeedback]):
    interface = WpPresentationFeedback


class WpPresentationFeedbackResource(Resource):
    interface = WpPresentationFeedback

    @WpPresentationFeedback.event(
        Argument(ArgumentType.Object, interface=WlOutput),
    )
    def sync_output(self, output: WlOutput) -> None:
        """Presentation synchronized to this output

        As presentation can be synchronized to only one output at a time, this
        event tells which output it was. This event is only sent prior to the
        presented event.

        As clients may bind to the same global
        :class:`~pywayland.protocol.wayland.WlOutput` multiple times, this
        event is sent for each bound instance that matches the synchronized
        output. If a client has not bound to the right
        :class:`~pywayland.protocol.wayland.WlOutput` global at all, this event
        is not sent.

        :param output:
            presentation output
        :type output:
            :class:`~pywayland.protocol.wayland.WlOutput`
        """
        self._post_event(0, output)

    @WpPresentationFeedback.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def presented(self, tv_sec_hi: int, tv_sec_lo: int, tv_nsec: int, refresh: int, seq_hi: int, seq_lo: int, flags: int) -> None:
        """The content update was displayed

        The associated content update was displayed to the user at the
        indicated time (tv_sec_hi/lo, tv_nsec). For the interpretation of the
        timestamp, see presentation.clock_id event.

        The timestamp corresponds to the time when the content update turned
        into light the first time on the surface's main output. Compositors may
        approximate this from the framebuffer flip completion events from the
        system, and the latency of the physical display path if known.

        This event is preceded by all related sync_output events telling which
        output's refresh cycle the feedback corresponds to, i.e. the main
        output for the surface. Compositors are recommended to choose the
        output containing the largest part of the
        :class:`~pywayland.protocol.wayland.WlSurface`, or keeping the output
        they previously chose. Having a stable presentation output association
        helps clients predict future output refreshes (vblank).

        The 'refresh' argument gives the compositor's prediction of how many
        nanoseconds after tv_sec, tv_nsec the very next output refresh may
        occur. This is to further aid clients in predicting future refreshes,
        i.e., estimating the timestamps targeting the next few vblanks. If such
        prediction cannot usefully be done, the argument is zero.

        For version 2 and later, if the output does not have a constant refresh
        rate, explicit video mode switches excluded, then the refresh argument
        must be either an appropriate rate picked by the compositor (e.g.
        fastest rate), or 0 if no such rate exists. For version 1, if the
        output does not have a constant refresh rate, the refresh argument must
        be zero.

        The 64-bit value combined from seq_hi and seq_lo is the value of the
        output's vertical retrace counter when the content update was first
        scanned out to the display. This value must be compatible with the
        definition of MSC in GLX_OML_sync_control specification. Note, that if
        the display path has a non-zero latency, the time instant specified by
        this counter may differ from the timestamp's.

        If the output does not have a concept of vertical retrace or a refresh
        cycle, or the output device is self-refreshing without a way to query
        the refresh count, then the arguments seq_hi and seq_lo must be zero.

        :param tv_sec_hi:
            high 32 bits of the seconds part of the presentation timestamp
        :type tv_sec_hi:
            `ArgumentType.Uint`
        :param tv_sec_lo:
            low 32 bits of the seconds part of the presentation timestamp
        :type tv_sec_lo:
            `ArgumentType.Uint`
        :param tv_nsec:
            nanoseconds part of the presentation timestamp
        :type tv_nsec:
            `ArgumentType.Uint`
        :param refresh:
            nanoseconds till next refresh
        :type refresh:
            `ArgumentType.Uint`
        :param seq_hi:
            high 32 bits of refresh counter
        :type seq_hi:
            `ArgumentType.Uint`
        :param seq_lo:
            low 32 bits of refresh counter
        :type seq_lo:
            `ArgumentType.Uint`
        :param flags:
            combination of 'kind' values
        :type flags:
            `ArgumentType.Uint`
        """
        self._post_event(1, tv_sec_hi, tv_sec_lo, tv_nsec, refresh, seq_hi, seq_lo, flags)

    @WpPresentationFeedback.event()
    def discarded(self) -> None:
        """The content update was not displayed

        The content update was never displayed to the user.
        """
        self._post_event(2)


class WpPresentationFeedbackGlobal(Global):
    interface = WpPresentationFeedback


WpPresentationFeedback._gen_c()
WpPresentationFeedback.proxy_class = WpPresentationFeedbackProxy
WpPresentationFeedback.resource_class = WpPresentationFeedbackResource
WpPresentationFeedback.global_class = WpPresentationFeedbackGlobal
