/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class CancelFlagFuture<T>
implements Future<T> {
    private final Future<T> wrappedFuture;
    private final AtomicBoolean cancelFlag;

    public CancelFlagFuture(Future<T> wrappedFuture, AtomicBoolean cancelFlag) {
        this.wrappedFuture = wrappedFuture;
        this.cancelFlag = cancelFlag;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean ret = this.wrappedFuture.cancel(mayInterruptIfRunning);
        if (ret) {
            this.cancelFlag.set(true);
        }
        return ret;
    }

    @Override
    public boolean isCancelled() {
        return this.wrappedFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.wrappedFuture.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.wrappedFuture.get();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.wrappedFuture.get(timeout, unit);
    }
}

