/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compactions;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.spi.compaction.CompactionPlan;
import org.apache.accumulo.core.spi.compaction.CompactionPlanner;
import org.apache.accumulo.core.spi.compaction.CompactionServiceId;
import org.slf4j.LoggerFactory;

public class ProvisionalCompactionPlanner
implements CompactionPlanner {
    private final CompactionServiceId serviceId;
    private final AtomicLong lastWarnNanoTime = new AtomicLong(System.nanoTime());

    public ProvisionalCompactionPlanner(CompactionServiceId serviceId) {
        this.serviceId = serviceId;
    }

    public void init(CompactionPlanner.InitParameters params) {
    }

    public CompactionPlan makePlan(CompactionPlanner.PlanningParameters params) {
        long nanoTime = System.nanoTime();
        long updatedTime = this.lastWarnNanoTime.updateAndGet(last -> {
            if (nanoTime - last > TimeUnit.MINUTES.toNanos(5L)) {
                return nanoTime;
            }
            return last;
        });
        if (updatedTime == nanoTime) {
            LoggerFactory.getLogger(ProvisionalCompactionPlanner.class).error("The compaction service '{}' is currently disabled, likely because it has bad configuration. No compactions will occur on this service until it is fixed.", (Object)this.serviceId);
        }
        return params.createPlanBuilder().build();
    }
}

