/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.model.Block;
import org.apache.camel.model.CopyableDefinition;
import org.apache.camel.model.DisabledAwareDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.OutputNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="otherwise")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OtherwiseDefinition
extends OptionalIdentifiedDefinition<OtherwiseDefinition>
implements CopyableDefinition<OtherwiseDefinition>,
Block,
DisabledAwareDefinition,
OutputNode {
    @XmlTransient
    private ProcessorDefinition<?> parent;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", description="Disables this EIP from the route.")
    private String disabled;
    @XmlElementRef
    private List<ProcessorDefinition<?>> outputs = new ArrayList();

    public OtherwiseDefinition() {
    }

    protected OtherwiseDefinition(OtherwiseDefinition source) {
        super(source);
        this.parent = source.parent;
        this.outputs = ProcessorDefinitionHelper.deepCopyDefinitions(source.outputs);
    }

    @Override
    public OtherwiseDefinition copyDefinition() {
        return new OtherwiseDefinition(this);
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        this.outputs = outputs;
    }

    @Override
    public ProcessorDefinition<?> getParent() {
        return this.parent;
    }

    public void setParent(ProcessorDefinition<?> parent) {
        this.parent = parent;
    }

    @Override
    public void addOutput(ProcessorDefinition<?> output) {
        output.setParent(this.parent);
        this.outputs.add(output);
    }

    @Override
    public void setId(String id) {
        if (this.outputs.isEmpty()) {
            super.setId(id);
        } else {
            ProcessorDefinition<?> last = this.outputs.get(this.outputs.size() - 1);
            last.setId(id);
        }
    }

    public String toString() {
        return "Otherwise[" + String.valueOf(this.getOutputs()) + "]";
    }

    public String getShortName() {
        return "otherwise";
    }

    public String getLabel() {
        return "otherwise";
    }

    @Override
    public String getDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }
}

