/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.shiro.authc;

import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.security.SecurityContext;
import org.apache.activemq.shiro.ConnectionReference;
import org.apache.activemq.shiro.authc.AuthenticationPolicy;
import org.apache.activemq.shiro.authc.AuthenticationTokenFactory;
import org.apache.activemq.shiro.authc.DefaultAuthenticationPolicy;
import org.apache.activemq.shiro.authc.DefaultAuthenticationTokenFactory;
import org.apache.activemq.shiro.env.EnvironmentFilter;
import org.apache.activemq.shiro.subject.ConnectionSubjectResolver;
import org.apache.activemq.shiro.subject.SubjectConnectionReference;
import org.apache.activemq.shiro.subject.SubjectSecurityContext;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFilter
extends EnvironmentFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    private AuthenticationPolicy authenticationPolicy = new DefaultAuthenticationPolicy();
    private AuthenticationTokenFactory authenticationTokenFactory = new DefaultAuthenticationTokenFactory();

    public AuthenticationPolicy getAuthenticationPolicy() {
        return this.authenticationPolicy;
    }

    public void setAuthenticationPolicy(AuthenticationPolicy authenticationPolicy) {
        this.authenticationPolicy = authenticationPolicy;
    }

    public AuthenticationTokenFactory getAuthenticationTokenFactory() {
        return this.authenticationTokenFactory;
    }

    public void setAuthenticationTokenFactory(AuthenticationTokenFactory authenticationTokenFactory) {
        this.authenticationTokenFactory = authenticationTokenFactory;
    }

    protected Subject getSubject(ConnectionReference conn) {
        return new ConnectionSubjectResolver(conn).getSubject();
    }

    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        SubjectConnectionReference connection;
        Subject subject;
        if (this.isEnabled() && !(subject = this.getSubject(new ConnectionReference(context, info, this.getEnvironment()))).isAuthenticated() && this.authenticationPolicy.isAuthenticationRequired(connection = new SubjectConnectionReference(context, info, this.getEnvironment(), subject))) {
            AuthenticationToken token = this.authenticationTokenFactory.getAuthenticationToken(connection);
            if (token == null) {
                String msg = "Unable to obtain authentication credentials for newly established connection.  Authentication is required.";
                throw new AuthenticationException(msg);
            }
            subject.login(token);
        }
        super.addConnection(context, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
        try {
            super.removeConnection(context, info, error);
        }
        finally {
            SubjectSecurityContext subjectSecurityContext;
            Subject subject;
            SecurityContext secCtx = context.getSecurityContext();
            if (secCtx instanceof SubjectSecurityContext && (subject = (subjectSecurityContext = (SubjectSecurityContext)secCtx).getSubject()) != null) {
                try {
                    subject.logout();
                }
                catch (Throwable t) {
                    String msg = "Unable to cleanly logout connection Subject during connection removal.  This is unexpected but not critical: it can be safely ignored because the connection will no longer be used.";
                    LOG.info(msg, t);
                }
            }
        }
    }
}

