/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.service.iam;

import com.google.protobuf.ProtocolStringList;
import jakarta.persistence.EntityNotFoundException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.custos.core.commons.StatusUpdater;
import org.apache.custos.core.exception.UnauthorizedException;
import org.apache.custos.core.iam.api.AddExternalIDPLinksRequest;
import org.apache.custos.core.iam.api.AddProtocolMapperRequest;
import org.apache.custos.core.iam.api.AddRolesRequest;
import org.apache.custos.core.iam.api.AddUserAttributesRequest;
import org.apache.custos.core.iam.api.AddUserRolesRequest;
import org.apache.custos.core.iam.api.Agent;
import org.apache.custos.core.iam.api.AgentClientMetadata;
import org.apache.custos.core.iam.api.AllRoles;
import org.apache.custos.core.iam.api.CheckingResponse;
import org.apache.custos.core.iam.api.ConfigureFederateIDPRequest;
import org.apache.custos.core.iam.api.DeleteExternalIDPsRequest;
import org.apache.custos.core.iam.api.DeleteRoleRequest;
import org.apache.custos.core.iam.api.DeleteTenantRequest;
import org.apache.custos.core.iam.api.DeleteUserAttributeRequest;
import org.apache.custos.core.iam.api.DeleteUserRolesRequest;
import org.apache.custos.core.iam.api.EventPersistenceRequest;
import org.apache.custos.core.iam.api.ExternalIDPLink;
import org.apache.custos.core.iam.api.FederateIDPResponse;
import org.apache.custos.core.iam.api.FindUsersRequest;
import org.apache.custos.core.iam.api.FindUsersResponse;
import org.apache.custos.core.iam.api.GetAllResources;
import org.apache.custos.core.iam.api.GetAllResourcesResponse;
import org.apache.custos.core.iam.api.GetExternalIDPsRequest;
import org.apache.custos.core.iam.api.GetExternalIDPsResponse;
import org.apache.custos.core.iam.api.GetOperationsMetadataRequest;
import org.apache.custos.core.iam.api.GetOperationsMetadataResponse;
import org.apache.custos.core.iam.api.GetRolesRequest;
import org.apache.custos.core.iam.api.GroupRepresentation;
import org.apache.custos.core.iam.api.GroupRequest;
import org.apache.custos.core.iam.api.GroupsRequest;
import org.apache.custos.core.iam.api.GroupsResponse;
import org.apache.custos.core.iam.api.MapperTypes;
import org.apache.custos.core.iam.api.OperationMetadata;
import org.apache.custos.core.iam.api.OperationStatus;
import org.apache.custos.core.iam.api.RegisterUserRequest;
import org.apache.custos.core.iam.api.RegisterUserResponse;
import org.apache.custos.core.iam.api.RegisterUsersRequest;
import org.apache.custos.core.iam.api.RegisterUsersResponse;
import org.apache.custos.core.iam.api.ResetUserPassword;
import org.apache.custos.core.iam.api.ResourceTypes;
import org.apache.custos.core.iam.api.RoleRepresentation;
import org.apache.custos.core.iam.api.SetUpTenantRequest;
import org.apache.custos.core.iam.api.SetUpTenantResponse;
import org.apache.custos.core.iam.api.UpdateUserProfileRequest;
import org.apache.custos.core.iam.api.UserAttribute;
import org.apache.custos.core.iam.api.UserGroupMappingRequest;
import org.apache.custos.core.iam.api.UserRepresentation;
import org.apache.custos.core.iam.api.UserSearchRequest;
import org.apache.custos.core.model.commons.StatusEntity;
import org.apache.custos.service.auth.TokenService;
import org.apache.custos.service.federated.client.keycloak.KeycloakClient;
import org.apache.custos.service.federated.client.keycloak.KeycloakClientSecret;
import org.apache.custos.service.iam.IAMOperations;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class IamAdminService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IamAdminService.class);
    private final KeycloakClient keycloakClient;
    private final StatusUpdater statusUpdater;
    private final TokenService tokenService;
    @Value(value="${iam.server.url}")
    private String iamServerURL;

    public IamAdminService(KeycloakClient keycloakClient, StatusUpdater statusUpdater, TokenService tokenService) {
        this.keycloakClient = keycloakClient;
        this.statusUpdater = statusUpdater;
        this.tokenService = tokenService;
    }

    public SetUpTenantResponse setUPTenant(SetUpTenantRequest request) {
        try {
            LOGGER.debug("Request received to setUPTenant  " + request.getTenantId());
            this.keycloakClient.deleteRealm(String.valueOf(request.getTenantId()));
            this.keycloakClient.createRealm(String.valueOf(request.getTenantId()), request.getTenantName());
            this.keycloakClient.createRealmAdminAccount(String.valueOf(request.getTenantId()), request.getAdminUsername(), request.getAdminFirstname(), request.getAdminLastname(), request.getAdminEmail(), request.getAdminPassword());
            KeycloakClientSecret clientSecret = this.keycloakClient.configureClient(String.valueOf(request.getTenantId()), request.getCustosClientId(), request.getTenantURL(), (List<String>)request.getRedirectURIsList());
            SetUpTenantResponse response = SetUpTenantResponse.newBuilder().setClientId(clientSecret.getClientId()).setClientSecret(clientSecret.getClientSecret()).build();
            this.statusUpdater.updateStatus(IAMOperations.SET_UP_TENANT.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getRequesterEmail());
            return response;
        }
        catch (Exception ex) {
            String msg = "Error occurred during setUPTenant" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.SET_UP_TENANT.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getRequesterEmail());
            throw new RuntimeException(msg, ex);
        }
    }

    public SetUpTenantResponse updateTenant(SetUpTenantRequest request) {
        try {
            LOGGER.debug("Request received to updateTenant  " + request.getTenantId());
            this.keycloakClient.updateRealm(String.valueOf(request.getTenantId()), request.getTenantName());
            this.keycloakClient.updateRealmAdminAccount(String.valueOf(request.getTenantId()), request.getAdminUsername(), request.getAdminFirstname(), request.getAdminLastname(), request.getAdminEmail(), request.getAdminPassword());
            KeycloakClientSecret clientSecret = this.keycloakClient.updateClient(String.valueOf(request.getTenantId()), request.getCustosClientId(), request.getTenantURL(), (List<String>)request.getRedirectURIsList());
            SetUpTenantResponse response = SetUpTenantResponse.newBuilder().setClientId(clientSecret.getClientId()).setClientSecret(clientSecret.getClientSecret()).build();
            this.statusUpdater.updateStatus(IAMOperations.UPDATE_TENANT.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getRequesterEmail());
            return response;
        }
        catch (Exception ex) {
            String msg = "Error occurred during updateTenant" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.UPDATE_TENANT.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getRequesterEmail());
            throw new RuntimeException(msg, ex);
        }
    }

    public void deleteTenant(DeleteTenantRequest request) {
        try {
            LOGGER.debug("Request received to delete tenant  " + request.getTenantId());
            this.keycloakClient.deleteRealm(String.valueOf(request.getTenantId()));
        }
        catch (Exception ex) {
            String msg = "Error occurred during delete tenant" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus isUsernameAvailable(UserSearchRequest request) {
        try {
            LOGGER.debug("Request received to isUsernameAvailable at " + request.getTenantId());
            boolean isAvailable = this.keycloakClient.isUsernameAvailable(String.valueOf(request.getTenantId()), request.getUser().getUsername(), request.getAccessToken());
            return OperationStatus.newBuilder().setStatus(isAvailable).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred during isUsernameAvailable" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus isUserEnabled(UserSearchRequest request) {
        try {
            LOGGER.debug("Request received to isUserEnabled at " + request.getTenantId());
            boolean isAvailable = this.keycloakClient.isUserAccountEnabled(String.valueOf(request.getTenantId()), request.getAccessToken(), request.getUser().getUsername());
            return OperationStatus.newBuilder().setStatus(isAvailable).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred during isUserEnabled" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public RegisterUserResponse registerUser(RegisterUserRequest request) {
        try {
            LOGGER.debug("Request received to registerUser for " + request.getTenantId());
            boolean registered = this.keycloakClient.createUser(String.valueOf(request.getTenantId()), request.getUser().getUsername(), request.getUser().getPassword(), request.getUser().getFirstName(), request.getUser().getLastName(), request.getUser().getEmail(), request.getUser().getTemporaryPassword(), request.getAccessToken());
            RegisterUserResponse registerUserResponse = RegisterUserResponse.newBuilder().setIsRegistered(registered).build();
            this.statusUpdater.updateStatus(IAMOperations.REGISTER_USER.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), String.valueOf(request.getTenantId()));
            return registerUserResponse;
        }
        catch (UnauthorizedException ex) {
            String msg = "Error occurred during registerUser" + String.valueOf((Object)ex);
            this.statusUpdater.updateStatus(IAMOperations.REGISTER_USER.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), String.valueOf(request.getTenantId()));
            throw new RuntimeException(msg, ex);
        }
        catch (Exception ex) {
            String msg = "Error occurred during registerUser" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.REGISTER_USER.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), String.valueOf(request.getTenantId()));
            throw new RuntimeException(msg, ex);
        }
    }

    public org.apache.custos.core.iam.api.UserRepresentation enableUser(UserSearchRequest request) {
        try {
            LOGGER.debug("Request received to enableUser for " + request.getTenantId());
            boolean status = this.keycloakClient.isValidEndUser(String.valueOf(request.getTenantId()), request.getUser().getUsername(), request.getAccessToken());
            if (!status) {
                this.statusUpdater.updateStatus(IAMOperations.ENABLE_USER.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), String.valueOf(request.getTenantId()));
                String msg = "User not valid " + request.getUser().getId();
                LOGGER.error(msg);
                throw new RuntimeException(msg);
            }
            boolean accountEnabled = this.keycloakClient.enableUserAccount(String.valueOf(request.getTenantId()), request.getAccessToken(), request.getUser().getUsername());
            if (accountEnabled) {
                UserRepresentation representation = this.keycloakClient.getUser(String.valueOf(request.getTenantId()), request.getAccessToken(), request.getUser().getUsername());
                org.apache.custos.core.iam.api.UserRepresentation user = this.getUser(representation, request.getClientId());
                this.statusUpdater.updateStatus(IAMOperations.ENABLE_USER.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), String.valueOf(request.getTenantId()));
                return user;
            }
            this.statusUpdater.updateStatus(IAMOperations.ENABLE_USER.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), String.valueOf(request.getTenantId()));
            String msg = "Account enabling failed for user: " + request.getUser().getId() + " in tenant: " + request.getTenantId();
            LOGGER.error(msg);
            throw new RuntimeException(msg);
        }
        catch (Exception ex) {
            String msg = "Error occurred during enableUser" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.ENABLE_USER.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), String.valueOf(request.getTenantId()));
            throw new RuntimeException(msg, ex);
        }
    }

    public org.apache.custos.core.iam.api.UserRepresentation disableUser(UserSearchRequest request) {
        try {
            LOGGER.debug("Request received to disable for " + request.getTenantId());
            boolean status = this.keycloakClient.isValidEndUser(String.valueOf(request.getTenantId()), request.getUser().getUsername(), request.getAccessToken());
            if (!status) {
                this.statusUpdater.updateStatus(IAMOperations.DISABLE_USER.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), String.valueOf(request.getTenantId()));
                String msg = "User not valid, user ID: " + request.getUser().getId();
                LOGGER.error(msg);
                throw new RuntimeException(msg);
            }
            boolean accountDisabled = this.keycloakClient.disableUserAccount(String.valueOf(request.getTenantId()), request.getAccessToken(), request.getUser().getUsername());
            if (accountDisabled) {
                UserRepresentation representation = this.keycloakClient.getUser(String.valueOf(request.getTenantId()), request.getAccessToken(), request.getUser().getUsername());
                org.apache.custos.core.iam.api.UserRepresentation user = this.getUser(representation, request.getClientId());
                this.statusUpdater.updateStatus(IAMOperations.DISABLE_USER.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), String.valueOf(request.getTenantId()));
                return user;
            }
            this.statusUpdater.updateStatus(IAMOperations.DISABLE_USER.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), String.valueOf(request.getTenantId()));
            String msg = "Account disabling failed for user: " + request.getUser().getId();
            LOGGER.error(msg);
            throw new RuntimeException(msg);
        }
        catch (Exception ex) {
            String msg = "Error occurred during disabling user" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.DISABLE_USER.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), String.valueOf(request.getTenantId()));
            throw new RuntimeException(msg, ex);
        }
    }

    public CheckingResponse isUserExist(UserSearchRequest request) {
        try {
            LOGGER.debug("Request received to isUserExist for " + request.getTenantId());
            boolean isUserExist = this.keycloakClient.isUserExist(String.valueOf(request.getTenantId()), request.getAccessToken(), request.getUser().getUsername());
            return CheckingResponse.newBuilder().setIsExist(isUserExist).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred during isUserExist" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public org.apache.custos.core.iam.api.UserRepresentation getUser(UserSearchRequest request) {
        try {
            LOGGER.debug("Request received to getUser for " + request.getTenantId());
            boolean status = this.keycloakClient.isValidEndUser(String.valueOf(request.getTenantId()), request.getUser().getUsername());
            if (!status) {
                String msg = "User " + request.getUser().getUsername() + "not found at " + request.getTenantId();
                throw new EntityNotFoundException(msg);
            }
            UserRepresentation representation = this.keycloakClient.getUser(String.valueOf(request.getTenantId()), request.getUser().getUsername());
            if (representation != null) {
                org.apache.custos.core.iam.api.UserRepresentation user = this.getUser(representation, request.getClientId());
                UserSessionRepresentation sessionRepresentation = this.keycloakClient.getLatestSession(String.valueOf(request.getTenantId()), request.getClientId(), request.getAccessToken(), request.getUser().getUsername());
                if (sessionRepresentation != null) {
                    user = user.toBuilder().setLastLoginAt((double)sessionRepresentation.getLastAccess()).build();
                } else {
                    EventRepresentation eventRepresentation = this.keycloakClient.getLastLoginEvent(String.valueOf(request.getTenantId()), request.getClientId(), request.getUser().getUsername());
                    if (eventRepresentation != null) {
                        user = user.toBuilder().setLastLoginAt((double)eventRepresentation.getTime()).build();
                    }
                }
                return user;
            }
            String msg = "User " + request.getUser().getUsername() + " not found in " + request.getTenantId();
            throw new EntityNotFoundException(msg);
        }
        catch (Exception ex) {
            String msg = "Error occurred during getUser" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("Unauthorized")) {
                throw new RuntimeException("Unauthorized request", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public FindUsersResponse findUsers(FindUsersRequest request) {
        try {
            LOGGER.debug("Request received to getUsers for " + request.getUser().getUsername());
            long initiationTime = System.currentTimeMillis();
            List<UserRepresentation> representation = this.keycloakClient.getUsers(request.getAccessToken(), String.valueOf(request.getTenantId()), request.getOffset(), request.getLimit(), request.getUser().getUsername(), request.getUser().getFirstName(), request.getUser().getLastName(), request.getUser().getEmail(), request.getUser().getId());
            ArrayList users = new ArrayList();
            representation.forEach(r -> {
                boolean status = this.keycloakClient.isValidEndUser(String.valueOf(request.getTenantId()), r.getUsername(), request.getAccessToken());
                if (status) {
                    org.apache.custos.core.iam.api.UserRepresentation user = this.getUser((UserRepresentation)r, request.getClientId());
                    UserSessionRepresentation sessionRepresentation = this.keycloakClient.getLatestSession(String.valueOf(request.getTenantId()), request.getClientId(), null, r.getUsername());
                    if (sessionRepresentation != null) {
                        user = user.toBuilder().setLastLoginAt((double)sessionRepresentation.getLastAccess()).build();
                    } else {
                        EventRepresentation eventRepresentation = this.keycloakClient.getLastLoginEvent(String.valueOf(request.getTenantId()), request.getClientId(), r.getUsername());
                        if (eventRepresentation != null) {
                            user = user.toBuilder().setLastLoginAt((double)eventRepresentation.getTime()).build();
                        }
                    }
                    users.add(user);
                }
            });
            long endTime = System.currentTimeMillis();
            long total = endTime - initiationTime;
            LOGGER.info("request received: " + initiationTime + " request end time" + endTime + " difference " + total);
            return FindUsersResponse.newBuilder().addAllUsers(users).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred during getUsers" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("Unauthorized")) {
                throw new RuntimeException("Unauthorized request", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus resetPassword(ResetUserPassword request) {
        String userId = request.getUsername() + "@" + request.getTenantId();
        try {
            LOGGER.debug("Request received to resetPassword for " + request.getUsername());
            boolean status = this.keycloakClient.isValidEndUser(String.valueOf(request.getTenantId()), request.getUsername(), request.getAccessToken());
            if (!status) {
                this.statusUpdater.updateStatus(IAMOperations.RESET_PASSWORD.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), userId);
                String msg = "User not valid, user name: " + request.getUsername();
                LOGGER.error(msg);
                throw new RuntimeException(msg);
            }
            boolean isChanged = this.keycloakClient.resetUserPassword(request.getAccessToken(), String.valueOf(request.getTenantId()), request.getUsername(), request.getPassword());
            this.statusUpdater.updateStatus(IAMOperations.RESET_PASSWORD.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), userId);
            return OperationStatus.newBuilder().setStatus(isChanged).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred during resetPassword" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.RESET_PASSWORD.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), userId);
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus deleteExternalIDPLinksOfUsers(DeleteExternalIDPsRequest request) {
        try {
            long tenantId = request.getTenantId();
            boolean status = request.getUserIdList().isEmpty() ? this.keycloakClient.deleteExternalIDPLinks(String.valueOf(tenantId)) : this.keycloakClient.deleteExternalIDPLinks(String.valueOf(tenantId), (List<String>)request.getUserIdList());
            return OperationStatus.newBuilder().setStatus(status).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while deletingExternalIDPLinksOfUsers" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public GetExternalIDPsResponse getExternalIDPLinksOfUsers(GetExternalIDPsRequest request) {
        try {
            long tenantId = request.getTenantId();
            List<FederatedIdentityRepresentation> identityRepresentations = this.keycloakClient.getExternalIDPLinks(String.valueOf(tenantId), request.getUserId());
            GetExternalIDPsResponse.Builder response = GetExternalIDPsResponse.newBuilder();
            identityRepresentations.forEach(rep -> response.addIdpLinks(ExternalIDPLink.newBuilder().setProviderAlias(rep.getIdentityProvider()).setProviderUsername(rep.getUserName()).setProviderUserId(rep.getUserId())));
            return response.build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while getExternalIDPLinksOfUsers" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus addExternalIDPLinksOfUsers(AddExternalIDPLinksRequest request) {
        try {
            long tenantId = request.getTenantId();
            List externalIDPLinkList = request.getIdpLinksList();
            ArrayList<FederatedIdentityRepresentation> federatedIdentityRepresentations = new ArrayList<FederatedIdentityRepresentation>();
            externalIDPLinkList.forEach(link -> {
                FederatedIdentityRepresentation representation = new FederatedIdentityRepresentation();
                representation.setUserId(link.getProviderUserId());
                representation.setUserName(link.getProviderUsername());
                representation.setIdentityProvider(link.getProviderAlias());
                federatedIdentityRepresentations.add(representation);
            });
            this.keycloakClient.addExternalIDPLinks(String.valueOf(tenantId), federatedIdentityRepresentations);
            return OperationStatus.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred while getExternalIDPLinksOfUsers" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus updateUserProfile(UpdateUserProfileRequest request) {
        String userId = request.getUser().getUsername() + "@" + request.getTenantId();
        try {
            LOGGER.debug("Request received to updateUserProfile for " + request.getUser().getUsername());
            boolean status = this.keycloakClient.isValidEndUser(String.valueOf(request.getTenantId()), request.getUser().getUsername(), request.getAccessToken());
            if (!status) {
                this.statusUpdater.updateStatus(IAMOperations.UPDATE_USER_PROFILE.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), userId);
                String msg = "User not valid, user Id: " + request.getUser().getId();
                LOGGER.error(msg);
                throw new RuntimeException(msg);
            }
            this.keycloakClient.updateUserRepresentation(request.getAccessToken(), String.valueOf(request.getTenantId()), request.getUser().getUsername(), request.getUser().getFirstName(), request.getUser().getLastName(), request.getUser().getEmail());
            this.statusUpdater.updateStatus(IAMOperations.UPDATE_USER_PROFILE.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), userId);
            return OperationStatus.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred during updateUserProfile" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.UPDATE_USER_PROFILE.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), userId);
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus deleteUser(UserSearchRequest request) {
        try {
            LOGGER.debug("Request received to deleteUser for " + request.getTenantId());
            boolean status = this.keycloakClient.isValidEndUser(String.valueOf(request.getTenantId()), request.getUser().getUsername(), request.getAccessToken());
            if (!status) {
                this.statusUpdater.updateStatus(IAMOperations.DELETE_USER.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
                String msg = "User not valid, user Id: " + request.getUser().getId();
                LOGGER.error(msg);
                throw new RuntimeException(msg);
            }
            boolean isUpdated = this.keycloakClient.deleteUser(request.getAccessToken(), String.valueOf(request.getTenantId()), request.getUser().getUsername());
            this.statusUpdater.updateStatus(IAMOperations.DELETE_USER.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            return OperationStatus.newBuilder().setStatus(isUpdated).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred during deleteUser" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.DELETE_USER.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            if (ex.getMessage().contains("Unauthorized")) {
                throw new RuntimeException("Unauthorized request", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus deleteRolesFromUser(DeleteUserRolesRequest request) {
        try {
            LOGGER.debug("Request received to deleteRoleFromUser for " + request.getTenantId());
            boolean status = this.keycloakClient.isValidEndUser(String.valueOf(request.getTenantId()), request.getUsername());
            if (!status) {
                this.statusUpdater.updateStatus(IAMOperations.DELETE_ROLE_FROM_USER.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
                String msg = "User not valid ";
                LOGGER.error(msg);
                throw new RuntimeException(msg);
            }
            if (!request.getRolesList().isEmpty()) {
                this.keycloakClient.removeRoleFromUser(request.getAccessToken(), String.valueOf(request.getTenantId()), request.getUsername(), (List<String>)request.getRolesList(), request.getClientId(), false);
            }
            if (!request.getClientRolesList().isEmpty()) {
                this.keycloakClient.removeRoleFromUser(request.getAccessToken(), String.valueOf(request.getTenantId()), request.getUsername(), (List<String>)request.getClientRolesList(), request.getClientId(), true);
            }
            this.statusUpdater.updateStatus(IAMOperations.DELETE_ROLE_FROM_USER.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            return OperationStatus.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            String msg = "Error occurred during deleteRoleFromUser" + String.valueOf(ex);
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.DELETE_ROLE_FROM_USER.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            if (ex.getMessage().contains("Unauthorized")) {
                throw new RuntimeException("Unauthorized request", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public GetOperationsMetadataResponse getOperationMetadata(GetOperationsMetadataRequest request) {
        try {
            LOGGER.debug("Calling getOperationMetadata API for traceId " + request.getTraceId());
            List<Object> metadata = new ArrayList();
            List entities = this.statusUpdater.getOperationStatus(request.getTraceId());
            if (entities != null && !entities.isEmpty()) {
                metadata = entities.stream().map(this::convertFromEntity).collect(Collectors.toList());
            }
            return GetOperationsMetadataResponse.newBuilder().addAllMetadata(metadata).build();
        }
        catch (Exception ex) {
            String msg = " operation failed for " + request.getTraceId();
            LOGGER.error(msg);
            throw new RuntimeException(msg);
        }
    }

    public FederateIDPResponse configureFederatedIDP(ConfigureFederateIDPRequest request) {
        try {
            LOGGER.debug("Request received to configureFederatedIDP for " + request.getTenantId());
            this.keycloakClient.configureOIDCFederatedIDP(String.valueOf(request.getTenantId()), "CILogon", request.getScope(), new KeycloakClientSecret(request.getClientID(), request.getClientSec()), null);
            this.statusUpdater.updateStatus(IAMOperations.CONFIGURE_IDP.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getRequesterEmail());
            return FederateIDPResponse.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            String msg = " Configure Federated IDP failed for " + request.getTenantId();
            LOGGER.error(msg);
            throw new RuntimeException(msg, ex);
        }
    }

    public RegisterUsersResponse registerAndEnableUsers(RegisterUsersRequest request) {
        try {
            LOGGER.debug("Request received to registerMultipleUsers for " + request.getTenantId());
            List userRepresentations = request.getUsersList();
            ArrayList<org.apache.custos.core.iam.api.UserRepresentation> failedList = new ArrayList<org.apache.custos.core.iam.api.UserRepresentation>();
            for (org.apache.custos.core.iam.api.UserRepresentation userRepresentation : userRepresentations) {
                try {
                    this.keycloakClient.createUser(String.valueOf(request.getTenantId()), userRepresentation.getUsername(), userRepresentation.getPassword(), userRepresentation.getFirstName(), userRepresentation.getLastName(), userRepresentation.getEmail(), userRepresentation.getTemporaryPassword(), request.getAccessToken());
                    this.keycloakClient.enableUserAccount(String.valueOf(request.getTenantId()), request.getAccessToken(), userRepresentation.getUsername().toLowerCase());
                    ArrayList<String> userList = new ArrayList<String>();
                    userList.add(userRepresentation.getUsername());
                    if (!userRepresentation.getRealmRolesList().isEmpty()) {
                        this.keycloakClient.addRolesToUsers(request.getAccessToken(), String.valueOf(request.getTenantId()), userList, (List<String>)userRepresentation.getRealmRolesList(), request.getClientId(), false);
                    }
                    if (!userRepresentation.getClientRolesList().isEmpty()) {
                        this.keycloakClient.addRolesToUsers(request.getAccessToken(), String.valueOf(request.getTenantId()), userList, (List<String>)userRepresentation.getClientRolesList(), request.getClientId(), true);
                    }
                    if (userRepresentation.getAttributesList().isEmpty()) continue;
                    HashMap<String, List<String>> map = new HashMap<String, List<String>>();
                    for (UserAttribute attribute : userRepresentation.getAttributesList()) {
                        if (attribute.getKey().equals("custos-realm-agent")) continue;
                        map.put(attribute.getKey(), (List<String>)attribute.getValuesList());
                    }
                    this.keycloakClient.addUserAttributes(String.valueOf(request.getTenantId()), request.getAccessToken(), map, userList);
                }
                catch (UnauthorizedException ex) {
                    String msg = " Error occurred while adding user " + userRepresentation.getUsername() + " to realm" + request.getTenantId();
                    LOGGER.error(msg);
                    throw new RuntimeException(msg, ex);
                }
                catch (Exception ex) {
                    if (ex.getMessage().contains("Unauthorized")) {
                        throw new RuntimeException("Unauthorized request", ex);
                    }
                    LOGGER.error(" Error occurred while adding user " + userRepresentation.getUsername() + " to realm" + request.getTenantId());
                    failedList.add(userRepresentation);
                }
            }
            if (failedList.isEmpty()) {
                this.statusUpdater.updateStatus(IAMOperations.REGISTER_ENABLE_USERS.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            }
            return RegisterUsersResponse.newBuilder().setAllUseresRegistered(failedList.isEmpty()).addAllFailedUsers(failedList).build();
        }
        catch (Exception ex) {
            this.statusUpdater.updateStatus(IAMOperations.REGISTER_ENABLE_USERS.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), String.valueOf(request.getTenantId()));
            String msg = " Register  multiple users  failed for " + request.getTenantId();
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus addRolesToUsers(AddUserRolesRequest request) {
        try {
            LOGGER.debug("Request received to addRolesToUsers for " + request.getTenantId());
            ArrayList<String> validUserNames = new ArrayList<String>();
            for (String username : request.getUsernamesList()) {
                if (!this.keycloakClient.isValidEndUser(String.valueOf(request.getTenantId()), username)) continue;
                validUserNames.add(username);
            }
            this.keycloakClient.addRolesToUsers(request.getAccessToken(), String.valueOf(request.getTenantId()), validUserNames, (List<String>)request.getRolesList(), request.getClientId(), request.getClientLevel());
            this.statusUpdater.updateStatus(IAMOperations.ADD_ROLES_TO_USERS.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            return OperationStatus.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            this.statusUpdater.updateStatus(IAMOperations.ADD_ROLES_TO_USERS.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            String msg = "Add multiple users failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg);
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public AllRoles addRolesToTenant(AddRolesRequest request) {
        try {
            LOGGER.debug("Request received to add roles to tenant for " + request.getTenantId());
            List rolesRepresentations = request.getRolesList();
            ArrayList<org.keycloak.representations.idm.RoleRepresentation> keycloakRolesList = new ArrayList<org.keycloak.representations.idm.RoleRepresentation>();
            for (RoleRepresentation roleRepresentation : rolesRepresentations) {
                org.keycloak.representations.idm.RoleRepresentation role2 = new org.keycloak.representations.idm.RoleRepresentation();
                role2.setName(roleRepresentation.getName());
                role2.setDescription(roleRepresentation.getDescription());
                role2.setComposite(roleRepresentation.getComposite());
                keycloakRolesList.add(role2);
            }
            this.keycloakClient.addRoles(keycloakRolesList, String.valueOf(request.getTenantId()), request.getClientId(), request.getClientLevel());
            this.statusUpdater.updateStatus(IAMOperations.ADD_ROLES_TO_TENANT.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), String.valueOf(request.getTenantId()));
            List<org.keycloak.representations.idm.RoleRepresentation> allKeycloakRoles = this.keycloakClient.getAllRoles(String.valueOf(request.getTenantId()), request.getClientLevel() ? request.getClientId() : null);
            AllRoles.Builder builder = AllRoles.newBuilder();
            if (allKeycloakRoles != null && !allKeycloakRoles.isEmpty()) {
                List roleRepresentations = allKeycloakRoles.stream().map(role -> RoleRepresentation.newBuilder().setName(role.getName()).setComposite(role.isComposite()).setId(role.getId()).setDescription(Optional.ofNullable(role.getDescription()).orElse("")).build()).collect(Collectors.toList());
                builder.addAllRoles(roleRepresentations);
                builder.setScope(request.getClientLevel() ? "client_level" : "realm_level");
            }
            return builder.build();
        }
        catch (Exception ex) {
            this.statusUpdater.updateStatus(IAMOperations.ADD_ROLES_TO_TENANT.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), String.valueOf(request.getTenantId()));
            String msg = " Add roles   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus deleteRole(DeleteRoleRequest request) {
        try {
            LOGGER.debug("Request received to add roles to tenant for " + request.getTenantId());
            this.keycloakClient.deleteRole(request.getRole().getId(), String.valueOf(request.getTenantId()), request.getClientId(), request.getClientLevel());
            return OperationStatus.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            String msg = "Deleting role" + request.getRole().getName() + "  failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public AllRoles getRolesOfTenant(GetRolesRequest request) {
        try {
            LOGGER.debug("Request received to add roles to tenant for " + request.getTenantId());
            List<org.keycloak.representations.idm.RoleRepresentation> allKeycloakRoles = this.keycloakClient.getAllRoles(String.valueOf(request.getTenantId()), request.getClientLevel() ? request.getClientId() : null);
            AllRoles.Builder builder = AllRoles.newBuilder();
            if (allKeycloakRoles != null && !allKeycloakRoles.isEmpty()) {
                ArrayList<RoleRepresentation> roleRepresentations = new ArrayList<RoleRepresentation>();
                for (org.keycloak.representations.idm.RoleRepresentation role : allKeycloakRoles) {
                    RoleRepresentation roleRepresentation = RoleRepresentation.newBuilder().setName(role.getName()).setComposite(role.isComposite()).setId(role.getId()).build();
                    if (role.getDescription() != null) {
                        roleRepresentation = roleRepresentation.toBuilder().setDescription(role.getDescription()).build();
                    }
                    roleRepresentations.add(roleRepresentation);
                }
                builder.addAllRoles(roleRepresentations);
                if (request.getClientLevel()) {
                    builder.setScope("client_level");
                } else {
                    builder.setScope("realm_level");
                }
            }
            return builder.build();
        }
        catch (Exception ex) {
            String msg = "Get roles failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus addProtocolMapper(AddProtocolMapperRequest request) {
        try {
            String mapperModel;
            LOGGER.debug("Request received to add protocol mapper " + request.getTenantId());
            HashMap<String, String> configMap = new HashMap<String, String>();
            if (request.getMapperType().equals((Object)MapperTypes.USER_ATTRIBUTE)) {
                mapperModel = "oidc-usermodel-attribute-mapper";
                configMap.put("user.attribute", request.getAttributeName());
            } else if (request.getMapperType().equals((Object)MapperTypes.USER_REALM_ROLE)) {
                mapperModel = "oidc-usermodel-realm-role-mapper";
            } else if (request.getMapperType().equals((Object)MapperTypes.USER_CLIENT_ROLE)) {
                mapperModel = "oidc-usermodel-client-role-mapper";
                configMap.put("usermodel.clientRoleMapping.clientId", request.getClientId());
            } else {
                throw new RuntimeException("Mapping type not supported");
            }
            ProtocolMapperRepresentation protocolMapperRepresentation = new ProtocolMapperRepresentation();
            protocolMapperRepresentation.setName(request.getName());
            protocolMapperRepresentation.setProtocol("openid-connect");
            protocolMapperRepresentation.setProtocolMapper(mapperModel);
            configMap.put("user.session.note", request.getClaimName());
            configMap.put("id.token.claim", String.valueOf(request.getAddToIdToken()));
            configMap.put("access.token.claim", String.valueOf(request.getAddToAccessToken()));
            configMap.put("claim.name", request.getClaimName());
            switch (request.getClaimType()) {
                case JSON: {
                    configMap.put("jsonType.label", "JSON");
                    break;
                }
                case LONG: {
                    configMap.put("jsonType.label", "long");
                    break;
                }
                case STRING: {
                    configMap.put("jsonType.label", "String");
                    break;
                }
                case BOOLEAN: {
                    configMap.put("jsonType.label", "boolean");
                    break;
                }
                case INTEGER: {
                    configMap.put("jsonType.label", "int");
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown claim type");
                }
            }
            configMap.put("aggregate.attrs", String.valueOf(request.getAggregateAttributeValues()));
            configMap.put("userinfo.token.claim", String.valueOf(request.getAddToUserInfo()));
            configMap.put("multivalued", String.valueOf(request.getMultiValued()));
            protocolMapperRepresentation.setConfig(configMap);
            this.keycloakClient.addProtocolMapper(protocolMapperRepresentation, String.valueOf(request.getTenantId()), request.getClientId());
            this.statusUpdater.updateStatus(IAMOperations.ADD_PROTOCOL_MAPPER.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), String.valueOf(request.getTenantId()));
            return OperationStatus.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            this.statusUpdater.updateStatus(IAMOperations.ADD_PROTOCOL_MAPPER.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), String.valueOf(request.getTenantId()));
            String msg = " Add protocol mapper   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus addUserAttributes(AddUserAttributesRequest request) {
        try {
            LOGGER.debug("Request received to addUserAttributes " + request.getTenantId());
            List attributes = request.getAttributesList();
            ArrayList<String> validUserNames = new ArrayList<String>();
            for (String username : request.getUsersList()) {
                if (!this.keycloakClient.isValidEndUser(String.valueOf(request.getTenantId()), username, request.getAccessToken())) continue;
                validUserNames.add(username);
            }
            HashMap<String, List<String>> attributeMap = new HashMap<String, List<String>>();
            for (UserAttribute attribute : attributes) {
                if (attribute.getKey().equals("custos-realm-agent")) {
                    String msg = "custos-realm-agent cannot be used as a valid attribute";
                    LOGGER.error(msg);
                    throw new RuntimeException(msg);
                }
                attributeMap.put(attribute.getKey(), (List<String>)attribute.getValuesList());
            }
            this.keycloakClient.addUserAttributes(String.valueOf(request.getTenantId()), request.getAccessToken(), attributeMap, validUserNames);
            this.statusUpdater.updateStatus(IAMOperations.ADD_USER_ATTRIBUTE.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            return OperationStatus.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            this.statusUpdater.updateStatus(IAMOperations.ADD_USER_ATTRIBUTE.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            String msg = " Add attributes   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus deleteUserAttributes(DeleteUserAttributeRequest request) {
        try {
            LOGGER.debug("Request received to delete user attributes " + request.getTenantId());
            ArrayList<String> validUserNames = new ArrayList<String>();
            for (String username : request.getUsersList()) {
                if (!this.keycloakClient.isValidEndUser(String.valueOf(request.getTenantId()), username, request.getAccessToken())) continue;
                validUserNames.add(username);
            }
            List attributes = request.getAttributesList();
            HashMap<String, List<String>> attributeMap = new HashMap<String, List<String>>();
            for (UserAttribute attribute : attributes) {
                attributeMap.put(attribute.getKey(), (List<String>)attribute.getValuesList());
            }
            this.keycloakClient.deleteUserAttributes(String.valueOf(request.getTenantId()), request.getAccessToken(), attributeMap, validUserNames);
            this.statusUpdater.updateStatus(IAMOperations.DELETE_USER_ATTRIBUTES.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            return OperationStatus.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            this.statusUpdater.updateStatus(IAMOperations.DELETE_USER_ATTRIBUTES.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            String msg = " Add attributes   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus configureEventPersistence(EventPersistenceRequest request) {
        try {
            LOGGER.debug("Request received to configureEventPersistence " + request.getTenantId());
            this.keycloakClient.configureEventPersistence(String.valueOf(request.getTenantId()), request.getEvent(), request.getPersistenceTime(), request.getEnable(), request.getAdminEvent());
            return OperationStatus.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            this.statusUpdater.updateStatus(IAMOperations.CONFIGURE_PERSISTANCE.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            String msg = " Configure Event Persistence   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public GroupsResponse createGroups(GroupsRequest request) {
        try {
            LOGGER.debug("Request received to createGroup " + request.getTenantId());
            long tenantId = request.getTenantId();
            String accessToken = request.getAccessToken();
            List<org.keycloak.representations.idm.GroupRepresentation> groupRepresentations = this.transformToKeycloakGroups(request.getClientId(), request.getGroupsList());
            List<org.keycloak.representations.idm.GroupRepresentation> representations = this.keycloakClient.createGroups(String.valueOf(tenantId), request.getClientId(), request.getClientSec(), groupRepresentations);
            List<GroupRepresentation> groups = this.transformKeycloakGroupsToGroups(request.getClientId(), representations);
            this.statusUpdater.updateStatus(IAMOperations.CREATE_GROUP.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            return GroupsResponse.newBuilder().addAllGroups(groups).build();
        }
        catch (Exception ex) {
            this.statusUpdater.updateStatus(IAMOperations.CREATE_GROUP.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            String msg = " Create Group   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public GroupRepresentation updateGroup(GroupRequest request) {
        try {
            LOGGER.debug("Request received to updateGroup " + request.getTenantId());
            long tenantId = request.getTenantId();
            ArrayList<GroupRepresentation> representations = new ArrayList<GroupRepresentation>();
            representations.add(request.getGroup());
            List<org.keycloak.representations.idm.GroupRepresentation> groupRepresentations = this.transformToKeycloakGroups(request.getClientId(), representations);
            org.keycloak.representations.idm.GroupRepresentation groupRepresentation = this.keycloakClient.updateGroup(String.valueOf(tenantId), request.getClientId(), request.getClientSec(), groupRepresentations.get(0));
            this.statusUpdater.updateStatus(IAMOperations.UPDATE_GROUP.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            return this.transformKeycloakGroupToGroup(request.getClientId(), groupRepresentation, null);
        }
        catch (Exception ex) {
            this.statusUpdater.updateStatus(IAMOperations.UPDATE_GROUP.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            String msg = " Update Group   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus deleteGroup(GroupRequest request) {
        try {
            LOGGER.debug("Request received to deleteGroup " + request.getTenantId());
            long tenantId = request.getTenantId();
            String accessToken = request.getAccessToken();
            this.keycloakClient.deleteGroup(String.valueOf(tenantId), request.getClientId(), request.getClientSec(), request.getGroup().getId());
            this.statusUpdater.updateStatus(IAMOperations.DELETE_GROUP.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            return OperationStatus.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            this.statusUpdater.updateStatus(IAMOperations.DELETE_GROUP.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            String msg = " Delete Group   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public GroupRepresentation findGroup(GroupRequest request) {
        try {
            LOGGER.debug("Request received to findGroup " + request.getTenantId());
            long tenantId = request.getTenantId();
            String accessToken = request.getAccessToken();
            org.keycloak.representations.idm.GroupRepresentation groupRepresentation = this.keycloakClient.findGroup(String.valueOf(tenantId), accessToken, request.getGroup().getId(), request.getGroup().getName());
            return groupRepresentation != null ? this.transformKeycloakGroupToGroup(request.getClientId(), groupRepresentation, null) : null;
        }
        catch (Exception ex) {
            String msg = " find Group   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public GroupsResponse getAllGroups(GroupRequest request) {
        try {
            LOGGER.debug("Request received to getAllGroups " + request.getTenantId());
            long tenantId = request.getTenantId();
            String accessToken = request.getAccessToken();
            List<org.keycloak.representations.idm.GroupRepresentation> groupRepresentation = this.keycloakClient.getAllGroups(String.valueOf(tenantId), accessToken);
            List<GroupRepresentation> groups = this.transformKeycloakGroupsToGroups(request.getClientId(), groupRepresentation);
            return !groups.isEmpty() ? GroupsResponse.newBuilder().addAllGroups(groups).build() : GroupsResponse.newBuilder().build();
        }
        catch (Exception ex) {
            String msg = " Get Groups   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus addUserToGroup(UserGroupMappingRequest request) {
        try {
            LOGGER.debug("Request received to getAllGroups " + request.getTenantId());
            long tenantId = request.getTenantId();
            String accessToken = request.getAccessToken();
            boolean status = this.keycloakClient.addUserToGroup(String.valueOf(tenantId), request.getUsername(), request.getGroupId(), accessToken);
            this.statusUpdater.updateStatus(IAMOperations.ADD_USER_TO_GROUP.name(), status ? org.apache.custos.core.model.commons.OperationStatus.SUCCESS : org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            return OperationStatus.newBuilder().setStatus(status).build();
        }
        catch (Exception ex) {
            this.statusUpdater.updateStatus(IAMOperations.ADD_USER_TO_GROUP.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            String msg = "  Groups   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus removeUserFromGroup(UserGroupMappingRequest request) {
        try {
            LOGGER.debug("Request received to getAllGroups " + request.getTenantId());
            long tenantId = request.getTenantId();
            String accessToken = request.getAccessToken();
            boolean status = this.keycloakClient.removeUserFromGroup(String.valueOf(tenantId), request.getUsername(), request.getGroupId(), accessToken);
            this.statusUpdater.updateStatus(IAMOperations.REMOVE_USER_FROM_GROUP.name(), status ? org.apache.custos.core.model.commons.OperationStatus.SUCCESS : org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            return OperationStatus.newBuilder().setStatus(status).build();
        }
        catch (Exception ex) {
            this.statusUpdater.updateStatus(IAMOperations.REMOVE_USER_FROM_GROUP.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            String msg = "  Remove user from Group   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public SetUpTenantResponse createAgentClient(AgentClientMetadata request) {
        try {
            LOGGER.debug("Request received to configureAgentClient " + request.getTenantId());
            KeycloakClientSecret secret = this.keycloakClient.configureClient(String.valueOf(request.getTenantId()), request.getClientName(), request.getTenantURL(), (List<String>)request.getRedirectURIsList());
            if (secret != null) {
                this.statusUpdater.updateStatus(IAMOperations.CONFIGURE_AGENT_CLIENT.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
                return SetUpTenantResponse.newBuilder().setClientId(secret.getClientId()).setClientSecret(secret.getClientSecret()).build();
            }
            String msg = " Configure agent client  failed for " + request.getTenantId();
            LOGGER.error(msg);
            throw new RuntimeException(msg);
        }
        catch (Exception ex) {
            this.statusUpdater.updateStatus(IAMOperations.CONFIGURE_AGENT_CLIENT.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            String msg = " Configure agent client  failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus configureAgentClient(AgentClientMetadata request) {
        try {
            LOGGER.debug("Request received to configureAgentClient " + request.getTenantId());
            boolean status = this.keycloakClient.configureAgentClient(String.valueOf(request.getTenantId()), request.getClientName(), request.getAccessTokenLifeTime());
            return OperationStatus.newBuilder().setStatus(status).build();
        }
        catch (Exception ex) {
            String msg = " Register and configureAgentClient user   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.REGISTER_AGENT.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public RegisterUserResponse registerAndEnableAgent(RegisterUserRequest request) {
        try {
            LOGGER.debug("Request received to registerAndEnableAgent " + request.getTenantId());
            boolean status = this.keycloakClient.createUser(String.valueOf(request.getTenantId()), request.getUser().getId(), request.getUser().getPassword(), null, null, null, false, request.getAccessToken());
            if (status) {
                ArrayList<String> userList = new ArrayList<String>();
                userList.add(request.getUser().getId());
                if (!request.getUser().getRealmRolesList().isEmpty()) {
                    this.keycloakClient.addRolesToUsers(request.getAccessToken(), String.valueOf(request.getTenantId()), userList, (List<String>)request.getUser().getRealmRolesList(), request.getClientId(), false);
                }
                if (!request.getUser().getClientRolesList().isEmpty()) {
                    this.keycloakClient.addRolesToUsers(request.getAccessToken(), String.valueOf(request.getTenantId()), userList, (List<String>)request.getUser().getClientRolesList(), request.getClientId(), true);
                }
                if (!request.getUser().getAttributesList().isEmpty()) {
                    HashMap<String, List<String>> map = new HashMap<String, List<String>>();
                    for (UserAttribute attribute : request.getUser().getAttributesList()) {
                        map.put(attribute.getKey(), (List<String>)attribute.getValuesList());
                    }
                    this.keycloakClient.addUserAttributes(String.valueOf(request.getTenantId()), request.getAccessToken(), map, userList);
                }
                status = this.keycloakClient.enableUserAccount(String.valueOf(request.getTenantId()), request.getAccessToken(), request.getUser().getId());
                this.statusUpdater.updateStatus(IAMOperations.REGISTER_AGENT.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
                return RegisterUserResponse.newBuilder().setIsRegistered(status).build();
            }
            String msg = " Register and enable user   failed for  user " + request.getUser().getId() + "of tenant" + request.getTenantId();
            LOGGER.error(msg);
            throw new RuntimeException(msg);
        }
        catch (Exception ex) {
            String msg = " Register and enable user   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.REGISTER_AGENT.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus deleteAgent(UserSearchRequest request) {
        try {
            LOGGER.debug("Request received to deleteAgent " + request.getTenantId());
            boolean status = this.keycloakClient.deleteUser(request.getAccessToken(), String.valueOf(request.getTenantId()), request.getUser().getId());
            this.statusUpdater.updateStatus(IAMOperations.DELETE_AGENT.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            return OperationStatus.newBuilder().setStatus(status).build();
        }
        catch (Exception ex) {
            String msg = " Delete agent  failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.DELETE_AGENT.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus disableAgent(UserSearchRequest request) {
        try {
            LOGGER.debug("Request received to disableAgent " + request.getTenantId());
            boolean status = this.keycloakClient.disableUserAccount(String.valueOf(request.getTenantId()), request.getAccessToken(), request.getUser().getId());
            this.statusUpdater.updateStatus(IAMOperations.DISABLE_AGENT.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            return OperationStatus.newBuilder().setStatus(status).build();
        }
        catch (Exception ex) {
            String msg = " Disable agent   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.DELETE_USER.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus isAgentNameAvailable(UserSearchRequest request) {
        try {
            LOGGER.debug("Request received to isAgentNameAvailable " + request.getTenantId());
            boolean status = this.keycloakClient.isUsernameAvailable(String.valueOf(request.getTenantId()), request.getUser().getId(), request.getAccessToken());
            return OperationStatus.newBuilder().setStatus(status).build();
        }
        catch (Exception ex) {
            String msg = " Is agent name available   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus addAgentAttributes(AddUserAttributesRequest request) {
        try {
            LOGGER.debug("Request received to addAgentAttributes " + request.getTenantId());
            List attributes = request.getAttributesList();
            HashMap<String, List<String>> attributeMap = new HashMap<String, List<String>>();
            for (UserAttribute attribute : attributes) {
                attributeMap.put(attribute.getKey(), (List<String>)attribute.getValuesList());
            }
            boolean status = this.keycloakClient.addUserAttributes(String.valueOf(request.getTenantId()), request.getAccessToken(), attributeMap, (List<String>)request.getAgentsList());
            this.statusUpdater.updateStatus(IAMOperations.ADD_AGENT_ATTRIBUTES.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            return OperationStatus.newBuilder().setStatus(status).build();
        }
        catch (Exception ex) {
            String msg = " Add agent attributes   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.ADD_AGENT_ATTRIBUTES.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus deleteAgentAttributes(DeleteUserAttributeRequest request) {
        try {
            LOGGER.debug("Request received to deleteAgentAttributes " + request.getTenantId());
            List attributes = request.getAttributesList();
            HashMap<String, List<String>> attributeMap = new HashMap<String, List<String>>();
            for (UserAttribute attribute : attributes) {
                attributeMap.put(attribute.getKey(), (List<String>)attribute.getValuesList());
            }
            boolean status = this.keycloakClient.deleteUserAttributes(String.valueOf(request.getTenantId()), request.getAccessToken(), attributeMap, (List<String>)request.getAgentsList());
            this.statusUpdater.updateStatus(IAMOperations.DELETE_AGENT_ATTRIBUTES.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            return OperationStatus.newBuilder().setStatus(status).build();
        }
        catch (Exception ex) {
            String msg = " Delete agent attributes   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.DELETE_AGENT_ATTRIBUTES.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus addRolesToAgent(AddUserRolesRequest request) {
        try {
            LOGGER.debug("Request received to addRolesToAgent " + request.getTenantId());
            boolean status = this.keycloakClient.addRolesToUsers(request.getAccessToken(), String.valueOf(request.getTenantId()), (List<String>)request.getAgentsList(), (List<String>)request.getRolesList(), request.getClientId(), request.getClientLevel());
            this.statusUpdater.updateStatus(IAMOperations.ADD_ROLE_TO_AGENT.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            return OperationStatus.newBuilder().setStatus(status).build();
        }
        catch (Exception ex) {
            String msg = " Add roles to agent   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.ADD_ROLE_TO_AGENT.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus deleteAgentRoles(DeleteUserRolesRequest request) {
        try {
            LOGGER.debug("Request received to deleteRolesFromAgent " + request.getTenantId());
            if (!request.getRolesList().isEmpty()) {
                this.keycloakClient.removeRoleFromUser(request.getAccessToken(), String.valueOf(request.getTenantId()), request.getId(), (List<String>)request.getRolesList(), request.getClientId(), false);
            }
            if (!request.getClientRolesList().isEmpty()) {
                this.keycloakClient.removeRoleFromUser(request.getAccessToken(), String.valueOf(request.getTenantId()), request.getId(), (List<String>)request.getClientRolesList(), request.getClientId(), true);
            }
            this.statusUpdater.updateStatus(IAMOperations.DELETE_ROLE_FROM_AGENT.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            return OperationStatus.newBuilder().setStatus(true).build();
        }
        catch (Exception ex) {
            String msg = " Delete roles from agent   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.DELETE_ROLE_FROM_AGENT.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public Agent getAgent(UserSearchRequest request) {
        try {
            LOGGER.debug("Request received to getAgent " + request.getTenantId());
            UserRepresentation representation = this.keycloakClient.getUser(String.valueOf(request.getTenantId()), request.getAccessToken(), request.getUser().getId());
            if (representation != null) {
                if (representation.getAttributes() == null || representation.getAttributes().isEmpty() || ((List)representation.getAttributes().get("custos-realm-agent")).get(0) == null || !((String)((List)representation.getAttributes().get("custos-realm-agent")).get(0)).equals("true")) {
                    throw new EntityNotFoundException("Agent not found for User search request, user Id: " + request.getUser().getId());
                }
                return this.getAgent(representation);
            }
            throw new EntityNotFoundException("Agent not found for User search request, user Id: " + request.getUser().getId());
        }
        catch (Exception ex) {
            String msg = " Delete roles from agent   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.DELETE_ROLE_FROM_AGENT.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus enableAgent(UserSearchRequest request) {
        try {
            LOGGER.debug("Request received to enableAgent " + request.getTenantId());
            boolean status = this.keycloakClient.enableUserAccount(String.valueOf(request.getTenantId()), request.getAccessToken(), request.getUser().getId());
            this.statusUpdater.updateStatus(IAMOperations.ENABLE_AGENT.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
            return OperationStatus.newBuilder().setStatus(status).build();
        }
        catch (Exception ex) {
            String msg = " Enable agent   failed for " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.ENABLE_AGENT.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus grantAdminPrivilege(UserSearchRequest request) {
        try {
            LOGGER.debug("Request received to grantAdminPrivilege " + request.getTenantId());
            boolean validationStatus = this.keycloakClient.isValidEndUser(String.valueOf(request.getTenantId()), request.getUser().getUsername(), request.getAccessToken());
            if (validationStatus) {
                boolean status = this.keycloakClient.grantAdminPrivilege(String.valueOf(request.getTenantId()), request.getUser().getUsername());
                this.statusUpdater.updateStatus(IAMOperations.GRANT_ADMIN_PRIVILEGE.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
                return OperationStatus.newBuilder().setStatus(status).build();
            }
            String msg = " Not a valid user: " + request.getUser().getId();
            LOGGER.error(msg);
            throw new EntityNotFoundException(msg);
        }
        catch (Exception ex) {
            String msg = " Grant admin privilege " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.GRANT_ADMIN_PRIVILEGE.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public OperationStatus removeAdminPrivilege(UserSearchRequest request) {
        try {
            LOGGER.debug("Request received to removeAdminPrivilege " + request.getTenantId());
            boolean validationStatus = this.keycloakClient.isValidEndUser(String.valueOf(request.getTenantId()), request.getUser().getUsername(), request.getAccessToken());
            if (validationStatus) {
                boolean status = this.keycloakClient.removeAdminPrivilege(String.valueOf(request.getTenantId()), request.getUser().getUsername());
                this.statusUpdater.updateStatus(IAMOperations.REMOVE_ADMIN_PRIVILEGE.name(), org.apache.custos.core.model.commons.OperationStatus.FAILED, request.getTenantId(), request.getPerformedBy());
                return OperationStatus.newBuilder().setStatus(status).build();
            }
            String msg = " Not a valid user: " + request.getUser().getId();
            LOGGER.error(msg);
            throw new EntityNotFoundException(msg);
        }
        catch (Exception ex) {
            String msg = " Remove admin privilege " + request.getTenantId() + " " + ex.getMessage();
            LOGGER.error(msg, (Throwable)ex);
            this.statusUpdater.updateStatus(IAMOperations.REMOVE_ADMIN_PRIVILEGE.name(), org.apache.custos.core.model.commons.OperationStatus.SUCCESS, request.getTenantId(), request.getPerformedBy());
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public GetAllResourcesResponse getAllResources(GetAllResources request) {
        try {
            LOGGER.debug("Request received to getAllResources for tenant " + request.getTenantId());
            List<UserRepresentation> representations = this.keycloakClient.getAllUsers(String.valueOf(request.getTenantId()));
            GetAllResourcesResponse resourcesResponse = GetAllResourcesResponse.newBuilder().build();
            if (!representations.isEmpty()) {
                if (request.getResourceType().name().equals(ResourceTypes.USER.name())) {
                    ArrayList<org.apache.custos.core.iam.api.UserRepresentation> users = new ArrayList<org.apache.custos.core.iam.api.UserRepresentation>();
                    for (UserRepresentation userRepresentation : representations) {
                        boolean validationStatus = this.keycloakClient.isValidEndUser(String.valueOf(request.getTenantId()), userRepresentation.getUsername());
                        if (!validationStatus) continue;
                        users.add(this.getUser(userRepresentation, request.getClientId()));
                    }
                    return resourcesResponse.toBuilder().addAllUsers(users).build();
                }
                ArrayList<Agent> agents = new ArrayList<Agent>();
                for (UserRepresentation userRepresentation : representations) {
                    boolean validationStatus = this.keycloakClient.isValidEndUser(String.valueOf(request.getTenantId()), userRepresentation.getUsername());
                    if (validationStatus) continue;
                    agents.add(this.getAgent(userRepresentation));
                }
                return resourcesResponse.toBuilder().addAllAgents(agents).build();
            }
            String msg = " Empty resources";
            LOGGER.error(msg);
            throw new RuntimeException(msg);
        }
        catch (Exception ex) {
            String msg = " Get all resources failed";
            LOGGER.error(msg, (Throwable)ex);
            if (ex.getMessage().contains("HTTP 401 Unauthorized")) {
                throw new RuntimeException("HTTP 401 Unauthorized", ex);
            }
            throw new RuntimeException(msg, ex);
        }
    }

    public String getIamServerURL() {
        return this.iamServerURL;
    }

    public Map<String, Object> getUserInfo(String accessToken, long tenantId) throws ParseException {
        return this.keycloakClient.getUserInfo(this.tokenService.getKCToken(accessToken), tenantId);
    }

    public Map<String, String> configureClient(long tenantId, String clientId, String tenantUrl, List<String> redirectUris) {
        KeycloakClientSecret clientSecret = this.keycloakClient.configureClient(String.valueOf(tenantId), clientId, tenantUrl, redirectUris);
        return Map.of("clientId", clientSecret.getClientId(), "clientSecret", clientSecret.getClientSecret());
    }

    private org.apache.custos.core.iam.api.UserRepresentation getUser(UserRepresentation representation, String clientId) {
        String state = "PENDING_CONFIRMATION";
        if (representation.isEnabled().booleanValue()) {
            state = "ACTIVE";
        } else if (representation.isEmailVerified().booleanValue()) {
            state = "CONFIRMED";
        }
        Map attributes = representation.getAttributes();
        List<Object> attributeList = new ArrayList();
        if (attributes != null && !attributes.isEmpty()) {
            attributeList = attributes.entrySet().stream().map(entry -> UserAttribute.newBuilder().setKey((String)entry.getKey()).addAllValues((Iterable)entry.getValue()).build()).collect(Collectors.toList());
        }
        UserRepresentation.Builder builder = org.apache.custos.core.iam.api.UserRepresentation.newBuilder().setUsername(representation.getUsername()).setFirstName(representation.getFirstName()).setLastName(representation.getLastName()).setState(state).setCreationTime((double)representation.getCreatedTimestamp().longValue()).setEmail(representation.getEmail());
        if (representation.getAttributes() != null && !representation.getAttributes().isEmpty()) {
            builder.addAllAttributes(attributeList);
        }
        if (representation.getRealmRoles() != null && !representation.getRealmRoles().isEmpty()) {
            builder.addAllRealmRoles((Iterable)representation.getRealmRoles());
        }
        if (representation.getClientRoles() != null && representation.getClientRoles().get(clientId) != null && !((List)representation.getClientRoles().get(clientId)).isEmpty()) {
            builder.addAllClientRoles((Iterable)representation.getClientRoles().get(clientId));
        }
        return builder.build();
    }

    private OperationMetadata convertFromEntity(StatusEntity entity) {
        return OperationMetadata.newBuilder().setEvent(entity.getEvent()).setStatus(entity.getState()).setPerformedBy(entity.getPerformedBy()).setTimeStamp(entity.getTime().toString()).build();
    }

    private List<org.keycloak.representations.idm.GroupRepresentation> transformToKeycloakGroups(String clientId, List<GroupRepresentation> groupRepresentations) {
        ArrayList<org.keycloak.representations.idm.GroupRepresentation> groupsList = new ArrayList<org.keycloak.representations.idm.GroupRepresentation>();
        for (GroupRepresentation groupRepresentation : groupRepresentations) {
            groupsList.add(this.transformSingleGroupToKeycloakGroup(clientId, groupRepresentation, null));
        }
        return groupsList;
    }

    private org.keycloak.representations.idm.GroupRepresentation transformSingleGroupToKeycloakGroup(String clientId, GroupRepresentation groupRepresentation, org.keycloak.representations.idm.GroupRepresentation parentGroup) {
        String name = groupRepresentation.getName();
        String id = groupRepresentation.getId();
        if (StringUtils.isNotBlank((CharSequence)groupRepresentation.getOwnerId())) {
            groupRepresentation = groupRepresentation.toBuilder().addAttributes(UserAttribute.newBuilder().setKey("ownerId").addValues(groupRepresentation.getOwnerId()).build()).build();
        }
        if (StringUtils.isNotBlank((CharSequence)groupRepresentation.getDescription())) {
            groupRepresentation = groupRepresentation.toBuilder().addAttributes(UserAttribute.newBuilder().setKey("description").addValues(groupRepresentation.getDescription()).build()).build();
        }
        List attributeList = groupRepresentation.getAttributesList();
        ProtocolStringList realmRoles = groupRepresentation.getRealmRolesList();
        ProtocolStringList clientRoles = groupRepresentation.getClientRolesList();
        org.keycloak.representations.idm.GroupRepresentation keycloakGroup = new org.keycloak.representations.idm.GroupRepresentation();
        keycloakGroup.setName(name);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            keycloakGroup.setId(id);
        }
        HashMap<String, ProtocolStringList> map = new HashMap<String, ProtocolStringList>();
        if (!attributeList.isEmpty()) {
            for (Object attribute : attributeList) {
                map.put(attribute.getKey(), attribute.getValuesList());
            }
            keycloakGroup.setAttributes(map);
        }
        if (!realmRoles.isEmpty()) {
            keycloakGroup.setRealmRoles((List)realmRoles);
        }
        HashMap<String, ProtocolStringList> clientMap = new HashMap<String, ProtocolStringList>();
        if (!clientRoles.isEmpty()) {
            clientMap.put(clientId, clientRoles);
            keycloakGroup.setClientRoles(clientMap);
        }
        if (!groupRepresentation.getSubGroupsList().isEmpty()) {
            for (GroupRepresentation representation : groupRepresentation.getSubGroupsList()) {
                this.transformSingleGroupToKeycloakGroup(clientId, representation, keycloakGroup);
            }
        }
        if (parentGroup != null) {
            ArrayList<org.keycloak.representations.idm.GroupRepresentation> groupRepList = parentGroup.getSubGroups();
            if (groupRepList == null) {
                groupRepList = new ArrayList<org.keycloak.representations.idm.GroupRepresentation>();
            }
            String path = parentGroup.getPath() + "/" + keycloakGroup.getName();
            keycloakGroup.setPath(path);
            groupRepList.add(keycloakGroup);
            parentGroup.setSubGroups(groupRepList);
            return parentGroup;
        }
        String path = "/" + keycloakGroup.getName();
        keycloakGroup.setPath(path);
        return keycloakGroup;
    }

    private List<GroupRepresentation> transformKeycloakGroupsToGroups(String clientId, List<org.keycloak.representations.idm.GroupRepresentation> groupRepresentations) {
        ArrayList<GroupRepresentation> groupsList = new ArrayList<GroupRepresentation>();
        for (org.keycloak.representations.idm.GroupRepresentation groupRepresentation : groupRepresentations) {
            groupsList.add(this.transformKeycloakGroupToGroup(clientId, groupRepresentation, null));
        }
        return groupsList;
    }

    private GroupRepresentation transformKeycloakGroupToGroup(String clientId, org.keycloak.representations.idm.GroupRepresentation group, GroupRepresentation parent) {
        String name = group.getName();
        String id = group.getId();
        List realmRoles = group.getRealmRoles();
        Map clientRoles = group.getClientRoles();
        Map atrs = group.getAttributes();
        GroupRepresentation representation = GroupRepresentation.newBuilder().setName(name).setId(id).build();
        if (realmRoles != null && !realmRoles.isEmpty()) {
            representation = representation.toBuilder().addAllRealmRoles((Iterable)realmRoles).build();
        }
        if (clientRoles != null && !clientRoles.isEmpty() && !((List)clientRoles.get(clientId)).isEmpty()) {
            representation = representation.toBuilder().addAllClientRoles((Iterable)clientRoles.get(clientId)).build();
        }
        if (atrs != null && !atrs.isEmpty()) {
            ArrayList<UserAttribute> attributeList = new ArrayList<UserAttribute>();
            for (String key : atrs.keySet()) {
                if (key.equals("ownerId")) {
                    representation = representation.toBuilder().setOwnerId((String)((List)atrs.get(key)).get(0)).build();
                    continue;
                }
                if (key.equals("description")) {
                    representation = representation.toBuilder().setDescription((String)((List)atrs.get(key)).get(0)).build();
                    continue;
                }
                UserAttribute attribute = UserAttribute.newBuilder().setKey(key).addAllValues((Iterable)atrs.get(key)).build();
                attributeList.add(attribute);
            }
            representation = representation.toBuilder().addAllAttributes(attributeList).build();
        }
        if (group.getSubGroups() != null && !group.getSubGroups().isEmpty()) {
            for (org.keycloak.representations.idm.GroupRepresentation subGroup : group.getSubGroups()) {
                representation = this.transformKeycloakGroupToGroup(clientId, subGroup, representation);
            }
        }
        if (parent != null) {
            parent = parent.toBuilder().addSubGroups(representation).build();
        }
        if (parent != null) {
            return parent;
        }
        return representation;
    }

    private Agent getAgent(UserRepresentation representation) {
        Agent.Builder builder = Agent.newBuilder().setId(representation.getUsername()).setIsEnabled(representation.isEnabled().booleanValue()).setCreationTime((double)representation.getCreatedTimestamp().longValue());
        for (String key : representation.getAttributes().keySet()) {
            UserAttribute attribute = UserAttribute.newBuilder().setKey(key).addAllValues((Iterable)representation.getAttributes().get(key)).build();
            builder.addAttributes(attribute);
        }
        if (representation.getRealmRoles() != null && !representation.getRealmRoles().isEmpty()) {
            builder.addAllRealmRoles((Iterable)representation.getRealmRoles());
        }
        if (representation.getClientRoles() != null && !representation.getClientRoles().isEmpty() && representation.getClientRoles().get("agent-client") != null && !((List)representation.getClientRoles().get("agent-client")).isEmpty()) {
            builder.addAllClientRoles((Iterable)representation.getClientRoles().get("agent-client"));
        }
        return builder.build();
    }
}

