/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.server.grpc;

import io.grpc.stub.StreamObserver;
import org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.apache.bookkeeper.stream.proto.storage.GetStorageContainerEndpointRequest;
import org.apache.bookkeeper.stream.proto.storage.GetStorageContainerEndpointResponse;
import org.apache.bookkeeper.stream.proto.storage.OneStorageContainerEndpointResponse;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.apache.bookkeeper.stream.proto.storage.StorageContainerEndpoint;
import org.apache.bookkeeper.stream.proto.storage.StorageContainerServiceGrpc;
import org.apache.bookkeeper.stream.storage.api.StorageContainerStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcStorageContainerService
extends StorageContainerServiceGrpc.StorageContainerServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(GrpcStorageContainerService.class);
    private final StorageContainerStore storageContainerStore;

    GrpcStorageContainerService(StorageContainerStore storageContainerStore) {
        this.storageContainerStore = storageContainerStore;
    }

    public void getStorageContainerEndpoint(GetStorageContainerEndpointRequest request, StreamObserver<GetStorageContainerEndpointResponse> responseObserver) {
        GetStorageContainerEndpointResponse.Builder responseBuilder = GetStorageContainerEndpointResponse.newBuilder().setStatusCode(StatusCode.SUCCESS);
        for (int i = 0; i < request.getRequestsCount(); ++i) {
            Endpoint endpoint = this.storageContainerStore.getRoutingService().getStorageContainer(request.getRequests(i).getStorageContainer());
            OneStorageContainerEndpointResponse.Builder oneRespBuilder = null != endpoint ? OneStorageContainerEndpointResponse.newBuilder().setStatusCode(StatusCode.SUCCESS).setEndpoint(StorageContainerEndpoint.newBuilder().setRwEndpoint(endpoint).addRoEndpoint(endpoint).setRevision(0L)) : OneStorageContainerEndpointResponse.newBuilder().setStatusCode(StatusCode.INTERNAL_SERVER_ERROR);
            responseBuilder = responseBuilder.addResponses(oneRespBuilder);
        }
        responseObserver.onNext((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }
}

