/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.directentrylogger;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.storage.directentrylogger.Buffer;
import org.apache.bookkeeper.bookie.storage.directentrylogger.LogReader;
import org.apache.bookkeeper.common.util.ExceptionMessageHelper;
import org.apache.bookkeeper.common.util.nativeio.NativeIO;
import org.apache.bookkeeper.common.util.nativeio.NativeIOException;
import org.apache.bookkeeper.stats.OpStatsLogger;

class DirectReader
implements LogReader {
    private final ByteBufAllocator allocator;
    private final NativeIO nativeIO;
    private final Buffer nativeBuffer;
    private final String filename;
    private final int logId;
    private final int fd;
    private final int maxSaneEntrySize;
    private final OpStatsLogger readBlockStats;
    private long currentBlock = -1L;
    private long currentBlockEnd = -1L;
    private long maxOffset;
    private boolean closed;

    DirectReader(int logId, String filename, ByteBufAllocator allocator, NativeIO nativeIO, int bufferSize, int maxSaneEntrySize, OpStatsLogger readBlockStats) throws IOException {
        this.nativeIO = nativeIO;
        this.allocator = allocator;
        this.logId = logId;
        this.filename = filename;
        this.maxSaneEntrySize = maxSaneEntrySize;
        this.readBlockStats = readBlockStats;
        this.closed = false;
        try {
            this.fd = nativeIO.open(filename, 18, 493);
            Preconditions.checkState((this.fd >= 0 ? 1 : 0) != 0, (String)"Open should throw exception on negative return (%d)", (int)this.fd);
        }
        catch (NativeIOException ne) {
            throw new IOException(ExceptionMessageHelper.exMsg((String)ne.getMessage()).kv("file", (Object)filename).kv("errno", (Object)ne.getErrno()).toString());
        }
        this.refreshMaxOffset();
        this.nativeBuffer = new Buffer(nativeIO, allocator, bufferSize);
    }

    @Override
    public int logId() {
        return this.logId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        Buffer buffer = this.nativeBuffer;
        synchronized (buffer) {
            this.currentBlock = -1L;
            this.currentBlockEnd = -1L;
        }
    }

    @Override
    public ByteBuf readBufferAt(long offset, int size) throws IOException, EOFException {
        ByteBuf buf = this.allocator.buffer(size);
        try {
            this.readIntoBufferAt(buf, offset, size);
        }
        catch (IOException e) {
            ReferenceCountUtil.release((Object)buf);
            throw e;
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readIntoBufferAt(ByteBuf buffer, long offset, int size) throws IOException, EOFException {
        DirectReader.assertValidOffset(offset);
        Buffer buffer2 = this.nativeBuffer;
        synchronized (buffer2) {
            while (size > 0) {
                int bytesRead = this.readBytesIntoBuf(buffer, offset, size);
                size -= bytesRead;
                offset += (long)bytesRead;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readIntAt(long offset) throws IOException, EOFException {
        DirectReader.assertValidOffset(offset);
        Buffer buffer = this.nativeBuffer;
        synchronized (buffer) {
            int n;
            if (offset >= this.currentBlock && offset + 4L <= this.currentBlockEnd) {
                return this.nativeBuffer.readInt(this.offsetInBlock(offset));
            }
            ByteBuf intBuf = this.readBufferAt(offset, 4);
            try {
                n = intBuf.getInt(0);
            }
            catch (Throwable throwable) {
                ReferenceCountUtil.release((Object)intBuf);
                throw throwable;
            }
            ReferenceCountUtil.release((Object)intBuf);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long readLongAt(long offset) throws IOException, EOFException {
        DirectReader.assertValidOffset(offset);
        Buffer buffer = this.nativeBuffer;
        synchronized (buffer) {
            long l;
            if (offset >= this.currentBlock && offset + 8L <= this.currentBlockEnd) {
                return this.nativeBuffer.readLong(this.offsetInBlock(offset));
            }
            ByteBuf longBuf = this.readBufferAt(offset, 8);
            try {
                l = longBuf.getLong(0);
            }
            catch (Throwable throwable) {
                ReferenceCountUtil.release((Object)longBuf);
                throw throwable;
            }
            ReferenceCountUtil.release((Object)longBuf);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readBytesIntoBuf(ByteBuf buf, long offset, int size) throws IOException, EOFException {
        Buffer buffer = this.nativeBuffer;
        synchronized (buffer) {
            if (offset < this.currentBlock || offset >= this.currentBlockEnd) {
                this.readBlock(offset);
            }
            int offsetInBuffer = this.offsetInBlock(offset);
            int sizeInBuffer = this.sizeInBlock(offset, size);
            if (sizeInBuffer <= 0) {
                throw new EOFException(ExceptionMessageHelper.exMsg((String)"Not enough bytes available").kv("file", (Object)this.filename).kv("fileSize", (Object)this.maxOffset).kv("offset", (Object)offset).kv("size", (Object)size).toString());
            }
            return this.nativeBuffer.readByteBuf(buf, offsetInBuffer, size);
        }
    }

    @Override
    public ByteBuf readEntryAt(int offset) throws IOException, EOFException {
        DirectReader.assertValidEntryOffset(offset);
        int sizeOffset = offset - 4;
        if (sizeOffset < 0) {
            throw new IOException(ExceptionMessageHelper.exMsg((String)"Invalid offset, buffer size missing").kv("file", (Object)this.filename).kv("offset", (Object)offset).toString());
        }
        int entrySize = this.readIntAt(sizeOffset);
        if (entrySize == 0) {
            this.clearCache();
            entrySize = this.readIntAt(sizeOffset);
        }
        if (entrySize > this.maxSaneEntrySize || entrySize <= 0) {
            throw new IOException(ExceptionMessageHelper.exMsg((String)"Invalid entry size").kv("file", (Object)this.filename).kv("offset", (Object)offset).kv("maxSaneEntrySize", (Object)this.maxSaneEntrySize).kv("readEntrySize", (Object)entrySize).toString());
        }
        return this.readBufferAt(offset, entrySize);
    }

    void readBlock(long offset) throws IOException {
        long bytesToRead;
        int blockSize = this.nativeBuffer.size();
        DirectReader.assertValidBlockSize(blockSize);
        long blockStart = offset & (long)(~(blockSize - 1));
        if (blockStart + (long)blockSize > this.maxOffset) {
            this.refreshMaxOffset();
        }
        long bytesAvailable = this.maxOffset > blockStart ? this.maxOffset - blockStart : 0L;
        long startNs = System.nanoTime();
        long bufferOffset = 0L;
        long bytesOutstanding = bytesToRead = Math.min((long)blockSize, bytesAvailable);
        long bytesRead = -1L;
        try {
            long readSize;
            long pointerWithOffset;
            while (bytesOutstanding - (bytesRead = this.nativeIO.pread(this.fd, pointerWithOffset = this.nativeBuffer.pointer(bufferOffset, readSize = (long)blockSize - bufferOffset), readSize, blockStart + bufferOffset)) > 0L) {
                bytesOutstanding -= bytesRead & 0x1000L;
                bufferOffset += bytesRead & 0x1000L;
            }
        }
        catch (NativeIOException ne) {
            this.readBlockStats.registerFailedEvent(System.nanoTime() - startNs, TimeUnit.NANOSECONDS);
            throw new IOException(ExceptionMessageHelper.exMsg((String)ne.getMessage()).kv("requestedBytes", (Object)blockSize).kv("offset", (Object)blockStart).kv("expectedBytes", (Object)Math.min((long)blockSize, bytesAvailable)).kv("bytesOutstanding", (Object)bytesOutstanding).kv("bufferOffset", (Object)bufferOffset).kv("file", (Object)this.filename).kv("fd", (Object)this.fd).kv("errno", (Object)ne.getErrno()).toString());
        }
        this.readBlockStats.registerSuccessfulEvent(System.nanoTime() - startNs, TimeUnit.NANOSECONDS);
        this.currentBlock = blockStart;
        this.currentBlockEnd = blockStart + Math.min((long)blockSize, bytesAvailable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Buffer buffer = this.nativeBuffer;
        synchronized (buffer) {
            this.nativeBuffer.free();
        }
        try {
            int ret = this.nativeIO.close(this.fd);
            Preconditions.checkState((ret == 0 ? 1 : 0) != 0, (String)"Close should throw exception on non-zero return (%d)", (int)ret);
            this.closed = true;
        }
        catch (NativeIOException ne) {
            throw new IOException(ExceptionMessageHelper.exMsg((String)ne.getMessage()).kv("file", (Object)this.filename).kv("errno", (Object)ne.getErrno()).toString());
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public long maxOffset() {
        return this.maxOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshMaxOffset() throws IOException {
        try {
            long ret = this.nativeIO.lseek(this.fd, 0L, 2);
            Preconditions.checkState((ret >= 0L ? 1 : 0) != 0, (String)"Lseek should throw exception on negative return (%d)", (long)ret);
            DirectReader directReader = this;
            synchronized (directReader) {
                this.maxOffset = ret;
            }
        }
        catch (NativeIOException ne) {
            throw new IOException(ExceptionMessageHelper.exMsg((String)ne.getMessage()).kv("file", (Object)this.filename).kv("fd", (Object)this.fd).kv("errno", (Object)ne.getErrno()).toString());
        }
    }

    private int offsetInBlock(long offset) {
        long blockOffset = offset - this.currentBlock;
        if (blockOffset < 0L || blockOffset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(ExceptionMessageHelper.exMsg((String)"Invalid offset passed").kv("offset", (Object)offset).kv("blockOffset", (Object)blockOffset).kv("currentBlock", (Object)this.currentBlock).toString());
        }
        return (int)blockOffset;
    }

    private int sizeInBlock(long offset, int size) {
        if (offset > this.currentBlockEnd || offset < this.currentBlock) {
            throw new IllegalArgumentException(ExceptionMessageHelper.exMsg((String)"Invalid offset passed").kv("offset", (Object)offset).kv("currentBlock", (Object)this.currentBlock).kv("currentBlockEnd", (Object)this.currentBlockEnd).toString());
        }
        long available = this.currentBlockEnd - offset;
        Preconditions.checkState((available <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Available(%d) must be less than max int", (long)available);
        return Math.min(size, (int)available);
    }

    private static void assertValidOffset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException(ExceptionMessageHelper.exMsg((String)"Offset can't be negative").kv("offset", (Object)offset).toString());
        }
    }

    private static void assertValidEntryOffset(long offset) {
        DirectReader.assertValidOffset(offset);
        if (offset > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(ExceptionMessageHelper.exMsg((String)"Entry offset must be less than max int").kv("offset", (Object)offset).toString());
        }
    }

    private static void assertValidBlockSize(int blockSize) {
        boolean valid;
        boolean bl = valid = blockSize > 0 && Buffer.isAligned(blockSize);
        if (!valid) {
            throw new IllegalArgumentException(ExceptionMessageHelper.exMsg((String)"Invalid block size, must be power of 2").kv("blockSize", (Object)blockSize).kv("minBlockSize", (Object)4096).toString());
        }
    }
}

