/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.serializers.DecimalSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public class DecimalType
extends AbstractType<BigDecimal> {
    public static final DecimalType instance = new DecimalType();

    DecimalType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public int compareCustom(ByteBuffer o1, ByteBuffer o2) {
        if (!o1.hasRemaining() || !o2.hasRemaining()) {
            return o1.hasRemaining() ? 1 : (o2.hasRemaining() ? -1 : 0);
        }
        return ((BigDecimal)this.compose(o1)).compareTo((BigDecimal)this.compose(o2));
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        BigDecimal decimal;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            decimal = new BigDecimal(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("unable to make BigDecimal from '%s'", source), e);
        }
        return this.decompose(decimal);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString(Objects.toString(parsed)));
        }
        catch (NumberFormatException | MarshalException exc) {
            throw new MarshalException(String.format("Value '%s' is not a valid representation of a decimal value", parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return Objects.toString(this.getSerializer().deserialize(buffer), "\"\"");
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.DECIMAL;
    }

    @Override
    public TypeSerializer<BigDecimal> getSerializer() {
        return DecimalSerializer.instance;
    }
}

