/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.utils.FBUtilities;

public final class ViewUtils {
    private ViewUtils() {
    }

    public static Optional<InetAddress> getViewNaturalEndpoint(String keyspaceName, Token baseToken, Token viewToken) {
        AbstractReplicationStrategy replicationStrategy = Keyspace.open(keyspaceName).getReplicationStrategy();
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getBroadcastAddress());
        ArrayList<InetAddress> baseEndpoints = new ArrayList<InetAddress>();
        ArrayList<InetAddress> viewEndpoints = new ArrayList<InetAddress>();
        for (InetAddress baseEndpoint : replicationStrategy.getNaturalEndpoints(baseToken)) {
            if (replicationStrategy instanceof NetworkTopologyStrategy && !DatabaseDescriptor.getEndpointSnitch().getDatacenter(baseEndpoint).equals(localDataCenter)) continue;
            baseEndpoints.add(baseEndpoint);
        }
        for (InetAddress viewEndpoint : replicationStrategy.getNaturalEndpoints(viewToken)) {
            if (viewEndpoint.equals(FBUtilities.getBroadcastAddress())) {
                return Optional.of(viewEndpoint);
            }
            if (baseEndpoints.contains(viewEndpoint)) {
                baseEndpoints.remove(viewEndpoint);
                continue;
            }
            if (replicationStrategy instanceof NetworkTopologyStrategy && !DatabaseDescriptor.getEndpointSnitch().getDatacenter(viewEndpoint).equals(localDataCenter)) continue;
            viewEndpoints.add(viewEndpoint);
        }
        assert (baseEndpoints.size() == viewEndpoints.size()) : "Replication strategy should have the same number of endpoints for the base and the view";
        int baseIdx = baseEndpoints.indexOf(FBUtilities.getBroadcastAddress());
        if (baseIdx < 0) {
            return Optional.empty();
        }
        return Optional.of(viewEndpoints.get(baseIdx));
    }
}

