/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.RequestCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPaxosCallback<T>
implements RequestCallback<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPaxosCallback.class);
    protected final CountDownLatch latch;
    protected final int targets;
    private final ConsistencyLevel consistency;
    private final long queryStartNanoTime;

    public AbstractPaxosCallback(int targets, ConsistencyLevel consistency, long queryStartNanoTime) {
        this.targets = targets;
        this.consistency = consistency;
        this.latch = new CountDownLatch(targets);
        this.queryStartNanoTime = queryStartNanoTime;
    }

    public int getResponseCount() {
        return (int)((long)this.targets - this.latch.getCount());
    }

    public void await() throws WriteTimeoutException {
        try {
            long timeout = DatabaseDescriptor.getWriteRpcTimeout(TimeUnit.NANOSECONDS) - (System.nanoTime() - this.queryStartNanoTime);
            if (!this.latch.await(timeout, TimeUnit.NANOSECONDS)) {
                throw new WriteTimeoutException(WriteType.CAS, this.consistency, this.getResponseCount(), this.targets);
            }
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)"This latch shouldn't have been interrupted.");
        }
    }

    @Override
    public void onFailure(InetAddressAndPort from, RequestFailureReason failureReason) {
        logger.debug("Received paxos propose/prepare failure response from {} reason {}", (Object)from, (Object)failureReason);
    }

    @Override
    public boolean invokeOnFailure() {
        return true;
    }
}

