/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.DataObjectBuilder;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.PeriodicTaskConfiguration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicTaskConfigurationImpl
implements PeriodicTaskConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeriodicTaskConfigurationImpl.class);
    private static final boolean DEFAULT_ENABLED = false;
    @JsonProperty(value="enabled")
    private final boolean enabled;
    private MillisecondBoundConfiguration initialDelay;
    private MillisecondBoundConfiguration executeInterval;

    public PeriodicTaskConfigurationImpl() {
        this.enabled = false;
    }

    public PeriodicTaskConfigurationImpl(boolean enabled, MillisecondBoundConfiguration initialDelay, MillisecondBoundConfiguration executeInterval) {
        this.enabled = enabled;
        this.initialDelay = initialDelay;
        this.executeInterval = executeInterval;
    }

    protected PeriodicTaskConfigurationImpl(Builder builder) {
        this.enabled = builder.enabled;
        this.setInitialDelay(builder.initialDelay);
        this.setExecuteInterval(Objects.requireNonNull(builder.executeInterval, "executeInterval must be configured"));
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="initial_delay")
    @NotNull
    public MillisecondBoundConfiguration initialDelay() {
        if (this.initialDelay == null) {
            return this.executeInterval;
        }
        return this.initialDelay;
    }

    @JsonProperty(value="initial_delay")
    public void setInitialDelay(MillisecondBoundConfiguration initialDelay) {
        if (initialDelay != null) {
            if (initialDelay.compareTo((DurationSpec)MillisecondBoundConfiguration.ZERO) >= 0) {
                this.initialDelay = initialDelay;
            } else {
                LOGGER.warn("Invalid initialDelay configuration {}, the minimum value is 0", (Object)initialDelay);
                this.initialDelay = MillisecondBoundConfiguration.ZERO;
            }
        }
    }

    @JsonProperty(value="initial_delay_millis")
    @Deprecated
    public void setInitialDelayMillis(long initialDelayMillis) {
        LOGGER.warn("'initial_delay_millis' is deprecated, use 'initial_delay' instead");
        this.setInitialDelay(new MillisecondBoundConfiguration(initialDelayMillis, TimeUnit.MILLISECONDS));
    }

    @Override
    @JsonProperty(value="execute_interval")
    @NotNull
    public MillisecondBoundConfiguration executeInterval() {
        return this.executeInterval;
    }

    @JsonProperty(value="execute_interval")
    public void setExecuteInterval(MillisecondBoundConfiguration executeInterval) {
        if (executeInterval.compareTo((DurationSpec)MillisecondBoundConfiguration.ONE) > 0) {
            this.executeInterval = executeInterval;
        } else {
            LOGGER.warn("Invalid executeInterval configuration {}, the minimum value is 1ms", (Object)executeInterval);
            this.executeInterval = MillisecondBoundConfiguration.ONE;
        }
    }

    @JsonAlias(value={"execute_interval_millis", "poll_freq_millis", "poll_interval_millis"})
    @Deprecated
    public void setExecuteIntervalMillis(long executeIntervalMillis) {
        LOGGER.warn("'execute_interval_millis', 'poll_freq_millis', and 'poll_interval_millis' are deprecated, use 'execute_interval' instead.");
        this.setExecuteInterval(new MillisecondBoundConfiguration(executeIntervalMillis, TimeUnit.MILLISECONDS));
    }

    public static class Builder
    implements DataObjectBuilder<Builder, PeriodicTaskConfigurationImpl> {
        private boolean enabled;
        private MillisecondBoundConfiguration initialDelay;
        private MillisecondBoundConfiguration executeInterval;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder self() {
            return this;
        }

        public Builder enabled(boolean enabled) {
            return (Builder)this.update(b -> {
                b.enabled = enabled;
            });
        }

        public Builder initialDelay(MillisecondBoundConfiguration initialDelay) {
            return (Builder)this.update(b -> {
                b.initialDelay = initialDelay;
            });
        }

        public Builder executeInterval(MillisecondBoundConfiguration executeInterval) {
            return (Builder)this.update(b -> {
                b.executeInterval = executeInterval;
            });
        }

        public PeriodicTaskConfigurationImpl build() {
            return new PeriodicTaskConfigurationImpl(this);
        }
    }
}

