/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.cassandra.sidecar.common.data.StorageCredentials;

public class RestoreJobSecrets {
    private final StorageCredentials writeCredentials;
    private final StorageCredentials readCredentials;

    @JsonCreator
    public RestoreJobSecrets(@JsonProperty(value="readCredentials") StorageCredentials readCredentials, @JsonProperty(value="writeCredentials") StorageCredentials writeCredentials) {
        Objects.requireNonNull(readCredentials, "Read credentials must be supplied");
        Objects.requireNonNull(writeCredentials, "Write credentials must be supplied");
        this.readCredentials = readCredentials;
        this.writeCredentials = writeCredentials;
    }

    @JsonProperty(value="writeCredentials")
    public StorageCredentials writeCredentials() {
        return this.writeCredentials;
    }

    @JsonProperty(value="readCredentials")
    public StorageCredentials readCredentials() {
        return this.readCredentials;
    }

    public String toString() {
        return String.format("RestoreJobSecrets{%s=%s, %s=%s}", "writeCredentials", this.writeCredentials, "readCredentials", this.readCredentials);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RestoreJobSecrets)) {
            return false;
        }
        RestoreJobSecrets that = (RestoreJobSecrets)obj;
        return Objects.equals(this.readCredentials, that.readCredentials) && Objects.equals(this.writeCredentials, that.writeCredentials);
    }

    public int hashCode() {
        return Objects.hash(this.writeCredentials, this.readCredentials);
    }
}

