/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.ParentAttachmentStrategy;
import org.apache.cayenne.access.PrefetchProcessorNode;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.ClassDescriptor;

class JoinedIdParentAttachmentStrategy
implements ParentAttachmentStrategy {
    private final CayennePath relatedIdPrefix;
    private final Collection<ObjEntity> sourceEntities;
    private final PrefetchProcessorNode node;
    private final GraphManager graphManager;

    JoinedIdParentAttachmentStrategy(GraphManager graphManager, PrefetchProcessorNode node) {
        ClassDescriptor parentDescriptor = ((PrefetchProcessorNode)node.getParent()).getResolver().getDescriptor();
        this.relatedIdPrefix = node.getIncoming().getRelationship().getReverseDbRelationshipPath();
        this.sourceEntities = parentDescriptor.getEntityInheritanceTree().allSubEntities();
        this.node = node;
        this.graphManager = graphManager;
    }

    @Override
    public void linkToParent(DataRow row, Persistent object) {
        Persistent parentObject = null;
        for (ObjEntity entity : this.sourceEntities) {
            if (entity.isAbstract()) continue;
            ObjectId id = this.node.getResolver().createObjectId(row, entity, this.relatedIdPrefix);
            if (id == null) {
                throw new CayenneRuntimeException("Can't build ObjectId from row: %s, entity: %s, prefix: %s", row, entity.getName(), this.relatedIdPrefix);
            }
            parentObject = (Persistent)this.graphManager.getNode(id);
            if (parentObject == null) continue;
            break;
        }
        this.node.linkToParent(object, parentObject);
    }
}

