/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph;

import java.awt.Color;
import java.util.Collection;
import org.apache.cayenne.dbsync.model.DetectedDbEntity;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.DbAttributeListener;
import org.apache.cayenne.map.event.DbEntityListener;
import org.apache.cayenne.map.event.DbRelationshipListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.graph.BaseGraphBuilder;
import org.apache.cayenne.modeler.graph.DbEntityCellMetadata;
import org.apache.cayenne.modeler.graph.GraphType;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;

class DbGraphBuilder
extends BaseGraphBuilder<DbEntity, DbAttribute, DbRelationship>
implements DbEntityListener,
DbAttributeListener,
DbRelationshipListener {
    static final Color ENTITY_COLOR = new Color(197, 253, 252);

    DbGraphBuilder() {
    }

    @Override
    protected Collection<DbEntity> getEntities(DataMap map) {
        return map.getDbEntities();
    }

    @Override
    protected void postProcessEntity(DbEntity entity, DefaultGraphCell cell) {
        super.postProcessEntity(entity, cell);
        GraphConstants.setBackground(cell.getAttributes(), ENTITY_COLOR);
        GraphConstants.setOpaque(cell.getAttributes(), true);
    }

    protected DbEntityCellMetadata getCellMetadata(DbEntity e) {
        return new DbEntityCellMetadata(this, e);
    }

    @Override
    protected DefaultEdge createRelationshipCell(DbRelationship rel) {
        DefaultEdge edge = super.createRelationshipCell(rel);
        if (edge != null) {
            GraphConstants.setDashPattern(edge.getAttributes(), new float[]{10.0f, 3.0f});
        }
        return edge;
    }

    @Override
    public void setProjectController(ProjectController mediator) {
        super.setProjectController(mediator);
        mediator.addDbEntityListener(this);
        mediator.addDbAttributeListener(this);
        mediator.addDbRelationshipListener(this);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.mediator.removeDbEntityListener(this);
        this.mediator.removeDbAttributeListener(this);
        this.mediator.removeDbRelationshipListener(this);
    }

    @Override
    public void dbEntityAdded(EntityEvent e) {
        if (e.getEntity() instanceof DetectedDbEntity) {
            return;
        }
        this.insertEntityCell((DbEntity)e.getEntity());
    }

    @Override
    public void dbEntityChanged(EntityEvent e) {
        this.remapEntity(e);
        this.updateEntityCell((DbEntity)e.getEntity());
    }

    @Override
    public void dbEntityRemoved(EntityEvent e) {
        this.removeEntityCell((DbEntity)e.getEntity());
    }

    @Override
    public void dbAttributeAdded(AttributeEvent e) {
        this.updateEntityCell((DbEntity)e.getEntity());
    }

    @Override
    public void dbAttributeChanged(AttributeEvent e) {
        this.updateEntityCell((DbEntity)e.getEntity());
    }

    @Override
    public void dbAttributeRemoved(AttributeEvent e) {
        this.updateEntityCell((DbEntity)e.getEntity());
    }

    @Override
    public void dbRelationshipAdded(RelationshipEvent e) {
    }

    @Override
    public void dbRelationshipChanged(RelationshipEvent e) {
        this.updateRelationshipCell((DbRelationship)e.getRelationship());
    }

    @Override
    public void dbRelationshipRemoved(RelationshipEvent e) {
        this.remapRelationship(e);
        this.removeRelationshipCell((DbRelationship)e.getRelationship());
    }

    @Override
    public GraphType getType() {
        return GraphType.ER;
    }
}

