/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.path.CayennePathSegment;
import org.apache.cayenne.map.AliasPathComponent;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.AttributePathComponent;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.RelationshipPathComponent;

class PathComponentIterator<E extends Entity<E, A, R>, A extends Attribute<E, A, R>, R extends Relationship<E, A, R>>
implements Iterator<PathComponent<A, R>> {
    private final CayennePath path;
    private final Iterator<CayennePathSegment> iterator;
    private final Map<String, String> aliasMap;
    private EmbeddedAttribute embeddedAttribute;
    private Entity<E, A, R> currentEntity;

    PathComponentIterator(Entity<E, A, R> root, CayennePath path, Map<String, String> aliasMap) {
        this.currentEntity = Objects.requireNonNull(root);
        this.path = Objects.requireNonNull(path);
        this.iterator = path.iterator();
        this.aliasMap = Objects.requireNonNull(aliasMap);
        this.embeddedAttribute = null;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public PathComponent<A, R> next() {
        ObjAttribute attr;
        JoinType relationshipJoinType;
        CayennePathSegment nextSegment = this.iterator.next();
        String pathComp = nextSegment.value();
        JoinType joinType = relationshipJoinType = nextSegment.isOuterJoin() ? JoinType.LEFT_OUTER : JoinType.INNER;
        if (this.embeddedAttribute != null) {
            attr = this.embeddedAttribute.getAttribute(pathComp);
            this.embeddedAttribute = null;
        } else {
            attr = this.currentEntity.getAttribute(pathComp);
        }
        if (attr != null) {
            if (attr instanceof EmbeddedAttribute) {
                this.embeddedAttribute = (EmbeddedAttribute)attr;
            } else if (this.iterator.hasNext()) {
                throw new ExpressionException("Attribute must be the last component of the path: '" + pathComp + "'.", this.path, null);
            }
            return new AttributePathComponent(attr);
        }
        R rel = this.currentEntity.getRelationship(pathComp);
        if (rel != null) {
            this.currentEntity = ((Relationship)rel).getTargetEntity();
            return new RelationshipPathComponent(rel, relationshipJoinType, !this.hasNext());
        }
        PathComponent<A, R> aliasedPathComponent = this.getAliasedPathComponent(pathComp);
        if (aliasedPathComponent != null) {
            return aliasedPathComponent;
        }
        throw this.invalidPathException("Can't resolve path component", pathComp);
    }

    private PathComponent<A, R> getAliasedPathComponent(String pathComp) {
        String aliasedPath = this.aliasMap.get(pathComp);
        if (aliasedPath == null) {
            return null;
        }
        PathComponentIterator<E, A, R> subpathIt = new PathComponentIterator<E, A, R>(this.currentEntity, CayennePath.of(aliasedPath), Collections.emptyMap());
        ArrayList parsedSubpath = new ArrayList(4);
        while (subpathIt.hasNext()) {
            PathComponent subpathComponent = (PathComponent)subpathIt.next();
            Object subpathRelationship = subpathComponent.getRelationship();
            if (subpathRelationship == null) {
                throw this.invalidPathException("Expected a relationship in the aliased subpath. Alias [" + pathComp + "]", subpathComponent.getName());
            }
            this.currentEntity = ((Relationship)subpathRelationship).getTargetEntity();
            parsedSubpath.add(subpathComponent);
        }
        return new AliasPathComponent(pathComp, parsedSubpath, !this.hasNext());
    }

    private ExpressionException invalidPathException(String message, String pathComponent) {
        String buffer = message + ": [" + this.currentEntity.getName() + "." + pathComponent + "].";
        return new ExpressionException(buffer, this.path, null);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("'remove' operation is not supported.");
    }
}

