/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.service.config;

import java.io.IOException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.server.common.service.config.BaseConfigServiceImpl;
import org.apache.celeborn.server.common.service.config.ConfigService;
import org.apache.celeborn.server.common.service.config.TenantConfig;
import org.apache.celeborn.server.common.service.store.IServiceManager;
import org.apache.celeborn.server.common.service.store.db.DbServiceManagerImpl;
import org.apache.commons.lang3.tuple.Pair;

public class DbConfigServiceImpl
extends BaseConfigServiceImpl
implements ConfigService {
    private volatile IServiceManager iServiceManager;

    public DbConfigServiceImpl(CelebornConf celebornConf) throws IOException {
        super(celebornConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshCache() throws IOException {
        if (this.iServiceManager == null) {
            DbConfigServiceImpl dbConfigServiceImpl = this;
            synchronized (dbConfigServiceImpl) {
                if (this.iServiceManager == null) {
                    this.iServiceManager = new DbServiceManagerImpl(this.celebornConf, this);
                }
            }
        }
        this.systemConfigAtomicReference.set(this.iServiceManager.getSystemConfig());
        this.tenantConfigAtomicReference.set(this.iServiceManager.getAllTenantConfigs().stream().collect(Collectors.toMap(TenantConfig::getTenantId, Function.identity())));
        this.tenantUserConfigAtomicReference.set(this.iServiceManager.getAllTenantUserConfigs().stream().collect(Collectors.toMap(tenantConfig -> Pair.of((Object)tenantConfig.getTenantId(), (Object)tenantConfig.getName()), Function.identity())));
    }
}

