/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.http.api.v1;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.celeborn.common.meta.WorkerEventInfo;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.protocol.WorkerEventType;
import org.apache.celeborn.rest.v1.model.ExcludeWorkerRequest;
import org.apache.celeborn.rest.v1.model.HandleResponse;
import org.apache.celeborn.rest.v1.model.RemoveWorkersUnavailableInfoRequest;
import org.apache.celeborn.rest.v1.model.SendWorkerEventRequest;
import org.apache.celeborn.rest.v1.model.TopologyInfo;
import org.apache.celeborn.rest.v1.model.TopologyResponse;
import org.apache.celeborn.rest.v1.model.WorkerEventData;
import org.apache.celeborn.rest.v1.model.WorkerEventInfoData;
import org.apache.celeborn.rest.v1.model.WorkerEventsResponse;
import org.apache.celeborn.rest.v1.model.WorkerTimestampData;
import org.apache.celeborn.rest.v1.model.WorkersResponse;
import org.apache.celeborn.server.common.HttpService;
import org.apache.celeborn.server.common.http.api.ApiRequestContext;
import org.apache.celeborn.server.common.http.api.v1.ApiUtils$;
import org.apache.celeborn.service.deploy.master.Master;
import org.apache.celeborn.service.deploy.master.clustermeta.AbstractMetaManager;
import org.apache.celeborn.service.deploy.master.http.api.MasterHttpResourceUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Tag(name="Worker")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\t5b\u0001B\u0006\r\u0001}AQ\u0001\r\u0001\u0005\u0002EBQa\u0005\u0001\u0005\nQBQ!\u000f\u0001\u0005\niBQ!\u0011\u0001\u0005\u0002\tCq!!\u0004\u0001\t\u0003\ty\u0001C\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h!9\u0011q\u0011\u0001\u0005\u0002\u0005%\u0005bBAQ\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003\u0007\u0004A\u0011BAc\u000599vN]6feJ+7o\\;sG\u0016T!!\u0004\b\u0002\u0005Y\f$BA\b\u0011\u0003\r\t\u0007/\u001b\u0006\u0003#I\tA\u0001\u001b;ua*\u00111\u0003F\u0001\u0007[\u0006\u001cH/\u001a:\u000b\u0005U1\u0012A\u00023fa2|\u0017P\u0003\u0002\u00181\u000591/\u001a:wS\u000e,'BA\r\u001b\u0003!\u0019W\r\\3c_Jt'BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007CA\u0014/\u001b\u0005A#BA\b*\u0015\t\t\"F\u0003\u0002,Y\u000511m\\7n_:T!!\f\r\u0002\rM,'O^3s\u0013\ty\u0003FA\tBa&\u0014V-];fgR\u001cuN\u001c;fqR\fa\u0001P5oSRtD#\u0001\u001a\u0011\u0005M\u0002Q\"\u0001\u0007\u0016\u0003U\u0002\"AN\u001c\u000e\u0003II!\u0001\u000f\n\u0003\r5\u000b7\u000f^3s\u00031\u0019H/\u0019;vgNK8\u000f^3n+\u0005Y\u0004C\u0001\u001f@\u001b\u0005i$B\u0001 \u0013\u0003-\u0019G.^:uKJlW\r^1\n\u0005\u0001k$aE!cgR\u0014\u0018m\u0019;NKR\fW*\u00198bO\u0016\u0014\u0018aB<pe.,'o]\u000b\u0002\u0007B\u0011AIS\u0007\u0002\u000b*\u0011aiR\u0001\u0006[>$W\r\u001c\u0006\u0003\u001b!S!!\u0013\r\u0002\tI,7\u000f^\u0005\u0003\u0017\u0016\u0013qbV8sW\u0016\u00148OU3ta>t7/\u001a\u0015\u0003\t5\u0003\"AT+\u000e\u0003=S!\u0001U)\u0002\u0005I\u001c(B\u0001*T\u0003\t98OC\u0001U\u0003\u0015Q\u0017M^1y\u0013\t1vJA\u0002H\u000bRCc\u0001\u0002-iS.d\u0007CA-g\u001b\u0005Q&BA.]\u0003%\u0011Xm\u001d9p]N,7O\u0003\u0002^=\u0006Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\ty\u0006-A\u0002pCNT!!\u00192\u0002\u0005Y\u001c$BA2e\u0003\u001d\u0019x/Y4hKJT\u0011!Z\u0001\u0003S>L!a\u001a.\u0003\u0017\u0005\u0003\u0018NU3ta>t7/Z\u0001\re\u0016\u001c\bo\u001c8tK\u000e{G-Z\u0011\u0002U\u0006\u0019!\u0007\r\u0019\u0002\u000f\r|g\u000e^3oi2\nQnK\u0003oiV<\b\u0010\u0005\u0002pe6\t\u0001O\u0003\u0002r9\u0006)Q.\u001a3jC&\u00111\u000f\u001d\u0002\b\u0007>tG/\u001a8u\u0003%iW\rZ5b)f\u0004X-I\u0001w\u0003A\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c80UN|g.\u0001\u0004tG\",W.Y\u0016\u0004srl\bCA8{\u0013\tY\bO\u0001\u0004TG\",W.Y\u0001\u000fS6\u0004H.Z7f]R\fG/[8oG\u0005\u0019\u0005F\u0002\u0003\u0000\u0003\u000f\tI\u0001\u0005\u0003\u0002\u0002\u0005\rQ\"\u0001/\n\u0007\u0005\u0015ALA\u0005Pa\u0016\u0014\u0018\r^5p]\u0006YA-Z:de&\u0004H/[8oC\t\tY!A-MSN$\be^8sW\u0016\u0014\b%\u001b8g_Jl\u0017\r^5p]\u0002zg\r\t;iK\u0002\u001aXM\u001d<jG\u0016t\u0003%\u0013;!o&dG\u000e\t7jgR\u0004\u0013\r\u001c7!e\u0016<\u0017n\u001d;fe\u0016$\u0007e^8sW\u0016\u00148o\n\u0011j]\u001a|'/\\1uS>tg&A\u0007fq\u000edW\u000fZ3X_J\\WM\u001d\u000b\u0005\u0003#\t9\u0002E\u0002E\u0003'I1!!\u0006F\u00059A\u0015M\u001c3mKJ+7\u000f]8og\u0016Dq!!\u0007\u0006\u0001\u0004\tY\"A\u0004sKF,Xm\u001d;\u0011\u0007\u0011\u000bi\"C\u0002\u0002 \u0015\u0013A#\u0012=dYV$WmV8sW\u0016\u0014(+Z9vKN$\bfB\u0003\u0002$\u0005%\u00121\u0006\t\u0004\u001d\u0006\u0015\u0012bAA\u0014\u001f\n!\u0001+\u0019;i\u0003\u00151\u0018\r\\;fC\t\ti#\u0001\u00050Kb\u001cG.\u001e3fQ\r)\u0011\u0011\u0007\t\u0004\u001d\u0006M\u0012bAA\u001b\u001f\n!\u0001kT*UQ\u001d)\u0001\f[5l\u0003sa#!a\u000f,\r9$Xo^A\u001fW\u0011IH0a\u0010$\u0005\u0005E\u0001FB\u0003\u0000\u0003\u000f\t\u0019%\t\u0002\u0002F\u0005\ti$\u0012=dYV$W\r\u001a\u0011x_J\\WM]:!_\u001a\u0004C\u000f[3![\u0006\u001cH/\u001a:!C\u0012$\u0007e\u001c:!e\u0016lwN^3!i\",\u0007e^8sW\u0016\u0014\b%\\1ok\u0006dG.\u001f\u0011hSZ,g\u000eI<pe.,'\u000fI5e]\u0001\"\u0006.\u001a\u0011qCJ\fW.\u001a;fe\u0002\nG\r\u001a\u0011pe\u0002\u0012X-\\8wK\u0002\u001a\b/Z2jM&,7\u000f\t;iK\u0002*\u0007p\u00197vI\u0016$\u0007e^8sW\u0016\u00148\u000f\t;pA\u0005$G\rI8sAI,Wn\u001c<f]\u0005a\"/Z7pm\u0016<vN]6feN,f.\u0019<bS2\f'\r\\3J]\u001a|G\u0003BA\t\u0003\u0017Bq!!\u0007\u0007\u0001\u0004\ti\u0005E\u0002E\u0003\u001fJ1!!\u0015F\u0005\r\u0012V-\\8wK^{'o[3sgVs\u0017M^1jY\u0006\u0014G.Z%oM>\u0014V-];fgRDsABA\u0012\u0003S\t)&\t\u0002\u0002X\u0005\u0019rF]3n_Z,w,\u001e8bm\u0006LG.\u00192mK\"\u001aa!!\r)\u000f\u0019A\u0006.[6\u0002^1\u0012\u00111\b\u0015\u0007\r}\f9!!\u0019\"\u0005\u0005\r\u0014\u0001\u000e*f[>4X\r\t;iK\u0002:xN]6feN\u0004SO\\1wC&d\u0017M\u00197fA%tgm\u001c\u0011ge>l\u0007\u0005\u001e5fA5\f7\u000f^3s]\u0005aqo\u001c:lKJ,e/\u001a8ugR\u0011\u0011\u0011\u000e\t\u0004\t\u0006-\u0014bAA7\u000b\n!rk\u001c:lKJ,e/\u001a8ugJ+7\u000f]8og\u0016DsaBA\u0012\u0003S\t\t(\t\u0002\u0002t\u00059q&\u001a<f]R\u001c\bFA\u0004NQ\u001d9\u0001\f[5l\u0003sb#!a\u001f,\r9$Xo^A?W\u0011IH0a $\u0005\u0005%\u0004FB\u0004\u0000\u0003\u000f\t\u0019)\t\u0002\u0002\u0006\u0006QC*[:uA\u0005dG\u000eI<pe.,'\u000fI3wK:$\b%\u001b8g_N\u0004sN\u001a\u0011uQ\u0016\u0004S.Y:uKJt\u0013\u0001E:f]\u0012<vN]6fe\u00163XM\u001c;t)\u0011\t\t\"a#\t\u000f\u0005e\u0001\u00021\u0001\u0002\u000eB\u0019A)a$\n\u0007\u0005EUI\u0001\fTK:$wk\u001c:lKJ,e/\u001a8u%\u0016\fX/Z:uQ\u001dA\u00111EA\u0015\u0003cB3\u0001CA\u0019Q\u001dA\u0001\f[5l\u00033c#!a\u000f)\r!y\u0018qAAOC\t\ty*AA(\r>\u0014\b%T1ti\u0016\u0014\b\u0006T3bI\u0016\u0014\u0018\u0006I2b]\u0002\u001aXM\u001c3!o>\u00148.\u001a:!KZ,g\u000e\u001e\u0011u_\u0002j\u0017M\\1hKJ\u0004so\u001c:lKJ\u001ch\u0006\t'fO\u0006d\u0007\u0005^=qKN\u0004\u0013M]3!O9{e*R\u0014-A\u001dJU*T#E\u0013\u0006#V\tT-(Y\u0001:C)R\"P\u001b6K5kU%P\u001d\u001eb\u0003e\n#F\u0007>kU*S*T\u0013>sE\u000bS#O\u0013\u0012cUi\n\u0017!O\u001d\u0013\u0016iQ#G+2;C\u0006I\u0014S\u000b\u000e{U*T%T'&{ej\n\u0018\u0002%\u001d,GoV8sW\u0016\u00148\u000fV8q_2|w-\u001f\u000b\u0003\u0003K\u00032\u0001RAT\u0013\r\tI+\u0012\u0002\u0011)>\u0004x\u000e\\8hsJ+7\u000f]8og\u0016Ds!CA\u0012\u0003S\ti+\t\u0002\u00020\u0006Iq\u0006^8q_2|w-\u001f\u0015\u0003\u00135Cs!\u0003-iS.\f)\f\f\u0002\u00028.2a\u000e^;x\u0003s[C!\u001f?\u0002<\u000e\u0012\u0011Q\u0015\u0015\u0007\u0013}\f9!a0\"\u0005\u0005\u0005\u0017\u0001\f'jgR\u0004\u0013\r\u001c7!o>\u00148.\u001a:!i>\u0004x\u000e\\8hs\u0002JgNZ8!_\u001a\u0004C\u000f[3![\u0006\u001cH/\u001a:/\u0003E!xnV8sW\u0016\u0014XI^3oiRK\b/\u001a\u000b\u0005\u0003\u000f\f)\u000e\u0005\u0003\u0002J\u0006EWBAAf\u0015\u0011\ti-a4\u0002\u0011A\u0014x\u000e^8d_2T!a\u000b\r\n\t\u0005M\u00171\u001a\u0002\u0010/>\u00148.\u001a:Fm\u0016tG\u000fV=qK\"9\u0011q\u001b\u0006A\u0002\u0005e\u0017aB3v]6|%M\u001b\t\u0005\u00037\fyP\u0004\u0003\u0002^\u0006mh\u0002BAp\u0003stA!!9\u0002x:!\u00111]A{\u001d\u0011\t)/a=\u000f\t\u0005\u001d\u0018\u0011\u001f\b\u0005\u0003S\fy/\u0004\u0002\u0002l*\u0019\u0011Q\u001e\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012BA\u000e\u001d\u0013\tI\"$\u0003\u0002J1%\u0011Q\u0002S\u0005\u0003\r\u001eK1!!@F\u0003Y\u0019VM\u001c3X_J\\WM]#wK:$(+Z9vKN$\u0018\u0002\u0002B\u0001\u0005\u0007\u0011Q\"\u0012<f]R$\u0016\u0010]3F]Vl'bAA\u007f\u000b\":\u0001Aa\u0002\u0002*\t5\u0001c\u0001(\u0003\n%\u0019!1B(\u0003\u0011\r{gn];nKNd\u0013!\u001e\u0015\b\u0001\tE\u0011\u0011\u0006B\f!\rq%1C\u0005\u0004\u0005+y%\u0001\u0003)s_\u0012,8-Z:-\u0003UDs\u0001\u0001B\u000e\u0005O\u0011I\u0003\u0005\u0003\u0003\u001e\t\rRB\u0001B\u0010\u0015\r\u0011\t\u0003X\u0001\u0005i\u0006<7/\u0003\u0003\u0003&\t}!a\u0001+bO\u0006!a.Y7fC\t\u0011Y#\u0001\u0004X_J\\WM\u001d")
public class WorkerResource
implements ApiRequestContext {
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    public final HttpService httpService() {
        return ApiRequestContext.httpService$((ApiRequestContext)this);
    }

    public String normalizeParam(String param) {
        return ApiRequestContext.normalizeParam$((ApiRequestContext)this, (String)param);
    }

    public ServletContext servletContext() {
        return this.servletContext;
    }

    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    private Master master() {
        return (Master)this.httpService();
    }

    private AbstractMetaManager statusSystem() {
        return this.master().statusSystem();
    }

    @Operation(description="List worker information of the service. It will list all registered workers' information.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkersResponse.class))})
    @GET
    public WorkersResponse workers() {
        return new WorkersResponse().workers((List)JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.statusSystem().workersMap.values()).asScala()).map((Function1 & Serializable & scala.Serializable)workerInfo -> ApiUtils$.MODULE$.workerData(workerInfo), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSeq()).asJava()).lostWorkers((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.statusSystem().lostWorkers).asScala()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> (Long)x$1._2(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).map((Function1 & Serializable & scala.Serializable)kv -> new WorkerTimestampData().worker(ApiUtils$.MODULE$.workerData((WorkerInfo)kv._1())).timestamp((Long)kv._2()), Seq$.MODULE$.canBuildFrom())).asJava()).excludedWorkers((List)JavaConverters$.MODULE$.seqAsJavaListConverter(((SetLike)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.statusSystem().excludedWorkers).asScala()).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.statusSystem().manuallyExcludedWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)workerInfo -> ApiUtils$.MODULE$.workerData(workerInfo), Set$.MODULE$.canBuildFrom())).toSeq()).asJava()).manualExcludedWorkers((List)JavaConverters$.MODULE$.seqAsJavaListConverter(((SetLike)((scala.collection.SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.statusSystem().manuallyExcludedWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)workerInfo -> ApiUtils$.MODULE$.workerData(workerInfo), Set$.MODULE$.canBuildFrom())).toSeq()).asJava()).shutdownWorkers((List)JavaConverters$.MODULE$.seqAsJavaListConverter(((SetLike)((scala.collection.SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.statusSystem().shutdownWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)workerInfo -> ApiUtils$.MODULE$.workerData(workerInfo), Set$.MODULE$.canBuildFrom())).toSeq()).asJava()).decommissioningWorkers((List)JavaConverters$.MODULE$.seqAsJavaListConverter(((SetLike)((scala.collection.SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.statusSystem().decommissionWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)workerInfo -> ApiUtils$.MODULE$.workerData(workerInfo), Set$.MODULE$.canBuildFrom())).toSeq()).asJava());
    }

    @Operation(description="Excluded workers of the master add or remove the worker manually given worker id. The parameter add or remove specifies the excluded workers to add or remove.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    @Path(value="/exclude")
    public HandleResponse excludeWorker(ExcludeWorkerRequest request) {
        return (HandleResponse)MasterHttpResourceUtils$.MODULE$.ensureMasterIsLeader(this.master(), (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = this.httpService().exclude(((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(request.getAdd()).asScala()).map((Function1 & Serializable & scala.Serializable)workerId -> ApiUtils$.MODULE$.toWorkerInfo(workerId), Buffer$.MODULE$.canBuildFrom())).toSeq(), ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(request.getRemove()).asScala()).map((Function1 & Serializable & scala.Serializable)workerId -> ApiUtils$.MODULE$.toWorkerInfo(workerId), Buffer$.MODULE$.canBuildFrom())).toSeq());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            boolean success = tuple2._1$mcZ$sp();
            String msg = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)success), (Object)msg);
            boolean success2 = tuple22._1$mcZ$sp();
            String msg2 = (String)tuple22._2();
            return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(success2)).message(msg2);
        });
    }

    @Operation(description="Remove the workers unavailable info from the master.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    @Path(value="/remove_unavailable")
    public HandleResponse removeWorkersUnavailableInfo(RemoveWorkersUnavailableInfoRequest request) {
        return (HandleResponse)MasterHttpResourceUtils$.MODULE$.ensureMasterIsLeader(this.master(), (Function0 & Serializable & scala.Serializable)() -> {
            Tuple2<Object, String> tuple2 = this.master().removeWorkersUnavailableInfo((Seq<WorkerInfo>)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(request.getWorkers()).asScala()).map((Function1 & Serializable & scala.Serializable)workerId -> ApiUtils$.MODULE$.toWorkerInfo(workerId), Buffer$.MODULE$.canBuildFrom())).toSeq());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean success = tuple2._1$mcZ$sp();
            String msg = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)success), (Object)msg);
            boolean success2 = tuple22._1$mcZ$sp();
            String msg2 = (String)tuple22._2();
            return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(success2)).message(msg2);
        });
    }

    @Operation(description="List all worker event infos of the master.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkerEventsResponse.class))})
    @GET
    @Path(value="/events")
    public WorkerEventsResponse workerEvents() {
        return new WorkerEventsResponse().workerEvents((List)JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.statusSystem().workerEventInfos).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                WorkerInfo worker = (WorkerInfo)tuple2._1();
                WorkerEventInfo event = (WorkerEventInfo)tuple2._2();
                return new WorkerEventData().worker(ApiUtils$.MODULE$.workerData(worker)).event(new WorkerEventInfoData().eventType(event.getEventType().toString()).eventTime(Predef$.MODULE$.long2Long(event.getEventStartTime())));
            }
            throw new MatchError((Object)tuple2);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSeq()).asJava());
    }

    @Operation(description="For Master(Leader) can send worker event to manager workers. Legal types are 'NONE', 'IMMEDIATELY', 'DECOMMISSION', 'DECOMMISSIONTHENIDLE', 'GRACEFUL', 'RECOMMISSION'.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    @Path(value="/events")
    public HandleResponse sendWorkerEvents(SendWorkerEventRequest request) {
        return (HandleResponse)MasterHttpResourceUtils$.MODULE$.ensureMasterIsLeader(this.master(), (Function0 & Serializable & scala.Serializable)() -> {
            if (request.getEventType() == null || request.getWorkers().isEmpty()) {
                throw new BadRequestException(new StringBuilder(38).append("eventType(").append(request.getEventType()).append(") and workers(").append(request.getWorkers()).append(") are required").toString());
            }
            Seq workers = ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(request.getWorkers()).asScala()).map((Function1 & Serializable & scala.Serializable)workerId -> ApiUtils$.MODULE$.toWorkerInfo(workerId), Buffer$.MODULE$.canBuildFrom())).toSeq();
            Tuple2 tuple2 = workers.partition((Function1 & Serializable & scala.Serializable)w -> BoxesRunTime.boxToBoolean((boolean)this.statusSystem().workersMap.containsKey(w.toUniqueId())));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq filteredWorkers = (Seq)tuple2._1();
            Seq unknownWorkers = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)filteredWorkers, (Object)unknownWorkers);
            Seq filteredWorkers2 = (Seq)tuple22._1();
            Seq unknownWorkers2 = (Seq)tuple22._2();
            if (filteredWorkers2.isEmpty()) {
                throw new BadRequestException(new StringBuilder(31).append("None of the workers are known: ").append(((TraversableOnce)unknownWorkers2.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.readableAddress(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString());
            }
            Tuple2 tuple23 = this.httpService().handleWorkerEvent(this.toWorkerEventType(request.getEventType()), workers);
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            boolean success = tuple23._1$mcZ$sp();
            String msg = (String)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)success), (Object)msg);
            boolean success2 = tuple24._1$mcZ$sp();
            String msg2 = (String)tuple24._2();
            String finalMsg = unknownWorkers2.isEmpty() ? msg2 : new StringBuilder(20).append(msg2).append("\n(Unknown workers: ").append(((TraversableOnce)unknownWorkers2.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.readableAddress(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(")").toString();
            return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(success2)).message(finalMsg);
        });
    }

    @Operation(description="List all worker topology info of the master.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=TopologyResponse.class))})
    @GET
    @Path(value="/topology")
    public TopologyResponse getWorkersTopology() {
        return new TopologyResponse().topologies((List)JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.statusSystem().workersMap.values()).asScala()).groupBy((Function1 & Serializable & scala.Serializable)x$8 -> x$8.networkLocation()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String networkLocation = (String)tuple2._1();
                Iterable workers = (Iterable)tuple2._2();
                return new TopologyInfo().networkLocation(networkLocation).workers((List)JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)workers.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toUniqueId(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSeq()).asJava());
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq()).asJava());
    }

    private WorkerEventType toWorkerEventType(SendWorkerEventRequest.EventTypeEnum eunmObj) {
        SendWorkerEventRequest.EventTypeEnum eventTypeEnum = eunmObj;
        if (SendWorkerEventRequest.EventTypeEnum.NONE.equals(eventTypeEnum)) {
            return WorkerEventType.None;
        }
        if (SendWorkerEventRequest.EventTypeEnum.IMMEDIATELY.equals(eventTypeEnum)) {
            return WorkerEventType.Immediately;
        }
        if (SendWorkerEventRequest.EventTypeEnum.DECOMMISSION.equals(eventTypeEnum)) {
            return WorkerEventType.Decommission;
        }
        if (SendWorkerEventRequest.EventTypeEnum.DECOMMISSIONTHENIDLE.equals(eventTypeEnum)) {
            return WorkerEventType.DecommissionThenIdle;
        }
        if (SendWorkerEventRequest.EventTypeEnum.GRACEFUL.equals(eventTypeEnum)) {
            return WorkerEventType.Graceful;
        }
        if (SendWorkerEventRequest.EventTypeEnum.RECOMMISSION.equals(eventTypeEnum)) {
            return WorkerEventType.Recommission;
        }
        return WorkerEventType.UNRECOGNIZED;
    }

    public WorkerResource() {
        ApiRequestContext.$init$((ApiRequestContext)this);
    }
}

