/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.bugs;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.bugs.FirstChildBean;
import org.apache.commons.beanutils.bugs.RootBean;
import org.apache.commons.beanutils.bugs.SecondChildBean;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class Jira422TestCase {
    @BeforeClass
    public static void assumeSupportsIndexedLists() throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(RootBean.class);
        for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
            if (!pd.getName().equals("file")) continue;
            Assume.assumeTrue((String)"BEANUTILS-492: IndexedPropertyDescriptor no longer supported for java.util.List", (boolean)(pd instanceof IndexedPropertyDescriptor));
            return;
        }
        Assert.fail((String)"Could not find PropertyDescriptor for 'file'");
    }

    @Test
    public void testRootBean() throws Exception {
        FirstChildBean bean = new FirstChildBean();
        Class propertyType = PropertyUtils.getPropertyType((Object)bean, (String)"file[0]");
        Assert.assertEquals((Object)String.class.getName(), (Object)propertyType.getName());
    }

    @Test
    public void testSecondChildBean() throws Exception {
        SecondChildBean bean = new SecondChildBean();
        Class propertyType = PropertyUtils.getPropertyType((Object)bean, (String)"file[0]");
        Assert.assertEquals((Object)String.class.getName(), (Object)propertyType.getName());
    }
}

