/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.collections4.OrderedMapIterator;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.iterators.AbstractOrderedMapIteratorTest;
import org.apache.commons.collections4.iterators.UnmodifiableOrderedMapIterator;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableOrderedMapIteratorTest<K, V>
extends AbstractOrderedMapIteratorTest<K, V> {
    @Override
    public Map<K, V> getConfirmedMap() {
        TreeMap<String, String> testMap = new TreeMap<String, String>();
        testMap.put("A", "a");
        testMap.put("B", "b");
        testMap.put("C", "c");
        return testMap;
    }

    @Override
    public OrderedMap<K, V> getMap() {
        ListOrderedMap testMap = ListOrderedMap.listOrderedMap(new HashMap());
        testMap.put((Object)"A", (Object)"a");
        testMap.put((Object)"B", (Object)"b");
        testMap.put((Object)"C", (Object)"c");
        return testMap;
    }

    @Override
    public OrderedMapIterator<K, V> makeEmptyIterator() {
        return UnmodifiableOrderedMapIterator.unmodifiableOrderedMapIterator((OrderedMapIterator)ListOrderedMap.listOrderedMap(new HashMap()).mapIterator());
    }

    @Override
    public OrderedMapIterator<K, V> makeObject() {
        return UnmodifiableOrderedMapIterator.unmodifiableOrderedMapIterator((OrderedMapIterator)this.getMap().mapIterator());
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Override
    public boolean supportsSetValue() {
        return false;
    }

    @Test
    public void testDecorateFactory() {
        OrderedMapIterator it = this.makeObject();
        Assertions.assertSame(it, (Object)UnmodifiableOrderedMapIterator.unmodifiableOrderedMapIterator(it));
        it = this.getMap().mapIterator();
        Assertions.assertNotSame((Object)it, (Object)UnmodifiableOrderedMapIterator.unmodifiableOrderedMapIterator((OrderedMapIterator)it));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableOrderedMapIterator.unmodifiableOrderedMapIterator(null));
    }

    @Test
    public void testOrderedMapIterator() {
        Assertions.assertTrue((boolean)(this.makeEmptyIterator() instanceof Unmodifiable));
    }
}

