/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Collections;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.arj.ArjArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class DetectArchiverTest
extends AbstractTest {
    final ClassLoader classLoader = this.getClass().getClassLoader();

    private void checkDetectedType(String type, Path path) throws ArchiveException, IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            Assertions.assertEquals((Object)("jar".equals(type) ? "zip" : type), (Object)ArchiveStreamFactory.detect((InputStream)inputStream));
        }
    }

    private void checkEmptyArchive(String type) throws Exception {
        Path path = this.createEmptyArchive(type);
        Assertions.assertDoesNotThrow(() -> {
            try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
                ArchiveInputStream ais = this.factory.createArchiveInputStream((InputStream)inputStream);
                if (ais != null) {
                    ais.close();
                }
            }
        }, (String)("Should have recognized empty archive for " + type));
        this.checkDetectedType(type, path);
    }

    private <T extends ArchiveInputStream<? extends E>, E extends ArchiveEntry> T createArchiveInputStream(String resource) throws ArchiveException, IOException {
        return (T)this.factory.createArchiveInputStream((InputStream)this.createBufferedInputStream(resource));
    }

    private BufferedInputStream createBufferedInputStream(String resource) throws IOException {
        return new BufferedInputStream(DetectArchiverTest.newInputStream(resource));
    }

    private boolean isValidName(String value) {
        return value.isEmpty() || value.chars().allMatch(ch -> ch > 31 && ch < 128);
    }

    @Test
    void testCOMPRESS_117() throws Exception {
        try (Object tar = this.createArchiveInputStream("COMPRESS-117.tar");){
            Assertions.assertNotNull(tar);
            Assertions.assertInstanceOf(TarArchiveInputStream.class, tar);
        }
    }

    @Test
    void testCOMPRESS_335() throws Exception {
        try (Object tar = this.createArchiveInputStream("COMPRESS-335.tar");){
            Assertions.assertNotNull(tar);
            Assertions.assertInstanceOf(TarArchiveInputStream.class, tar);
        }
    }

    @Test
    void testDetection() throws Exception {
        try (Object ar = this.createArchiveInputStream("bla.ar");){
            Assertions.assertNotNull(ar);
            Assertions.assertInstanceOf(ArArchiveInputStream.class, ar);
        }
        try (Object tar = this.createArchiveInputStream("bla.tar");){
            Assertions.assertNotNull(tar);
            Assertions.assertInstanceOf(TarArchiveInputStream.class, tar);
        }
        try (Object zip = this.createArchiveInputStream("bla.zip");){
            Assertions.assertNotNull(zip);
            Assertions.assertInstanceOf(ZipArchiveInputStream.class, zip);
        }
        try (Object jar = this.createArchiveInputStream("bla.jar");){
            Assertions.assertNotNull(jar);
            Assertions.assertInstanceOf(ZipArchiveInputStream.class, jar);
        }
        try (Object cpio = this.createArchiveInputStream("bla.cpio");){
            Assertions.assertNotNull(cpio);
            Assertions.assertInstanceOf(CpioArchiveInputStream.class, cpio);
        }
        try (Object arj = this.createArchiveInputStream("bla.arj");){
            Assertions.assertNotNull(arj);
            Assertions.assertInstanceOf(ArjArchiveInputStream.class, arj);
        }
    }

    @Test
    void testDetectionNotArchive() {
        Assertions.assertThrows(ArchiveException.class, () -> this.createArchiveInputStream("test.txt"));
    }

    @Test
    void testDetectOldTarFormatArchive() throws Exception {
        try (Object tar = this.createArchiveInputStream("COMPRESS-612/test-times-star-folder.tar");){
            Assertions.assertNotNull(tar);
            Assertions.assertInstanceOf(TarArchiveInputStream.class, tar);
        }
    }

    @Test
    void testEmptyCpioArchive() throws Exception {
        this.checkEmptyArchive("cpio");
    }

    @Test
    void testEmptyJarArchive() throws Exception {
        this.checkEmptyArchive("jar");
    }

    @Test
    void testEmptyTarArchive() throws Exception {
        Path path = this.createEmptyArchive("tar");
        Assertions.assertThrows(ArchiveException.class, () -> this.checkDetectedType("tar", path));
    }

    @Test
    void testEmptyZipArchive() throws Exception {
        this.checkEmptyArchive("zip");
    }

    @Test
    void testIcoFile() {
        Assertions.assertThrows(ArchiveException.class, () -> {
            try (BufferedInputStream in = this.createBufferedInputStream("org/apache/commons/compress/COMPRESS-644/ARW05UP.ICO");){
                Assertions.assertNull((Object)ArchiveStreamFactory.detect((InputStream)in));
            }
        });
    }

    @Test
    void testIcoFileFirstTarArchiveEntry() throws Exception {
        try (TarArchiveInputStream inputStream = new TarArchiveInputStream((InputStream)this.createBufferedInputStream("org/apache/commons/compress/COMPRESS-644/ARW05UP.ICO"));){
            TarArchiveEntry entry = inputStream.getNextEntry();
            Assertions.assertNull((Object)entry.getCreationTime());
            Assertions.assertEquals((long)-1L, (long)entry.getDataOffset());
            Assertions.assertEquals((int)0, (int)entry.getDevMajor());
            Assertions.assertEquals((int)0, (int)entry.getDevMinor());
            Assertions.assertEquals(Collections.emptyMap(), (Object)entry.getExtraPaxHeaders());
            Assertions.assertEquals((int)0, (int)entry.getGroupId());
            Assertions.assertFalse((boolean)this.isValidName(entry.getGroupName()), () -> ((TarArchiveEntry)entry).getGroupName());
            Assertions.assertNull((Object)entry.getLastAccessTime());
            Assertions.assertEquals((long)0L, (long)entry.getLastModifiedDate().getTime());
            Assertions.assertEquals((Object)FileTime.from(Instant.EPOCH), (Object)entry.getLastModifiedTime());
            Assertions.assertEquals((int)0, (int)entry.getLinkFlag());
            Assertions.assertEquals((Object)"", (Object)entry.getLinkName());
            Assertions.assertEquals((long)0L, (long)entry.getLongGroupId());
            Assertions.assertEquals((long)0xFFFFFFL, (long)entry.getLongUserId());
            Assertions.assertEquals((int)0, (int)entry.getMode());
            Assertions.assertEquals((long)0L, (long)entry.getModTime().getTime());
            Assertions.assertFalse((boolean)this.isValidName(entry.getName()), () -> ((TarArchiveEntry)entry).getName());
            Assertions.assertNull((Object)entry.getPath());
            Assertions.assertEquals((long)0L, (long)entry.getRealSize());
            Assertions.assertEquals((long)0L, (long)entry.getSize());
            Assertions.assertNull((Object)entry.getStatusChangeTime());
            Assertions.assertEquals((int)0xFFFFFF, (int)entry.getUserId());
            Assertions.assertFalse((boolean)this.isValidName(entry.getUserName()), () -> ((TarArchiveEntry)entry).getUserName());
            Assertions.assertTrue((boolean)entry.isFile());
            Assertions.assertFalse((boolean)entry.isBlockDevice());
            Assertions.assertFalse((boolean)entry.isCharacterDevice());
            Assertions.assertTrue((boolean)entry.isCheckSumOK());
            Assertions.assertFalse((boolean)entry.isDirectory());
            Assertions.assertFalse((boolean)entry.isExtended());
            Assertions.assertFalse((boolean)entry.isFIFO());
            Assertions.assertFalse((boolean)entry.isGlobalPaxHeader());
            Assertions.assertFalse((boolean)entry.isGNULongLinkEntry());
            Assertions.assertFalse((boolean)entry.isGNULongNameEntry());
            Assertions.assertFalse((boolean)entry.isGNUSparse());
            Assertions.assertFalse((boolean)entry.isLink());
            Assertions.assertFalse((boolean)entry.isOldGNUSparse());
            Assertions.assertFalse((boolean)entry.isPaxGNU1XSparse());
            Assertions.assertFalse((boolean)entry.isPaxGNUSparse());
            Assertions.assertFalse((boolean)entry.isPaxHeader());
            Assertions.assertFalse((boolean)entry.isSparse());
            Assertions.assertFalse((boolean)entry.isStarSparse());
            Assertions.assertTrue((boolean)entry.isStreamContiguous());
            Assertions.assertFalse((boolean)entry.isSymbolicLink());
        }
    }
}

