/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache.extras.writer;

import java.util.HashMap;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import org.apache.commons.jcs3.jcache.extras.InternalCacheRule;
import org.apache.commons.jcs3.jcache.extras.writer.CacheWriterAdapter;
import org.apache.commons.jcs3.jcache.extras.writer.CompositeCacheWriter;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CompositeCacheWriterTest {
    @Rule
    public final InternalCacheRule rule = new InternalCacheRule(this);
    private final Map<String, String> copy1 = new HashMap<String, String>();
    private final Map<String, String> copy2 = new HashMap<String, String>();
    private final CacheWriterAdapter<String, String> writer1 = new CacheWriterAdapter<String, String>(){

        public void write(Cache.Entry<? extends String, ? extends String> entry) throws CacheWriterException {
            CompositeCacheWriterTest.this.copy1.put((String)entry.getKey(), (String)entry.getValue());
        }

        public void delete(Object key) throws CacheWriterException {
            CompositeCacheWriterTest.this.copy1.remove(key);
        }
    };
    private final CacheWriterAdapter<String, String> writer2 = new CacheWriterAdapter<String, String>(){

        public void write(Cache.Entry<? extends String, ? extends String> entry) throws CacheWriterException {
            CompositeCacheWriterTest.this.copy2.put((String)entry.getKey(), (String)entry.getValue());
        }

        public void delete(Object key) throws CacheWriterException {
            CompositeCacheWriterTest.this.copy2.remove(key);
        }
    };
    private final Configuration<?, ?> config = new MutableConfiguration().setStoreByValue(false).setWriteThrough(true).setCacheWriterFactory((Factory)new CompositeCacheWriter(new CacheWriter[]{this.writer1, this.writer2}));
    private Cache<String, String> cache;

    @Test
    public void checkComposite() {
        this.cache.put((Object)"a", (Object)"b");
        Assert.assertEquals((Object)"b", (Object)this.copy1.get("a"));
        Assert.assertEquals((Object)"b", (Object)this.copy2.get("a"));
        Assert.assertEquals((long)1L, (long)this.copy1.size());
        Assert.assertEquals((long)1L, (long)this.copy2.size());
        this.cache.remove((Object)"a");
        Assert.assertTrue((boolean)this.copy1.isEmpty());
        Assert.assertTrue((boolean)this.copy2.isEmpty());
    }
}

