/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jxpath.JXPathBasicBeanInfo;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.MapDynamicPropertyHandler;
import org.apache.commons.jxpath.util.ClassLoaderUtil;

public class JXPathIntrospector {
    private static Map<Class, JXPathBeanInfo> byClass = Collections.synchronizedMap(new HashMap());
    private static Map<Class, JXPathBeanInfo> byInterface = Collections.synchronizedMap(new HashMap());

    private static JXPathBeanInfo findDynamicBeanInfo(Class beanClass) {
        Class sup;
        JXPathBeanInfo beanInfo;
        if (beanClass.isInterface() && (beanInfo = byInterface.get(beanClass)) != null && beanInfo.isDynamic()) {
            return beanInfo;
        }
        Class<?>[] interfaces = beanClass.getInterfaces();
        if (interfaces != null) {
            for (Class<?> element : interfaces) {
                beanInfo = JXPathIntrospector.findDynamicBeanInfo(element);
                if (beanInfo == null || !beanInfo.isDynamic()) continue;
                return beanInfo;
            }
        }
        if ((sup = beanClass.getSuperclass()) != null) {
            beanInfo = byClass.get(sup);
            if (beanInfo != null && beanInfo.isDynamic()) {
                return beanInfo;
            }
            return JXPathIntrospector.findDynamicBeanInfo(sup);
        }
        return null;
    }

    private static synchronized JXPathBeanInfo findInformant(Class beanClass) {
        String name = beanClass.getName() + "XBeanInfo";
        try {
            return (JXPathBeanInfo)JXPathIntrospector.instantiate(beanClass, name);
        }
        catch (Exception exception) {
            try {
                if (JXPathBeanInfo.class.isAssignableFrom(beanClass)) {
                    return (JXPathBeanInfo)beanClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JXPathBeanInfo getBeanInfo(Class beanClass) {
        JXPathBeanInfo beanInfo = byClass.get(beanClass);
        if (beanInfo == null) {
            beanInfo = JXPathIntrospector.findDynamicBeanInfo(beanClass);
            if (beanInfo == null && (beanInfo = JXPathIntrospector.findInformant(beanClass)) == null) {
                beanInfo = new JXPathBasicBeanInfo(beanClass);
            }
            Map<Class, JXPathBeanInfo> map = byClass;
            synchronized (map) {
                byClass.put(beanClass, beanInfo);
            }
        }
        return beanInfo;
    }

    private static Object instantiate(Class sibling, String className) throws Exception {
        ClassLoader cl = sibling.getClassLoader();
        if (cl != null) {
            try {
                Class<?> cls = cl.loadClass(className);
                return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ClassLoaderUtil.getClass(className, true).newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAtomicClass(Class beanClass) {
        Map<Class, JXPathBeanInfo> map = byClass;
        synchronized (map) {
            byClass.put(beanClass, new JXPathBasicBeanInfo(beanClass, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDynamicClass(Class beanClass, Class dynamicPropertyHandlerClass) {
        JXPathBasicBeanInfo bi = new JXPathBasicBeanInfo(beanClass, dynamicPropertyHandlerClass);
        if (beanClass.isInterface()) {
            Map<Class, JXPathBeanInfo> map = byInterface;
            synchronized (map) {
                byInterface.put(beanClass, bi);
            }
        }
        Map<Class, JXPathBeanInfo> map = byClass;
        synchronized (map) {
            byClass.put(beanClass, bi);
        }
    }

    @Deprecated
    public JXPathIntrospector() {
    }

    static {
        JXPathIntrospector.registerAtomicClass(Class.class);
        JXPathIntrospector.registerAtomicClass(Boolean.TYPE);
        JXPathIntrospector.registerAtomicClass(Boolean.class);
        JXPathIntrospector.registerAtomicClass(Byte.TYPE);
        JXPathIntrospector.registerAtomicClass(Byte.class);
        JXPathIntrospector.registerAtomicClass(Character.TYPE);
        JXPathIntrospector.registerAtomicClass(Character.class);
        JXPathIntrospector.registerAtomicClass(Short.TYPE);
        JXPathIntrospector.registerAtomicClass(Short.class);
        JXPathIntrospector.registerAtomicClass(Integer.TYPE);
        JXPathIntrospector.registerAtomicClass(Integer.class);
        JXPathIntrospector.registerAtomicClass(Long.TYPE);
        JXPathIntrospector.registerAtomicClass(Long.class);
        JXPathIntrospector.registerAtomicClass(Float.TYPE);
        JXPathIntrospector.registerAtomicClass(Float.class);
        JXPathIntrospector.registerAtomicClass(Double.TYPE);
        JXPathIntrospector.registerAtomicClass(Double.class);
        JXPathIntrospector.registerAtomicClass(String.class);
        JXPathIntrospector.registerAtomicClass(java.util.Date.class);
        JXPathIntrospector.registerAtomicClass(Date.class);
        JXPathIntrospector.registerAtomicClass(Time.class);
        JXPathIntrospector.registerAtomicClass(Timestamp.class);
        JXPathIntrospector.registerDynamicClass(Map.class, MapDynamicPropertyHandler.class);
    }
}

