/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.functions.ConstructorFunction;
import org.apache.commons.jxpath.functions.MethodFunction;
import org.apache.commons.jxpath.util.ClassLoaderUtil;
import org.apache.commons.jxpath.util.MethodLookupUtils;
import org.apache.commons.jxpath.util.TypeUtils;

public class PackageFunctions
implements Functions {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final String classPrefix;
    private final String namespace;

    public PackageFunctions(String classPrefix, String namespace) {
        this.classPrefix = classPrefix;
        this.namespace = namespace;
    }

    @Override
    public Function getFunction(String namespace, String name, Object[] parameters) {
        Class functionClass;
        String fullName;
        int inx;
        if (!Objects.equals(this.namespace, namespace)) {
            return null;
        }
        if (parameters == null) {
            parameters = EMPTY_ARRAY;
        }
        if (parameters.length >= 1) {
            Method method;
            List<Pointer> target = TypeUtils.convert(parameters[0], Object.class);
            if (target != null) {
                method = MethodLookupUtils.lookupMethod(target.getClass(), name, parameters);
                if (method != null) {
                    return new MethodFunction(method);
                }
                if (target instanceof NodeSet) {
                    target = ((NodeSet)((Object)target)).getPointers();
                }
                if ((method = MethodLookupUtils.lookupMethod(target.getClass(), name, parameters)) != null) {
                    return new MethodFunction(method);
                }
                if (target instanceof Collection) {
                    Iterator iter = ((Collection)target).iterator();
                    if (iter.hasNext()) {
                        target = iter.next();
                        if (target instanceof Pointer) {
                            target = ((Pointer)((Object)target)).getValue();
                        }
                    } else {
                        target = null;
                    }
                }
            }
            if (target != null && (method = MethodLookupUtils.lookupMethod(target.getClass(), name, parameters)) != null) {
                return new MethodFunction(method);
            }
        }
        if ((inx = (fullName = this.classPrefix + name).lastIndexOf(46)) == -1) {
            return null;
        }
        String className = fullName.substring(0, inx);
        String methodName = fullName.substring(inx + 1);
        try {
            functionClass = ClassLoaderUtil.getClass(className, true);
        }
        catch (ClassNotFoundException ex) {
            throw new JXPathException("Cannot invoke extension function " + (namespace != null ? namespace + ":" + name : name), ex);
        }
        if (methodName.equals("new")) {
            Constructor constructor = MethodLookupUtils.lookupConstructor(functionClass, parameters);
            if (constructor != null) {
                return new ConstructorFunction(constructor);
            }
        } else {
            Method method = MethodLookupUtils.lookupStaticMethod(functionClass, methodName, parameters);
            if (method != null) {
                return new MethodFunction(method);
            }
        }
        return null;
    }

    @Override
    public Set<String> getUsedNamespaces() {
        return Collections.singleton(this.namespace);
    }
}

